/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.FindClub.controller;

import com.rugaa.FindClub.model.CustomerGallery;
import com.rugaa.FindClub.request.CustomerGalleryRequest;
import com.rugaa.FindClub.service.CustomerGalleryService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/customer-galleries"})
public class CustomerGalleryController {
    @Autowired
    private CustomerGalleryService customerGalleryService;

    @GetMapping(value={"/fetchall"})
    public ResponseEntity<List<CustomerGallery>> getAllGalleries(@RequestHeader(value="Authorization") String token) {
        List galleries = this.customerGalleryService.getAllGalleries(token);
        if (galleries != null) {
            return ResponseEntity.ok((Object)galleries);
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
    }

    @GetMapping(value={"/fetch"})
    public ResponseEntity<List<CustomerGallery>> getGalleryById(@RequestHeader(value="Authorization") String token) {
        try {
            List gallery = this.customerGalleryService.getGallery(token);
            if (gallery != null && !gallery.isEmpty()) {
                return ResponseEntity.ok((Object)gallery);
            }
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<CustomerGallery> getGalleryById(@PathVariable Long id) {
        Optional gallery = this.customerGalleryService.getGalleryById(id);
        return gallery.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build());
    }

    @PostMapping(value={"/save/{customerId}"})
    public ResponseEntity<CustomerGallery> createGallery(@RequestBody CustomerGalleryRequest gallery, @PathVariable Long customerId) {
        System.out.println("Received request for creating gallery:");
        System.out.println("Customer ID: " + customerId);
        System.out.println("Gallery Request: " + gallery);
        CustomerGallery createdGallery = this.customerGalleryService.createGallery(gallery, customerId);
        if (createdGallery != null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)createdGallery);
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<CustomerGallery> updateGallery(@PathVariable Long id, @RequestBody CustomerGallery updatedGallery) {
        CustomerGallery gallery = this.customerGalleryService.updateGallery(id, updatedGallery);
        if (gallery != null) {
            return ResponseEntity.ok((Object)gallery);
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteGallery(@PathVariable Long id) {
        boolean isDeleted = this.customerGalleryService.deleteGallery(id);
        if (isDeleted) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build();
    }
}

