/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.FindClub.controller;

import com.rugaa.FindClub.model.Customer;
import com.rugaa.FindClub.request.CustomerRequest;
import com.rugaa.FindClub.response.AuthenticationResponse;
import com.rugaa.FindClub.service.CustomerService;
import com.rugaa.FindClub.service.UserPhotoService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/customer"})
public class CustomerController {
    @Autowired
    private CustomerService customerService;
    @Autowired
    UserPhotoService photoService;

    @PutMapping(value={"/save"})
    public ResponseEntity<AuthenticationResponse> createUser(@RequestBody CustomerRequest request) {
        try {
            AuthenticationResponse authResponse = this.customerService.createUser(request);
            return ResponseEntity.status((int)201).body((Object)authResponse);
        }
        catch (Exception e) {
            AuthenticationResponse errorResponse = new AuthenticationResponse();
            return ResponseEntity.status((int)500).body((Object)errorResponse);
        }
    }

    @GetMapping(value={"/findall"})
    public ResponseEntity<?> getAllUserModel() {
        try {
            List userModels = this.customerService.getAllUserModel();
            if (userModels.isEmpty()) {
                return ResponseEntity.status((int)404).body((Object)"Not found the customer id");
            }
            return ResponseEntity.ok((Object)userModels);
        }
        catch (Exception e) {
            return ResponseEntity.status((int)500).body((Object)("An error occurred while find the customer:" + e.getMessage()));
        }
    }

    @GetMapping(value={"/findbyid/{id}"})
    public ResponseEntity<?> findUserModelById(@PathVariable(value="id") long userId) {
        try {
            Optional usOptional = this.customerService.findUserModelById(userId);
            return ResponseEntity.ok((Object)usOptional);
        }
        catch (Exception e) {
            return ResponseEntity.status((int)500).body((Object)("An error occurred while find the customer:" + e.getMessage()));
        }
    }

    @DeleteMapping(value={"/deletebyid/{id}"})
    public ResponseEntity<String> deleteUserModelById(@PathVariable(value="id") long userId) {
        try {
            this.customerService.deleteUserModelById(userId);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)"Delete the customer id successfully");
        }
        catch (ResponseStatusException e) {
            return ResponseEntity.status((HttpStatusCode)e.getStatusCode()).body((Object)e.getReason());
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred while delete the customer:" + e.getMessage()));
        }
    }

    @PostMapping(value={"/updatebyid/{id}"})
    public ResponseEntity<String> updateUserModelById(@PathVariable(value="id") long userId, @RequestBody CustomerRequest request) {
        try {
            Customer userModel = this.customerService.updateUserModelById(userId, request);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)("updated the customer id Successfully:" + userModel.getUserid()));
        }
        catch (ResponseStatusException e) {
            return ResponseEntity.status((HttpStatusCode)e.getStatusCode()).body((Object)e.getReason());
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred while update the customer:" + e.getMessage()));
        }
    }

    @PostMapping(value={"/check"})
    public ByteArrayResource checkMobile(@RequestParam String url) {
        return this.photoService.uploadAndGenerateQRCode(url);
    }
}

