/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.FindClub.controller;

import com.rugaa.FindClub.model.ClubModel;
import com.rugaa.FindClub.request.ClubRequest;
import com.rugaa.FindClub.response.AuthenticationResponse;
import com.rugaa.FindClub.service.ClubModelServices;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/club"})
public class ClubModelController {
    @Autowired
    private ClubModelServices clubModelServices;

    @PutMapping(value={"/save"})
    public ResponseEntity<AuthenticationResponse> createUser(@RequestBody ClubRequest request) {
        try {
            AuthenticationResponse authResponse = this.clubModelServices.saveUser(request);
            return ResponseEntity.status((int)201).body((Object)authResponse);
        }
        catch (Exception e) {
            AuthenticationResponse errorResponse = new AuthenticationResponse();
            return ResponseEntity.status((int)500).body((Object)errorResponse);
        }
    }

    @GetMapping(value={"/fetchall"})
    public ResponseEntity<?> fetchAllUser(@RequestHeader(value="Authorization") String as) {
        try {
            List clubModels = this.clubModelServices.fetchAllUser(as);
            if (clubModels.isEmpty()) {
                return ResponseEntity.status((int)204).body((Object)"No club found");
            }
            return ResponseEntity.ok((Object)clubModels);
        }
        catch (Exception e) {
            return ResponseEntity.status((int)500).body((Object)("An Error occurred while retrieving the club:" + e.getMessage()));
        }
    }

    @GetMapping(value={"/findbyid/{id}"})
    public ResponseEntity<?> findUserById(@PathVariable(value="id") long clubId) {
        try {
            ClubModel clubModel = this.clubModelServices.findUserById(clubId);
            return ResponseEntity.ok((Object)clubModel);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred while retrieving the club: " + e.getMessage()));
        }
    }

    @DeleteMapping(value={"/deletebyid/{id}"})
    public ResponseEntity<String> deleteUserById(@PathVariable(value="id") long clubId) {
        try {
            this.clubModelServices.deleteUserById(clubId);
            return ResponseEntity.ok((Object)"club Id DeletedSuccessfully!!");
        }
        catch (ResponseStatusException e) {
            return ResponseEntity.status((HttpStatusCode)e.getStatusCode()).body((Object)e.getReason());
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("A Error occurred while delete club id:" + e.getMessage()));
        }
    }

    @PostMapping(value={"/updatebyid/{id}"})
    public ResponseEntity<String> updateUserById(@PathVariable(value="id") long clubId, @RequestBody ClubRequest request) {
        try {
            ClubModel clubModel = this.clubModelServices.updateUserById(clubId, request);
            return ResponseEntity.ok((Object)("club Id updated successfully!!" + clubModel.getId()));
        }
        catch (ResponseStatusException e) {
            return ResponseEntity.status((HttpStatusCode)e.getStatusCode()).body((Object)e.getReason());
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("A Error occurred while update the club:" + e.getMessage()));
        }
    }

    @GetMapping(value={"/getlocation"})
    public ResponseEntity<?> fetchAllLocation() {
        try {
            List clubModels = this.clubModelServices.fetchAllLocation();
            return ResponseEntity.ok((Object)clubModels);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/findlocation"})
    public ResponseEntity<?> findByLocation(@RequestParam String location) {
        try {
            List clubOptional = this.clubModelServices.findByLocation(location);
            return ResponseEntity.ok((Object)clubOptional);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/fetchbyclubid/{id}"})
    public ResponseEntity<?> findByClub(@PathVariable Long id) {
        try {
            List clubModels = this.clubModelServices.findByClubId(id);
            return ResponseEntity.ok((Object)clubModels);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }
}

