/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.FindClub.controller;

import com.rugaa.FindClub.model.Booking;
import com.rugaa.FindClub.request.BookingRequest;
import com.rugaa.FindClub.request.ResponseBannerDTO;
import com.rugaa.FindClub.service.BookingServices;
import com.rugaa.FindClub.service.UserPhotoService;
import jakarta.persistence.EntityNotFoundException;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/booking"})
public class BookingController {
    @Autowired
    private BookingServices bookingServices;
    @Autowired
    UserPhotoService photoService;

    @PostMapping(value={"/uploadphoto"})
    public ResponseBannerDTO addProfile(@RequestParam(value="file") MultipartFile file) {
        try {
            return this.photoService.addProfile(file);
        }
        catch (Exception e) {
            return null;
        }
    }

    @PostMapping(value={"/save"})
    public ResponseEntity<?> createBooking(@RequestBody BookingRequest bookingRequest) {
        try {
            Booking booking = this.bookingServices.createBooking(bookingRequest);
            return ResponseEntity.status((int)200).body((Object)booking);
        }
        catch (Exception e) {
            return ResponseEntity.status((int)500).body((Object)("An error occurred while Booking created:" + e.getMessage()));
        }
    }

    @GetMapping(value={"/findall"})
    public ResponseEntity<?> findAllBooking(@RequestHeader(value="Authorization") String as) {
        try {
            List booking = this.bookingServices.findAllBooking(as);
            if (booking.isEmpty()) {
                return ResponseEntity.status((int)404).body((Object)"Not found booking:");
            }
            return ResponseEntity.ok((Object)booking);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred while find the booking:" + e.getMessage()));
        }
    }

    @GetMapping(value={"/history"})
    public ResponseEntity<?> findAllBookingHistory(@RequestHeader(value="Authorization") String as) {
        try {
            List booking = this.bookingServices.findAllBookingHistory(as);
            if (booking.isEmpty()) {
                return ResponseEntity.status((int)404).body((Object)"Not found booking:");
            }
            return ResponseEntity.ok((Object)booking);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred while find the booking:" + e.getMessage()));
        }
    }

    @GetMapping(value={"/id/{id}"})
    public ResponseEntity<?> findBookingById(@PathVariable(value="id") long bookId) {
        try {
            Optional bookOptional = this.bookingServices.findBookingById(bookId);
            return ResponseEntity.ok((Object)bookOptional);
        }
        catch (Exception e) {
            return ResponseEntity.status((int)500).body((Object)("An error occurred while find the booking:" + e.getMessage()));
        }
    }

    @DeleteMapping(value={"/delete/id/{id}"})
    public ResponseEntity<String> deleteBookingById(@PathVariable(value="id") long bookId) {
        try {
            this.bookingServices.deleteBookingById(bookId);
            return ResponseEntity.ok((Object)"Delete Booking id is successfully!!");
        }
        catch (ResponseStatusException e) {
            return ResponseEntity.status((HttpStatusCode)e.getStatusCode()).body((Object)e.getReason());
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred while delete booking:" + e.getMessage()));
        }
    }

    @PostMapping(value={"/update/id/{id}"})
    public ResponseEntity<String> updateBookingById(@PathVariable(value="id") long bookId, @RequestBody BookingRequest bookingRequest) {
        try {
            Booking booking = this.bookingServices.updateBookingById(bookId, bookingRequest);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)("Booking is updated successfully:" + booking.getBookId()));
        }
        catch (ResponseStatusException e) {
            return ResponseEntity.status((HttpStatusCode)e.getStatusCode()).body((Object)e.getReason());
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred while updated booking" + e.getMessage()));
        }
    }

    @PostMapping(value={"/confirm/status/{id}"})
    public ResponseEntity<String> checkConfirmStatus(@PathVariable(value="id") long bookId, @RequestBody BookingRequest request) {
        try {
            Booking booking = this.bookingServices.checkConfirmStatus(bookId, request);
            return ResponseEntity.ok(null);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred while booking id is confirm:" + e.getMessage()));
        }
    }

    @GetMapping(value={"/getallclub/{id}"})
    public ResponseEntity<?> getAllClub(@PathVariable Long id) {
        try {
            List bookings = this.bookingServices.getAllClub(id);
            return new ResponseEntity((Object)bookings, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
    }

    @GetMapping(value={"/finduserid/{id}"})
    public ResponseEntity<?> findByUserId(@PathVariable Long id) {
        try {
            List bookings = this.bookingServices.findByUserId(id);
            return ResponseEntity.ok((Object)bookings);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PostMapping(value={"/update-status/{id}"})
    public ResponseEntity<Booking> updateBookingStatus(@PathVariable long id) {
        try {
            Booking updatedBooking = this.bookingServices.updatebookingstatus(id);
            return new ResponseEntity((Object)updatedBooking, (HttpStatusCode)HttpStatus.OK);
        }
        catch (EntityNotFoundException e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        catch (Exception e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

