/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.FindClub.controller;

import com.rugaa.FindClub.model.Role;
import com.rugaa.FindClub.request.PasswordChangeRequest;
import com.rugaa.FindClub.request.UserDto;
import com.rugaa.FindClub.service.AuthenticationService;
import com.rugaa.FindClub.service.PasswordChangeServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/auth"})
public class AuthenticationController {
    @Autowired
    private PasswordChangeServiceImpl changeServiceImpl;
    @Autowired
    private AuthenticationService authenticationService;

    @PostMapping(value={"/change-password"})
    public ResponseEntity<?> changePassword(@RequestBody PasswordChangeRequest changeRequest, @RequestHeader(value="Authorization") String token) {
        try {
            return this.changeServiceImpl.changePassword(changeRequest, token);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"An error occurred while changing password.");
        }
    }

    @PutMapping(value={"/forgotpassword"})
    public ResponseEntity<?> forgotpassword(@RequestBody UserDto request) throws Exception {
        return ResponseEntity.ok((Object)this.changeServiceImpl.forgotpassword(request));
    }

    @PutMapping(value={"/sendotp"})
    public ResponseEntity<?> sendotp(@RequestBody UserDto request) throws Exception {
        System.out.println("cont1");
        return ResponseEntity.ok((Object)this.changeServiceImpl.sendOtpForAccountCreation(request));
    }

    @PutMapping(value={"/forgototp"})
    public ResponseEntity<?> forgototp(@RequestBody UserDto request) throws Exception {
        System.out.println("cont1");
        return ResponseEntity.ok((Object)this.changeServiceImpl.forgotpassotp(request));
    }

    @PutMapping(value={"/otpverification"})
    public ResponseEntity<?> otpverification(@RequestBody UserDto request) throws Exception {
        System.out.println("cont1");
        return ResponseEntity.ok((Object)this.changeServiceImpl.verifyOtpForAccountCreation(request));
    }

    @PutMapping(value={"/check-email"})
    public ResponseEntity<?> checkEmail(@RequestParam String email, Role role) {
        try {
            return this.authenticationService.checkEmail(email, role);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred while checkEamil:" + e.getMessage()));
        }
    }

    @PutMapping(value={"/check-mobile"})
    public ResponseEntity<?> checkMobileNumber(@RequestParam(value="mobile") Long mobileNumber, Role role) {
        try {
            return this.authenticationService.checkMobileNumber(mobileNumber, role);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred while checkMobile number:" + e.getMessage()));
        }
    }
}

