/*
 * Decompiled with CFR 0.152.
 */
package com.riot.Branding.service;

import com.riot.Branding.model.Wishes;
import com.riot.Branding.repository.WishesRepository;
import com.riot.Branding.request.WishesRequest;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WishesService {
    @Autowired
    private WishesRepository wishesRepository;

    public Wishes createWish(WishesRequest wishesRequest) {
        try {
            Wishes wish = new Wishes();
            wish.setTitle(wishesRequest.getTitle());
            wish.setWishestype(wishesRequest.getWishestype());
            wish.setPoster(wishesRequest.getPoster());
            wish.setDescription(wishesRequest.getDescription());
            wish.setSetdate(wishesRequest.getSetdate());
            wish.setSettime(wishesRequest.getSettime());
            wish.setDaysbefore(wishesRequest.getDaysbefore());
            wish.setBrandid(wishesRequest.getBrandid());
            wish.setGmid(wishesRequest.getGmid());
            return (Wishes)this.wishesRepository.save((Object)wish);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating wish: " + e.getMessage());
        }
    }

    public List<Wishes> getAllWishes(String wishes) {
        try {
            return this.wishesRepository.findByWishestype(wishes);
        }
        catch (Exception e) {
            throw new RuntimeException("Error retrieving wishes: " + e.getMessage());
        }
    }

    public Wishes getWishById(Long id) {
        try {
            Optional wish = this.wishesRepository.findById((Object)id);
            if (wish.isPresent()) {
                return (Wishes)wish.get();
            }
            throw new RuntimeException("Wish not found with id: " + id);
        }
        catch (Exception e) {
            throw new RuntimeException("Error retrieving wish: " + e.getMessage());
        }
    }

    public Wishes updateWish(Long id, WishesRequest wishesRequest) {
        try {
            Optional existingWish = this.wishesRepository.findById((Object)id);
            if (existingWish.isPresent()) {
                Wishes wish = (Wishes)existingWish.get();
                wish.setTitle(wishesRequest.getTitle());
                wish.setWishestype(wishesRequest.getWishestype());
                wish.setPoster(wishesRequest.getPoster());
                wish.setDescription(wishesRequest.getDescription());
                wish.setSetdate(wishesRequest.getSetdate());
                wish.setSettime(wishesRequest.getSettime());
                wish.setDaysbefore(wishesRequest.getDaysbefore());
                wish.setBrandid(wishesRequest.getBrandid());
                wish.setGmid(wishesRequest.getGmid());
                return (Wishes)this.wishesRepository.save((Object)wish);
            }
            throw new RuntimeException("Wish not found with id: " + id);
        }
        catch (Exception e) {
            throw new RuntimeException("Error updating wish: " + e.getMessage());
        }
    }

    public void deleteWish(Long id) {
        try {
            Optional existingWish = this.wishesRepository.findById((Object)id);
            if (!existingWish.isPresent()) {
                throw new RuntimeException("Wish not found with id: " + id);
            }
            this.wishesRepository.delete((Object)((Wishes)existingWish.get()));
        }
        catch (Exception e) {
            throw new RuntimeException("Error deleting wish: " + e.getMessage());
        }
    }

    public int getTodayBirthdayWishesCount() {
        LocalDate today = LocalDate.now();
        return this.wishesRepository.countByWishTypeAndSetDateAndSended("Birthday", today);
    }

    public int getTodayAnniversaryWishesCount() {
        LocalDate today = LocalDate.now();
        return this.wishesRepository.countByWishTypeAndSetDateAndSended("Anniversary", today);
    }
}

