/*
 * Decompiled with CFR 0.152.
 */
package com.riot.Branding.service;

import com.riot.Branding.model.VendorModel;
import com.riot.Branding.repository.VendorRepository;
import com.riot.Branding.request.VendorRequest;
import com.riot.Branding.service.StockService;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class VendorServiceImpl {
    @Autowired
    private VendorRepository vendorRepository;
    @Autowired
    private StockService service;

    public ResponseEntity<String> checkEmailExists(String email) {
        try {
            Optional userOptional = this.vendorRepository.findByEmail(email);
            if (userOptional.isPresent()) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)"Email is already registered.");
            }
            return ResponseEntity.ok((Object)"Email is available for registration.");
        }
        catch (Exception e) {
            System.err.println("Error checking email existence: " + e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"An error occurred while checking the email.");
        }
    }

    public ResponseEntity<String> checkMobileExists(Long mobile) {
        try {
            Optional userByMobile = this.vendorRepository.findByMobile(mobile);
            if (userByMobile.isPresent()) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)"Mobile number is already registered.");
            }
            return ResponseEntity.ok((Object)"Mobile number is available for registration.");
        }
        catch (Exception e) {
            System.err.println("Error checking mobile existence: " + e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"An error occurred while checking the mobile number.");
        }
    }

    public VendorModel addVendor(VendorRequest request) {
        try {
            VendorModel vendor = new VendorModel();
            vendor.setV_name(request.getV_name());
            vendor.setAddress(request.getAddress());
            vendor.setGstno(request.getGstno());
            vendor.setCity(request.getCity());
            vendor.setDistrict(request.getDistrict());
            vendor.setState(request.getState());
            vendor.setPincode(request.getPincode());
            if (request.getProductDealing() == null || request.getProductDealing().isEmpty()) {
                throw new IllegalArgumentException("Product dealing list cannot be null or empty");
            }
            vendor.setProductDealing(new ArrayList(request.getProductDealing()));
            if (request.getCategoryid() == null || request.getCategoryid().isEmpty()) {
                throw new IllegalArgumentException("Category ID list cannot be null or empty");
            }
            vendor.setCategoryid(new ArrayList(request.getCategoryid()));
            vendor.setEmail(request.getEmail());
            vendor.setMobile(request.getMobile());
            return (VendorModel)this.vendorRepository.save((Object)vendor);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to add vendor: " + e.getMessage(), e);
        }
    }

    public VendorModel updateVendor(Long id, VendorRequest request) {
        try {
            Optional existingVendorOpt = this.vendorRepository.findById((Object)id);
            if (existingVendorOpt.isPresent()) {
                List newCategories;
                VendorModel vendor = (VendorModel)existingVendorOpt.get();
                vendor.setV_name(request.getV_name());
                vendor.setAddress(request.getAddress());
                vendor.setGstno(request.getGstno());
                vendor.setCity(request.getCity());
                vendor.setDistrict(request.getDistrict());
                vendor.setState(request.getState());
                vendor.setPincode(request.getPincode());
                vendor.setMobile(request.getMobile());
                vendor.setEmail(request.getEmail());
                List newProducts = request.getProductDealing();
                if (newProducts != null) {
                    ArrayList updatedProducts = new ArrayList(newProducts);
                    vendor.setProductDealing(updatedProducts);
                }
                if ((newCategories = request.getCategoryid()) != null) {
                    ArrayList updatedCategories = new ArrayList(newCategories);
                    vendor.setCategoryid(updatedCategories);
                }
                return (VendorModel)this.vendorRepository.save((Object)vendor);
            }
            throw new RuntimeException("Vendor not found with id: " + id);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to update vendor: " + e.getMessage(), e);
        }
    }

    public void deleteVendor(Long id) {
        try {
            if (!this.vendorRepository.existsById((Object)id)) {
                throw new RuntimeException("Vendor not found with id: " + id);
            }
            this.vendorRepository.deleteById((Object)id);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to delete vendor: " + e.getMessage(), e);
        }
    }

    public VendorModel getVendorById(Long id) {
        try {
            return (VendorModel)this.vendorRepository.findById((Object)id).orElseThrow(() -> new RuntimeException("Vendor not found with id: " + id));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retrieve vendor: " + e.getMessage(), e);
        }
    }

    public List<VendorRequest> getAllVendors() {
        try {
            List vendors = this.vendorRepository.findAll();
            return vendors.stream().map(arg_0 -> this.convertToVendorRequest(arg_0)).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retrieve all vendors: " + e.getMessage(), e);
        }
    }

    private VendorRequest convertToVendorRequest(VendorModel vendorModel) {
        VendorRequest vendorRequest = new VendorRequest();
        try {
            vendorRequest.setId(vendorModel.getId());
            vendorRequest.setV_name(vendorModel.getV_name());
            vendorRequest.setAddress(vendorModel.getAddress());
            vendorRequest.setGstno(vendorModel.getGstno());
            vendorRequest.setCity(vendorModel.getCity());
            vendorRequest.setDistrict(vendorModel.getDistrict());
            vendorRequest.setState(vendorModel.getState());
            vendorRequest.setPincode(vendorModel.getPincode());
            vendorRequest.setMobile(vendorModel.getMobile());
            vendorRequest.setEmail(vendorModel.getEmail());
            vendorRequest.setProductDealing(vendorModel.getProductDealing() != null ? vendorModel.getProductDealing() : new ArrayList());
            List categoryIds = vendorModel.getCategoryid() != null ? vendorModel.getCategoryid() : new ArrayList();
            vendorRequest.setCategoryid(categoryIds);
            ArrayList<String> categoryNames = new ArrayList<String>();
            for (Long categoryId : categoryIds) {
                if (categoryId == null) continue;
                String categoryName = this.service.getcategoryname(categoryId);
                categoryNames.add(categoryName);
            }
            vendorRequest.setCategory(categoryNames);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to convert vendor data: " + e.getMessage(), e);
        }
        return vendorRequest;
    }

    public List<VendorModel> findVendorsByProductDealing(String dealing) {
        try {
            return this.vendorRepository.findByProductDealingContaining(dealing);
        }
        catch (Exception e) {
            throw new RuntimeException("Error retrieving vendors: " + e.getMessage(), e);
        }
    }

    public List<VendorModel> findVendorsByCategory(Long category) {
        try {
            return this.vendorRepository.findByCategoryidContaining(category);
        }
        catch (Exception e) {
            throw new RuntimeException("Error retrieving vendors: " + e.getMessage(), e);
        }
    }
}

