/*
 * Decompiled with CFR 0.152.
 */
package com.riot.Branding.service;

import com.riot.Branding.model.BrandModel;
import com.riot.Branding.model.DesignationModel;
import com.riot.Branding.model.Role;
import com.riot.Branding.model.User;
import com.riot.Branding.model.UserRegionModel;
import com.riot.Branding.repository.BrandRepository;
import com.riot.Branding.repository.DesignationRepository;
import com.riot.Branding.repository.UserRegionRepository;
import com.riot.Branding.repository.UserRepository;
import com.riot.Branding.request.UserProfileRequest;
import com.riot.Branding.request.UserRequest;
import com.riot.Branding.response.AuthenticationResponse;
import com.riot.Branding.response.RMWithGM;
import com.riot.Branding.response.UserFieldResponse;
import com.riot.Branding.response.UserResponse;
import com.riot.Branding.security.JwtService;
import com.riot.Branding.service.AuthenticationService;
import com.riot.Branding.service.OTPService;
import com.riot.Branding.service.UserService;
import com.riot.Branding.utils.JavaSendapi;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class UserServiceImpl
implements UserService {
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private DesignationRepository designationRepository;
    @Autowired
    private BrandRepository brandRepository;
    @Autowired
    private JwtService jwtService;
    @Autowired
    private JavaSendapi emailSendingUtil;
    @Autowired
    private AuthenticationService authenticationService;
    @Autowired
    private UserRegionRepository userRegionRepository;

    public ResponseEntity<String> checkEmailExists(String email) {
        try {
            Optional userOptional = this.userRepository.findByEmail(email);
            if (userOptional.isPresent()) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)"Email is already registered.");
            }
            return ResponseEntity.ok((Object)"Email is available for registration.");
        }
        catch (Exception e) {
            System.err.println("Error checking email existence: " + e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"An error occurred while checking the email.");
        }
    }

    public ResponseEntity<String> checkMobileExists(Long mobile) {
        try {
            Optional userByMobile = this.userRepository.findByMobileAndStatus(mobile, true);
            if (userByMobile.isPresent()) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)"Mobile number is already registered.");
            }
            return ResponseEntity.ok((Object)"Mobile number is available for registration.");
        }
        catch (Exception e) {
            System.err.println("Error checking mobile existence: " + e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"An error occurred while checking the mobile number.");
        }
    }

    private String generateUserCode(String bname) {
        String prefix = bname != null && bname.length() >= 3 ? bname.substring(0, 3).toUpperCase() : bname.toUpperCase().concat("---").substring(0, 3);
        String lastCode = this.userRepository.findTopByUsercodeStartingWithOrderByUsercodeDesc(prefix).map(User::getUsercode).orElse(null);
        int nextNumber = 1;
        if (lastCode != null && lastCode.startsWith(prefix)) {
            try {
                String numericPart = lastCode.substring(prefix.length());
                nextNumber = Integer.parseInt(numericPart) + 1;
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Failed to parse the numeric part of the last user code: " + lastCode, e);
            }
        }
        return prefix + String.format("%04d", nextNumber);
    }

    public AuthenticationResponse addUser(UserRequest userRequest) {
        try {
            DesignationModel designation = this.getDesignationById(userRequest.getDesignationid());
            String designationName = designation.getDesignation();
            User user = this.mapToEntity(userRequest);
            if (userRequest.getProfile() == null) {
                user.setProfile("https://storage.megashop.my/FindClub/16112024213328714.jpeg");
            } else {
                user.setProfile(userRequest.getProfile());
            }
            String bname = this.brandname(userRequest.getBrandid());
            user.setUsercode(this.generateUserCode(bname));
            String otp = OTPService.generateOTP();
            if (userRequest.getPassword() == null) {
                userRequest.setPassword(otp);
            }
            if (designationName.equalsIgnoreCase("GM")) {
                user.setAccess(Boolean.valueOf(true));
                user.setRole(Role.GM);
            } else if (designationName.equalsIgnoreCase("RM")) {
                user.setAccess(Boolean.valueOf(true));
                user.setRole(Role.RM);
            } else if (designationName.equalsIgnoreCase("MKTG REF")) {
                user.setAccess(Boolean.valueOf(false));
                user.setRole(Role.USER);
            } else if (designationName.equalsIgnoreCase("MKTG COORDINATOR")) {
                user.setAccess(Boolean.valueOf(false));
                user.setRole(Role.USER);
            }
            user.setPassword(this.passwordEncoder.encode((CharSequence)otp));
            User savedUser = (User)this.userRepository.save((Object)user);
            String jwtToken = this.jwtService.generateToken((UserDetails)savedUser);
            if (userRequest.getEmail() != null) {
                this.sendWelcomeEmailAsync(userRequest.getEmail(), savedUser.getUsercode(), otp);
            }
            return AuthenticationResponse.builder().token(jwtToken).build();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to save User: " + e.getMessage());
        }
    }

    public List<RMWithGM> getUsersByBrandAndDesignation(Long brandId, Long designationId) {
        String work;
        DesignationModel desgn;
        List gmUsers;
        DesignationModel designation = this.getDesignationById(designationId);
        BrandModel brand = (BrandModel)this.brandRepository.findById((Object)brandId).orElseThrow(() -> new RuntimeException("Brand not found"));
        String des = designation.getDesignation();
        String brandname = brand.getB_name();
        ArrayList<RMWithGM> results = new ArrayList<RMWithGM>();
        if (des.equals("RM")) {
            gmUsers = this.userRepository.findByBrandidAndDesignationidAndStatus(brandId, this.getDesignationId("GM"), true);
            for (Object gmUser : gmUsers) {
                desgn = this.getDesignationById(gmUser.getDesignationid());
                work = desgn.getDesignation();
                results.add(new RMWithGM(null, (User)gmUser, brandname, work));
            }
        } else if (des.equals("MKTG REF")) {
            List rmUsers = this.userRepository.findByBrandidAndDesignationidAndStatus(brandId, this.getDesignationId("RM"), true);
            List gmUsers2 = this.userRepository.findByBrandidAndDesignationidAndStatus(brandId, this.getDesignationId("GM"), true);
            for (User rmUser : rmUsers) {
                DesignationModel desgn2 = this.getDesignationById(rmUser.getDesignationid());
                String work2 = desgn2.getDesignation();
                results.add(new RMWithGM(rmUser, null, brandname, work2));
            }
            for (User gmUser : gmUsers2) {
                boolean alreadyAdded = results.stream().anyMatch(result -> result.getGmUser() != null && result.getGmUser().equals((Object)gmUser));
                if (alreadyAdded) continue;
                DesignationModel desgn3 = this.getDesignationById(gmUser.getDesignationid());
                String work3 = desgn3.getDesignation();
                results.add(new RMWithGM(null, gmUser, brandname, work3));
            }
        } else if (des.equals("MKTG COORDINATOR")) {
            gmUsers = this.userRepository.findByBrandidAndDesignationidAndStatus(brandId, this.getDesignationId("GM"), true);
            for (Object gmUser : gmUsers) {
                desgn = this.getDesignationById(gmUser.getDesignationid());
                String work4 = desgn.getDesignation();
                results.add(new RMWithGM(null, (User)gmUser, brandname, work4));
            }
        }
        if (results.isEmpty()) {
            gmUsers = this.userRepository.findByBrandidAndDesignationidAndStatus(brandId, this.getDesignationId("GM"), true);
            for (Object gmUser : gmUsers) {
                desgn = this.getDesignationById(gmUser.getDesignationid());
                work = desgn.getDesignation();
                results.add(new RMWithGM(null, (User)gmUser, brandname, work));
            }
        }
        return results;
    }

    private DesignationModel getDesignationById(Long designationId) {
        return (DesignationModel)this.designationRepository.findById((Object)designationId).orElseThrow(() -> new RuntimeException("Designation not found"));
    }

    private Long getDesignationId(String designationName) {
        Optional designation = this.designationRepository.findByDesignation(designationName);
        return ((DesignationModel)designation.orElseThrow(() -> new RuntimeException("Designation not found"))).getDesignationid();
    }

    public User updateUser(Long id, UserRequest userRequest) {
        try {
            Optional userOptional = this.userRepository.findById((Object)id);
            if (userOptional.isPresent()) {
                User user = this.mapToEntity(userRequest);
                DesignationModel designation = this.getDesignationById(userRequest.getDesignationid());
                if (Boolean.TRUE.equals(userRequest.getStatus()) && designation.getDesignation().equalsIgnoreCase("GM")) {
                    user.setAccess(Boolean.valueOf(true));
                    user.setRole(Role.GM);
                } else if (Boolean.TRUE.equals(userRequest.getStatus()) && Boolean.TRUE.equals(userRequest.getAccess()) && designation.getDesignation().equalsIgnoreCase("RM")) {
                    user.setAccess(Boolean.valueOf(true));
                    user.setRole(Role.RM);
                } else if (Boolean.TRUE.equals(userRequest.getStatus()) && Boolean.TRUE.equals(userRequest.getAccess())) {
                    user.setRole(Role.ADMIN);
                } else {
                    user.setRole(Role.USER);
                }
                user.setPassword(((User)userOptional.get()).getPassword());
                user.setId(id);
                return (User)this.userRepository.save((Object)user);
            }
            throw new RuntimeException("User not found with id: " + id);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to update User: " + e.getMessage());
        }
    }

    public User updateByUserProfile(Long id, UserProfileRequest userRequest, String token) {
        try {
            Optional userOptional = this.userRepository.findById((Object)id);
            if (userOptional.isPresent()) {
                User user = (User)userOptional.get();
                this.updateUserProfile(user, userRequest);
                return (User)this.userRepository.save((Object)user);
            }
            throw new RuntimeException("User not found with id: " + id);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to update User: " + e.getMessage());
        }
    }

    private void updateUserProfile(User user, UserProfileRequest userRequest) {
        user.setName(userRequest.getName());
        user.setMobile(userRequest.getMobile());
        user.setCountry(userRequest.getCountry());
        user.setState(userRequest.getState());
        user.setCity(userRequest.getCity());
        user.setArea(userRequest.getArea());
        user.setAddress(userRequest.getAddress());
        user.setProfile(userRequest.getProfile());
    }

    public User updateUserStatus(Long id, UserRequest userRequest) {
        try {
            User user = (User)this.userRepository.findById((Object)id).orElseThrow(() -> new RuntimeException("User not found with id: " + id));
            if (userRequest.getAccess() != null) {
                user.setAccess(userRequest.getAccess());
            }
            if (userRequest.getStatus() != null) {
                user.setStatus(userRequest.getStatus());
                if (Boolean.FALSE.equals(userRequest.getStatus())) {
                    user.setReason(userRequest.getReason());
                    user.setPeriod(userRequest.getPeriod());
                }
            }
            return (User)this.userRepository.save((Object)user);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to update User: " + e.getMessage(), e);
        }
    }

    public List<String> getAllRegions() {
        return this.userRepository.findAllDistinctRegions();
    }

    public User findUserById(Long id) {
        try {
            return (User)this.userRepository.findById((Object)id).orElseThrow(() -> new RuntimeException("User not found with id: " + id));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to find User: " + e.getMessage());
        }
    }

    public String mailsend(Long id) {
        try {
            User user = (User)this.userRepository.findById((Object)id).orElseThrow(() -> new RuntimeException("User not found with id: " + id));
            String otp = OTPService.generateOTP();
            user.setPassword(this.passwordEncoder.encode((CharSequence)otp));
            this.userRepository.save((Object)user);
            if (user.getEmail() != null) {
                this.sendWelcomeEmailAsync(user.getEmail(), user.getUsercode(), otp);
            }
            return "CREDENTIAL SENDED SUCESSFULLY";
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to find User: " + e.getMessage());
        }
    }

    public UserProfileRequest getProfileByuser(String token) {
        try {
            UserResponse response = this.authenticationService.getDetails(token);
            Optional userProfileOpt = this.userRepository.findById((Object)response.getId());
            if (userProfileOpt.isPresent()) {
                User user = (User)userProfileOpt.get();
                UserProfileRequest userProfileRequest = new UserProfileRequest();
                userProfileRequest.setId(user.getId());
                userProfileRequest.setName(user.getName());
                userProfileRequest.setDesignation(this.designationname(user.getDesignationid()));
                userProfileRequest.setBrandname(this.brandname(user.getBrandid()));
                userProfileRequest.setGuidename(this.guidename(user.getGuideid()));
                userProfileRequest.setMobile(user.getMobile());
                userProfileRequest.setCountry(user.getCountry());
                userProfileRequest.setState(user.getState());
                userProfileRequest.setCity(user.getCity());
                userProfileRequest.setArea(user.getArea());
                userProfileRequest.setAddress(user.getAddress());
                userProfileRequest.setProfile(user.getProfile());
                return userProfileRequest;
            }
            throw new RuntimeException("User not found with ID: " + response.getId());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to find User: " + e.getMessage());
        }
    }

    public List<UserFieldResponse> findAllUsers(String token) {
        try {
            UserResponse response = this.authenticationService.getDetails(token);
            User userdetail = this.findUserById(response.getId());
            List<Object> filteredUsers = new ArrayList();
            if (response.getRole().equals((Object)Role.SUPERADMIN)) {
                List allUsers = this.userRepository.findAll();
                filteredUsers = allUsers.stream().filter(user -> !Role.SUPERADMIN.equals((Object)user.getRole()) && !Role.ADMIN.equals((Object)user.getRole())).collect(Collectors.toList());
                System.out.println("SUPERADMIN View - Filtered Users Count: " + filteredUsers.size());
            } else if (response.getRole().equals((Object)Role.GM) || response.getRole().equals((Object)Role.RM)) {
                List rmUsers = this.userRepository.findByGuideidAndRoleAndStatus(response.getId(), Role.RM, true);
                ArrayList marketingUsersFromRMs = new ArrayList();
                for (User rmUser : rmUsers) {
                    List mktgUsers = this.userRepository.findByGuideidAndRoleAndStatus(rmUser.getId(), Role.USER, true);
                    marketingUsersFromRMs.addAll(mktgUsers);
                }
                List directMarketingUsers = this.userRepository.findByGuideidAndRoleAndStatus(response.getId(), Role.USER, true);
                ArrayList allMarketingUsers = new ArrayList();
                allMarketingUsers.addAll(marketingUsersFromRMs);
                allMarketingUsers.addAll(directMarketingUsers);
                Long loggedInUserBrandId = userdetail.getBrandid();
                filteredUsers = allMarketingUsers.stream().filter(user -> loggedInUserBrandId.equals(user.getBrandid())).collect(Collectors.toList());
                System.out.println("GM/RM View - Filtered Users Count: " + filteredUsers.size());
            } else if (response.getRole().equals((Object)Role.RM)) {
                ArrayList marketingUsersFromRMs = new ArrayList();
                List mktgUsers = this.userRepository.findByGuideidAndRoleAndStatus(response.getId(), Role.USER, true);
                marketingUsersFromRMs.addAll(mktgUsers);
                List directMarketingUsers = this.userRepository.findByGuideidAndRoleAndStatus(response.getId(), Role.USER, true);
                ArrayList allMarketingUsers = new ArrayList();
                allMarketingUsers.addAll(marketingUsersFromRMs);
                allMarketingUsers.addAll(directMarketingUsers);
                Long loggedInUserBrandId = userdetail.getBrandid();
                filteredUsers = allMarketingUsers.stream().filter(user -> loggedInUserBrandId.equals(user.getBrandid())).collect(Collectors.toList());
                System.out.println("GM/RM View - Filtered Users Count: " + filteredUsers.size());
            } else {
                List usersWithSameBrand = this.userRepository.findByBrandid(userdetail.getBrandid());
                filteredUsers = usersWithSameBrand.stream().filter(user -> !Role.SUPERADMIN.equals((Object)user.getRole()) && !Role.ADMIN.equals((Object)user.getRole())).collect(Collectors.toList());
                System.out.println("Standard User View - Filtered Users Count: " + filteredUsers.size());
            }
            return filteredUsers.stream().map(arg_0 -> this.convertToDTO(arg_0)).collect(Collectors.toList());
        }
        catch (Exception e) {
            System.err.println("Error fetching users: " + e.getMessage());
            throw new RuntimeException("Failed to get all Users: " + e.getMessage());
        }
    }

    public List<UserFieldResponse> findAllAdmins(String token) {
        try {
            UserResponse response = this.authenticationService.getDetails(token);
            User userdetail = this.findUserById(response.getId());
            if (response.getRole().equals((Object)Role.SUPERADMIN)) {
                List userResponse = this.userRepository.findAll();
                List filteredAdmins = userResponse.stream().filter(user -> Role.ADMIN.equals((Object)user.getRole())).collect(Collectors.toList());
                return filteredAdmins.stream().map(arg_0 -> this.convertToDTO(arg_0)).collect(Collectors.toList());
            }
            throw new RuntimeException("Only SUPERADMIN can fetch admin users");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get Admin users: " + e.getMessage());
        }
    }

    private UserFieldResponse convertToDTO(User user) {
        UserFieldResponse dto = new UserFieldResponse();
        dto.setId(user.getId());
        dto.setName(user.getName());
        dto.setBrandid(user.getBrandid());
        dto.setDesignationid(user.getDesignationid());
        dto.setGuideid(user.getGuideid());
        dto.setBrand(this.brandname(user.getBrandid()));
        dto.setDesignation(this.designationname(user.getDesignationid()));
        dto.setGuidename(this.guidename(user.getGuideid()));
        dto.setEmail(user.getEmail());
        dto.setJoiningdate(user.getJoiningdate());
        dto.setMobile(user.getMobile());
        dto.setCountry(user.getCountry());
        dto.setState(user.getState());
        dto.setCity(user.getCity());
        dto.setArea(user.getArea());
        dto.setAddress(user.getAddress());
        dto.setStatus(user.getStatus());
        dto.setAccess(user.getAccess());
        dto.setUsercode(user.getUsercode());
        dto.setReason(user.getReason());
        dto.setPeriod(user.getPeriod());
        dto.setRegion(user.getRegion());
        return dto;
    }

    private User userProfile(UserProfileRequest userRequest) {
        User dto = new User();
        dto.setId(userRequest.getId());
        dto.setName(userRequest.getName());
        dto.setMobile(userRequest.getMobile());
        dto.setCountry(userRequest.getCountry());
        dto.setState(userRequest.getState());
        dto.setCity(userRequest.getCity());
        dto.setArea(userRequest.getArea());
        dto.setAddress(userRequest.getAddress());
        dto.setProfile(userRequest.getProfile());
        return dto;
    }

    public List<User> getAllUsers() {
        try {
            return this.userRepository.findAll();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get all Users: " + e.getMessage());
        }
    }

    public void deleteUserById(Long id) {
        try {
            if (!this.userRepository.existsById((Object)id)) {
                throw new RuntimeException("User not found with id: " + id);
            }
            this.userRepository.deleteById((Object)id);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to delete User: " + e.getMessage());
        }
    }

    private void sendWelcomeEmailAsync(String email, String userCode, String otp) {
        String body = "<html><p>Welcome to SAKTHIGROUP!</p><p>Your account has been successfully created. Below are your login credentials:</p><p><strong>Login ID:</strong> " + userCode + "</p><p><strong>Password:</strong> " + otp + "</p><p>Please keep this information secure and do not share it with anyone.</p><p>If you have any questions or need assistance, feel free to contact our support team.</p><br><p>Best regards,</p><p>The SAKTHIGROUP Team</p><p><a href='mailto:noreplyinfo@sakthigroup.co'>noreplyinfo@sakthigroup.co</a></p><p><a href='https://app.sakthisteels.com'>sakthigroup.com</a></p></html>";
        String subject = "SAKTHIGROUP Login Credentials";
        CompletableFuture.runAsync(() -> {
            try {
                this.emailSendingUtil.sendMailBody(email, body, subject);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private User mapToEntity(UserRequest userRequest) {
        User user = new User();
        user.setEmail(userRequest.getEmail());
        user.setMobile(userRequest.getMobile());
        user.setGuideid(userRequest.getGuideid());
        user.setName(userRequest.getName());
        user.setBrandid(userRequest.getBrandid());
        user.setDesignationid(userRequest.getDesignationid());
        user.setJoiningdate(userRequest.getJoiningdate());
        user.setCountry(userRequest.getCountry());
        user.setState(userRequest.getState());
        user.setCity(userRequest.getCity());
        user.setArea(userRequest.getArea());
        user.setAddress(userRequest.getAddress());
        user.setStatus(userRequest.getStatus());
        user.setUsercode(userRequest.getUsercode());
        user.setRegion(userRequest.getRegion());
        return user;
    }

    public List<DesignationModel> addDesignation(DesignationModel designationModel) {
        try {
            if (designationModel.getDesignation() == null || designationModel.getDesignation().trim().isEmpty()) {
                throw new IllegalArgumentException("Designation is mandatory.");
            }
            Optional existingDesignation = this.designationRepository.findByDesignation(designationModel.getDesignation());
            if (existingDesignation.isEmpty()) {
                this.designationRepository.save((Object)designationModel);
            }
            return this.designationRepository.findAll();
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Validation error: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to add designation.", e);
        }
    }

    public List<DesignationModel> getAllDesignation() {
        try {
            return this.designationRepository.findAll();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retrieve all designations.", e);
        }
    }

    public List<User> getUsersByBrandId(Long brandId, Long id) {
        try {
            User user = (User)this.userRepository.findById((Object)id).orElseThrow(() -> new RuntimeException("Role not found with ID: " + id));
            Long designation = user.getDesignationid();
            return this.userRepository.findByBrandidAndDesignationid(brandId, designation);
        }
        catch (Exception e) {
            throw new RuntimeException("Error retrieving users: " + e.getMessage());
        }
    }

    public List<User> getAllByDesignation() {
        try {
            Long id = 3L;
            return this.userRepository.findByDesignationidAndStatus(id, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retrieve all designations.", e);
        }
    }

    public String brandname(Long id) {
        if (id == null) {
            return "N/A";
        }
        Optional brand = this.brandRepository.findById((Object)id);
        return brand.map(BrandModel::getB_name).orElse("N/A");
    }

    public String designationname(Long id) {
        if (id == null) {
            return "N/A";
        }
        Optional designation = this.designationRepository.findById((Object)id);
        return designation.map(DesignationModel::getDesignation).orElse("N/A");
    }

    public String guidename(Long id) {
        if (id == null) {
            return "N/A";
        }
        Optional user = this.userRepository.findById((Object)id);
        return user.map(User::getName).orElse("N/A");
    }

    public List<User> findByIdAndRole(Long userId, Role role) {
        try {
            Optional user = this.userRepository.findByIdAndRole(userId, role);
            if (user.isPresent()) {
                return Collections.singletonList((User)user.get());
            }
            return Collections.emptyList();
        }
        catch (Exception e) {
            System.err.println("An error occurred while fetching user by ID and role: " + e.getMessage());
            return Collections.emptyList();
        }
    }

    public List<User> findByBrandIdAndRole(Long brandid) {
        try {
            List users = this.userRepository.findByBrandidAndRoleAndStatus(brandid, Role.GM, true);
            return users;
        }
        catch (Exception e) {
            System.err.println("An error occurred while fetching users by brand ID and role: " + e.getMessage());
            return Collections.emptyList();
        }
    }

    public List<User> getAllMktgUnderGm(Long gmid) {
        try {
            List<Object> allMarketingUsers = new ArrayList();
            List regionalManagers = this.userRepository.findByGuideid(gmid);
            List usersUnderGm = this.userRepository.findByGuideid(gmid);
            if (!usersUnderGm.isEmpty()) {
                allMarketingUsers.addAll(usersUnderGm);
            }
            for (User rmUser : regionalManagers) {
                List usersUnderRm = this.userRepository.findByGuideid(rmUser.getId());
                if (usersUnderRm.isEmpty()) continue;
                allMarketingUsers.addAll(usersUnderRm);
            }
            Optional gm = this.userRepository.findById((Object)gmid);
            if (!gm.isPresent()) {
                throw new RuntimeException("GM not found for ID: " + gmid);
            }
            Long gmBrandId = ((User)gm.get()).getBrandid();
            allMarketingUsers = allMarketingUsers.stream().filter(user -> user.getBrandid().equals(gmBrandId)).collect(Collectors.toList());
            if (allMarketingUsers.isEmpty()) {
                throw new RuntimeException("No Marketing users found under GM ID: " + gmid);
            }
            return allMarketingUsers;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Failed to retrieve Marketing users under GM ID: " + gmid, e);
        }
        catch (Exception e) {
            throw new RuntimeException("An unexpected error occurred while retrieving Marketing users.", e);
        }
    }

    public List<UserRegionModel> getAllRegion() {
        try {
            return this.userRegionRepository.findAll();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retrieve all designations.", e);
        }
    }

    public List<UserRegionModel> addRegions(UserRegionModel regionModel) {
        try {
            if (regionModel.getRegion() == null || regionModel.getRegion().trim().isEmpty()) {
                throw new IllegalArgumentException("DesigCustomerGroupnation is mandatory.");
            }
            Optional existingDesignation = this.userRegionRepository.findByRegion(regionModel.getRegion());
            if (existingDesignation.isEmpty()) {
                this.userRegionRepository.save((Object)regionModel);
            }
            return this.userRegionRepository.findAll();
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Validation error: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to add designation.", e);
        }
    }

    public User updateUser(UserRequest updateRequest) {
        try {
            User user = this.findUserById(updateRequest.getId());
            if (updateRequest.getName() != null) {
                user.setName(updateRequest.getName());
            }
            if (updateRequest.getEmail() != null) {
                user.setEmail(updateRequest.getEmail());
            }
            if (updateRequest.getMobile() != null) {
                user.setMobile(updateRequest.getMobile());
            }
            user.setStatus(updateRequest.getStatus());
            this.userRepository.save((Object)user);
            return user;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to update user details", e);
        }
    }
}

