/*
 * Decompiled with CFR 0.152.
 */
package com.riot.Branding.service;

import com.riot.Branding.dao.BrandDAO;
import com.riot.Branding.model.BrandModel;
import com.riot.Branding.request.ResponseBannerDTO;
import com.riot.Branding.service.FileService;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class UserPhotoService {
    @Autowired
    private FileService fileService;
    @Autowired
    private BrandDAO userDao;

    public ResponseEntity<?> addProfile(MultipartFile file) {
        try {
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("ddMMyyyyHHmmssSSS");
            LocalDateTime current = LocalDateTime.now();
            String extension = file.getContentType();
            if (extension == null) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"Invalid file type.");
            }
            String exe = extension.substring(extension.lastIndexOf("/") + 1);
            String fileName = dtf.format(current) + "." + exe;
            String remotePath = "/TomorrowLand/EventBanner/" + fileName;
            this.fileService.upload(remotePath, file);
            String uploadedUrl = "https://storage.megashop.my" + remotePath;
            ResponseBannerDTO response = new ResponseBannerDTO(uploadedUrl);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Error occurred: " + e.getMessage()));
        }
    }

    public ResponseEntity<?> updateBannerImage(Long employeeId, MultipartFile file) {
        try {
            BrandModel employee = (BrandModel)this.userDao.findBrandById(employeeId).orElseThrow(() -> new RuntimeException("Event not found"));
            String oldFileUrl = employee.getImageURL();
            if (oldFileUrl != null && !oldFileUrl.isEmpty()) {
                String oldFilePath = oldFileUrl.replace("https://storage.megashop.my", "");
                this.fileService.delete(oldFilePath);
            }
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("ddMMyyyyHHmmssSSS");
            LocalDateTime current = LocalDateTime.now();
            String extension = file.getContentType();
            if (extension == null) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"Invalid file type.");
            }
            String exe = extension.substring(extension.lastIndexOf("/") + 1);
            String fileName = dtf.format(current) + "." + exe;
            String remotePath = "/TomorrowLand/EventBanner/" + fileName;
            this.fileService.upload(remotePath, file);
            String uploadedUrl = "https://storage.megashop.my" + remotePath;
            employee.setImageURL(uploadedUrl);
            this.userDao.addbrand(employee);
            ResponseBannerDTO response = new ResponseBannerDTO(uploadedUrl);
            return ResponseEntity.ok((Object)response);
        }
        catch (RuntimeException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)("Event not found: " + e.getMessage()));
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Error occurred: " + e.getMessage()));
        }
    }
}

