/*
 * Decompiled with CFR 0.152.
 */
package com.riot.Branding.service;

import com.riot.Branding.dao.FileDAO;
import com.riot.Branding.model.ApprovalStatus;
import com.riot.Branding.model.FileModel;
import com.riot.Branding.model.MktgIssuedProductModel;
import com.riot.Branding.model.Role;
import com.riot.Branding.model.StockModel;
import com.riot.Branding.model.StockUpdateModel;
import com.riot.Branding.model.TicketMaterialModel;
import com.riot.Branding.model.TicketModel;
import com.riot.Branding.model.TicketStatus;
import com.riot.Branding.model.TicketStatusTime;
import com.riot.Branding.model.TicketType;
import com.riot.Branding.repository.CustomerRepository;
import com.riot.Branding.repository.MktgIssuedProductRepository;
import com.riot.Branding.repository.NotificationRepository;
import com.riot.Branding.repository.StockRepository;
import com.riot.Branding.repository.StockUpdateRepository;
import com.riot.Branding.repository.TicketMaterialRepository;
import com.riot.Branding.repository.TicketRepository;
import com.riot.Branding.repository.TicketStatusTimeRepository;
import com.riot.Branding.repository.UserRepository;
import com.riot.Branding.repository.VendorRepository;
import com.riot.Branding.request.TicketMaterialRequest;
import com.riot.Branding.request.TicketStatusUpdateRequest;
import com.riot.Branding.response.UserResponse;
import com.riot.Branding.service.AuthenticationService;
import com.riot.Branding.service.StockService;
import com.riot.Branding.service.TicketUpdateStatus;
import com.riot.Branding.service.UserService;
import jakarta.servlet.UnavailableException;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TicketUpdateStatus {
    @Autowired
    private TicketRepository ticketRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private CustomerRepository customerRepository;
    @Autowired
    private VendorRepository vendorRepository;
    @Autowired
    NotificationRepository notificationRepository;
    @Autowired
    private AuthenticationService authenticationService;
    @Autowired
    private StockRepository stockRepository;
    @Autowired
    StockUpdateRepository stockUpdateRepository;
    @Autowired
    private TicketStatusTimeRepository statusTimeRepository;
    @Autowired
    private TicketMaterialRepository materialRepository;
    @Autowired
    private FileDAO fileDAO;
    @Autowired
    private StockService stockService;
    @Autowired
    private UserService userService;
    @Autowired
    private MktgIssuedProductRepository issuedProductRepository;

    public String updateTicketStatus(Long ticketId, TicketStatusUpdateRequest request, String token) throws Exception {
        TicketModel ticket = (TicketModel)this.ticketRepository.findById((Object)ticketId).orElseThrow(() -> new RuntimeException("Ticket not found"));
        UserResponse user = this.authenticationService.getDetails(token);
        switch (1.$SwitchMap$com$riot$Branding$model$Role[user.getRole().ordinal()]) {
            case 1: 
            case 2: {
                return this.handleGM(ticket, request, user);
            }
            case 3: {
                return this.handleUser(ticket, request, user);
            }
            case 4: 
            case 5: {
                return this.handleAdminAndSuperAdmin(ticket, request, user);
            }
        }
        throw new RuntimeException("Unauthorized action for this role.");
    }

    private String handleUser(TicketModel ticket, TicketStatusUpdateRequest request, UserResponse user) {
        try {
            switch (1.$SwitchMap$com$riot$Branding$model$TicketStatus[ticket.getStatus().ordinal()]) {
                case 1: {
                    if (ticket.getType().equals((Object)TicketType.RETURN)) {
                        ticket.setStatus(TicketStatus.DISPATCH);
                        TicketModel savedticket = (TicketModel)this.ticketRepository.save((Object)ticket);
                        this.updateStatus(savedticket, request, user);
                        return "Ticket " + request.getNewStatus() + " successfully Updated.";
                    }
                }
                case 2: {
                    if (request.getNewStatus() == TicketStatus.RECEIVED) {
                        ticket.setStatus(TicketStatus.RECEIVED);
                        TicketModel savedticket = (TicketModel)this.ticketRepository.save((Object)ticket);
                        System.err.println("engter12");
                        this.updateStatus(savedticket, request, user);
                        System.err.println("engter15");
                        return "Ticket status updated successfully to RECEIVED.";
                    }
                    throw new RuntimeException("Invalid status transition from DISPATCHED to " + request.getNewStatus());
                }
                case 3: {
                    ticket.setStatus(TicketStatus.DELIVERED);
                    TicketModel savedticket = (TicketModel)this.ticketRepository.save((Object)ticket);
                    this.updateStatus(savedticket, request, user);
                    List issuedProductModels = ticket.getMaterialModels();
                    if (issuedProductModels != null) {
                        for (TicketMaterialModel issuedProductModel : issuedProductModels) {
                            Optional existingMaterialOpt = this.issuedProductRepository.findByCategoryidAndMktgid(issuedProductModel.getCategoryid(), ticket.getMktgid());
                            if (existingMaterialOpt.isEmpty()) {
                                throw new RuntimeException("Material with Category ID " + issuedProductModel.getCategoryid() + " is not present");
                            }
                            MktgIssuedProductModel existingMaterial = (MktgIssuedProductModel)existingMaterialOpt.get();
                            Integer remainingQnty = existingMaterial.getIssuedqnty() - issuedProductModel.getIssuedqnty();
                            if (remainingQnty < 0) {
                                throw new RuntimeException("Insufficient issued quantity for Category ID: " + issuedProductModel.getCategoryid());
                            }
                            existingMaterial.setIssuedqnty(remainingQnty);
                            this.issuedProductRepository.save((Object)existingMaterial);
                        }
                    }
                    if (ticket.getStatus() == TicketStatus.DELIVERED) {
                        for (Long fileId : request.getFileIds()) {
                            FileModel fileModel = this.fileDAO.getByFileid(fileId.longValue());
                            fileModel.setTicketid(savedticket.getId().toString());
                            this.fileDAO.save(fileModel);
                        }
                        return "Ticket status updated successfully to DELIVERED.";
                    }
                    throw new RuntimeException("Invalid status transition from RECEIVED to " + request.getNewStatus());
                }
            }
            throw new RuntimeException("Unauthorized action for USER or invalid transition.");
        }
        catch (RuntimeException e) {
            return "Error updating ticket status: " + e.getMessage();
        }
        catch (Exception e) {
            return "An unexpected error occurred: " + e.getMessage();
        }
    }

    private String handleGM(TicketModel ticket, TicketStatusUpdateRequest request, UserResponse user) {
        switch (1.$SwitchMap$com$riot$Branding$model$TicketStatus[ticket.getStatus().ordinal()]) {
            case 4: 
            case 5: 
            case 6: {
                if (ticket.getType().equals((Object)TicketType.RETURN)) {
                    ticket.setStatus(request.getNewStatus());
                    TicketModel savedTicket = (TicketModel)this.ticketRepository.save((Object)ticket);
                    this.updateStatus(savedTicket, request, user);
                    return "Ticket " + request.getNewStatus() + " successfully Updated.";
                }
                if (request.getNewStatus().equals((Object)TicketStatus.APPROVE)) {
                    for (TicketMaterialRequest materialRequest : request.getMaterialModels()) {
                        Optional materialOpt = this.materialRepository.findById((Object)materialRequest.getMaterialid());
                        if (materialOpt.isEmpty()) {
                            throw new RuntimeException("Material with ID " + materialRequest.getMaterialid() + " is not present.");
                        }
                        TicketMaterialModel materialModel = (TicketMaterialModel)materialOpt.get();
                        if (materialModel.getQnty() < materialRequest.getIssuedqnty()) {
                            throw new RuntimeException("Insufficient quantity for material: " + materialModel.getMaterialid());
                        }
                        materialModel.setIssuedqnty(materialRequest.getIssuedqnty());
                        materialModel.setQntydescription(materialRequest.getQntydescription());
                        TicketMaterialModel savedticketMaterialModel = (TicketMaterialModel)this.materialRepository.save((Object)materialModel);
                        MktgIssuedProductModel issuedProductModel = this.issuedProductRepository.findByCategoryidAndMktgid(materialRequest.getCategoryid(), ticket.getMktgid()).orElseGet(() -> new MktgIssuedProductModel());
                        Integer qnty = 0;
                        if (issuedProductModel.getIssuedqnty() != null) {
                            qnty = issuedProductModel.getIssuedqnty();
                        }
                        issuedProductModel.setCategoryid(materialRequest.getCategoryid());
                        issuedProductModel.setCategory(materialRequest.getCategory());
                        issuedProductModel.setIssuedqnty(Integer.valueOf(qnty + savedticketMaterialModel.getIssuedqnty()));
                        issuedProductModel.setMktgid(ticket.getMktgid());
                        this.issuedProductRepository.save((Object)issuedProductModel);
                    }
                    ticket.setApprovalid(user.getId());
                    ticket.setAlteredBy(user.getId());
                    if (user.getRole().equals((Object)Role.GM)) {
                        ticket.setStatus(TicketStatus.APPROVE);
                        ticket.setApprovalStatus(ApprovalStatus.APPROVED_BY_GM);
                    } else {
                        ticket.setStatus(TicketStatus.APPROVE_BY_RM);
                        ticket.setApprovalStatus(ApprovalStatus.APPROVED_BY_RM);
                    }
                    TicketModel savedTicket = (TicketModel)this.ticketRepository.save((Object)ticket);
                    if (ApprovalStatus.APPROVED_BY_RM.equals((Object)savedTicket.getApprovalStatus()) && TicketStatus.APPROVE.equals((Object)savedTicket.getStatus())) {
                        ticket.setApprovalStatus(ApprovalStatus.APPROVED_BY_GM_RM);
                    }
                    savedTicket = (TicketModel)this.ticketRepository.save((Object)ticket);
                    this.updateStatus(savedTicket, request, user);
                    return "Ticket approved successfully by GM/RM. Issued quantities updated.";
                }
                if (!TicketStatus.HOLD.equals((Object)request.getNewStatus()) && !TicketStatus.REJECTED.equals((Object)request.getNewStatus())) break;
                ticket.setStatus(request.getNewStatus());
                ticket.setRemarks(request.getRemarks());
                TicketModel savedticket = (TicketModel)this.ticketRepository.save((Object)ticket);
                this.updateStatus(savedticket, request, user);
                return "Ticket " + request.getNewStatus() + " successfully by GM/RM.";
            }
            case 1: {
                if (request.getNewStatus() != TicketStatus.HOLD && request.getNewStatus() != TicketStatus.REJECTED) break;
                ticket.setStatus(request.getNewStatus());
                ticket.setRemarks(request.getRemarks());
                TicketModel savedticket = (TicketModel)this.ticketRepository.save((Object)ticket);
                this.updateStatus(savedticket, request, user);
                return "Ticket " + request.getNewStatus() + " successfully by GM/RM.";
            }
            case 7: {
                if (user.getRole() == Role.GM || user.getRole() == Role.RM || user.getRole() == Role.SUPERADMIN) {
                    ticket.setStatus(TicketStatus.VERIFY);
                    ticket.setCompletedAt(LocalDateTime.now());
                    TicketModel savedTicket = (TicketModel)this.ticketRepository.save((Object)ticket);
                    this.updateStatus(savedTicket, request, user);
                    break;
                }
                ticket.setStatus(TicketStatus.VERIFY);
                break;
            }
            default: {
                this.ticketRepository.save((Object)ticket);
            }
        }
        this.ticketRepository.save((Object)ticket);
        return "Ticket Updated successfully+.";
    }

    private String handleAdminAndSuperAdmin(TicketModel ticket, TicketStatusUpdateRequest request, UserResponse user) throws UnavailableException {
        switch (1.$SwitchMap$com$riot$Branding$model$TicketStatus[ticket.getStatus().ordinal()]) {
            case 5: 
            case 6: {
                try {
                    if (ticket.getType().equals((Object)TicketType.RETURN)) {
                        ticket.setStatus(request.getNewStatus());
                        TicketModel savedticket = (TicketModel)this.ticketRepository.save((Object)ticket);
                        this.updateStatus(savedticket, request, user);
                        return "Ticket " + request.getNewStatus() + " successfully Updated.";
                    }
                    if (request.getNewStatus() == TicketStatus.HOLD || request.getNewStatus() == TicketStatus.REJECTED) {
                        ticket.setStatus(request.getNewStatus());
                        ticket.setRemarks(request.getRemarks());
                        TicketModel savedticket = (TicketModel)this.ticketRepository.save((Object)ticket);
                        this.updateStatus(savedticket, request, user);
                        return "Ticket " + request.getNewStatus() + " successfully by GM/RM.";
                    }
                    break;
                }
                catch (RuntimeException e) {
                    return "Error updating ticket status for GM/RM: " + e.getMessage();
                }
                catch (Exception e) {
                    return "An unexpected error occurred: " + e.getMessage();
                }
            }
            case 1: {
                if (request.getNewStatus() == TicketStatus.HOLD || request.getNewStatus() == TicketStatus.REJECTED) {
                    ticket.setStatus(request.getNewStatus());
                    ticket.setRemarks(request.getRemarks());
                    TicketModel savedticket = (TicketModel)this.ticketRepository.save((Object)ticket);
                    this.updateStatus(savedticket, request, user);
                    return "Ticket " + request.getNewStatus() + " successfully by GM/RM.";
                }
                if (ticket.getType() == TicketType.LIGHT_BOARD || ticket.getType() == TicketType.WALL_PAINTING) {
                    if (request.getVendorid() != null) {
                        ticket.setStatus(TicketStatus.VENDOR_ASSIGNED);
                        ticket.setVendorid(request.getVendorid());
                        TicketModel savedticket = (TicketModel)this.ticketRepository.save((Object)ticket);
                        this.updateStatus(savedticket, request, user);
                        break;
                    }
                    throw new IllegalArgumentException("Vendor ID must be provided for LIGHT_BOARD or WALL_PAINTING.");
                }
                for (TicketMaterialModel materialModel : ticket.getMaterialModels()) {
                    Optional modelopt = this.stockRepository.findByCategoryid(materialModel.getCategoryid());
                    if (modelopt.isEmpty()) {
                        return "Category not found ";
                    }
                    StockModel stockModel = (StockModel)modelopt.get();
                    if (stockModel.getTotalunits() > materialModel.getIssuedqnty()) {
                        this.reduceStockQuantityforPromotional(materialModel.getCategoryid(), materialModel.getIssuedqnty(), ticket);
                        continue;
                    }
                    return "Insufficient stock quantity";
                }
                ticket.setStatus(TicketStatus.DISPATCH);
                TicketModel savedticket = (TicketModel)this.ticketRepository.save((Object)ticket);
                this.updateStatus(savedticket, request, user);
                break;
            }
            case 8: {
                if (request.getNewStatus() == TicketStatus.DISPATCH) {
                    ticket.setStockid(request.getStockid());
                    ticket.setStatus(TicketStatus.DISPATCH);
                    ticket.setTrackingstatus(request.getTrackingstatus());
                    for (TicketMaterialModel materialModel : ticket.getMaterialModels()) {
                        Optional modelopt = this.stockRepository.findByCategoryid(materialModel.getCategoryid());
                        if (modelopt.isEmpty()) {
                            return "Category not found ";
                        }
                        StockModel stockModel = (StockModel)modelopt.get();
                        if (stockModel.getTotalunits() > materialModel.getIssuedqnty()) {
                            this.reduceStockQuantityforNonPromotional(materialModel.getCategoryid(), materialModel.getIssuedqnty(), request.getStockid(), ticket);
                            continue;
                        }
                        return "Insufficient stock quantity";
                    }
                } else {
                    ticket.setStatus(request.getNewStatus());
                }
                TicketModel savedtickets = (TicketModel)this.ticketRepository.save((Object)ticket);
                this.updateStatus(savedtickets, request, user);
                break;
            }
            case 2: {
                if (ticket.getType().equals((Object)TicketType.RETURN)) {
                    if (request.getNewStatus().equals((Object)TicketStatus.RECEIVED$VERIFY)) {
                        for (TicketMaterialModel materialModel : ticket.getMaterialModels()) {
                            Optional modelopt = this.stockRepository.findByCategoryid(materialModel.getCategoryid());
                            if (modelopt.isEmpty()) {
                                return "Category not found ";
                            }
                            StockModel stockModel = (StockModel)modelopt.get();
                            if (stockModel.getTotalunits() >= materialModel.getQnty()) {
                                this.addStockQuantity(materialModel.getCategoryid(), materialModel.getQnty());
                                continue;
                            }
                            return "Insufficient stock quantity";
                        }
                        ticket.setStatus(TicketStatus.VERIFY);
                        TicketModel savedticket1 = (TicketModel)this.ticketRepository.save((Object)ticket);
                        this.updateStatus(savedticket1, request, user);
                        return "Ticket " + request.getNewStatus() + " successfully Updated.";
                    }
                    ticket.setStatus(TicketStatus.RECEIVED);
                    TicketModel savedticket1 = (TicketModel)this.ticketRepository.save((Object)ticket);
                    this.updateStatus(savedticket1, request, user);
                    return "Ticket " + request.getNewStatus() + " successfully Updated.";
                }
                if (request.getNewStatus() == TicketStatus.HOLD || request.getNewStatus() == TicketStatus.REJECTED) {
                    if (request.getNewStatus() == TicketStatus.HOLD) {
                        ticket.setStatus(TicketStatus.HOLD);
                    } else {
                        ticket.setStatus(TicketStatus.REJECTED);
                    }
                    ticket.setRemarks(request.getRemarks());
                    break;
                }
                if (user.getRole() == Role.ADMIN || user.getRole() == Role.SUPERADMIN) {
                    if (request.getNewStatus() == TicketStatus.RECEIVED) {
                        ticket.setStatus(TicketStatus.RECEIVED);
                        break;
                    }
                    throw new RuntimeException("Invalid status transition from DISPATCHED.");
                }
                throw new UnavailableException("Only Admin or Super Admin can change the status from DISPATCHED.");
            }
            case 3: {
                if (ticket.getType().equals((Object)TicketType.RETURN)) {
                    for (TicketMaterialModel materialModel : ticket.getMaterialModels()) {
                        Optional modelopt = this.stockRepository.findByCategoryid(materialModel.getCategoryid());
                        if (modelopt.isEmpty()) {
                            return "Category not found ";
                        }
                        StockModel stockModel = (StockModel)modelopt.get();
                        if (stockModel.getTotalunits() >= materialModel.getQnty()) {
                            this.addStockQuantity(materialModel.getCategoryid(), materialModel.getQnty());
                            continue;
                        }
                        return "Insufficient stock quantity";
                    }
                    ticket.setStatus(TicketStatus.VERIFY);
                    TicketModel savedtickets1 = (TicketModel)this.ticketRepository.save((Object)ticket);
                    this.updateStatus(savedtickets1, request, user);
                    return "Ticket " + request.getNewStatus() + " successfully Updated.";
                }
                if (request.getNewStatus() == TicketStatus.HOLD || request.getNewStatus() == TicketStatus.REJECTED) {
                    if (request.getNewStatus() == TicketStatus.HOLD) {
                        ticket.setStatus(TicketStatus.HOLD);
                    } else {
                        ticket.setStatus(TicketStatus.REJECTED);
                    }
                    ticket.setRemarks(request.getRemarks());
                    break;
                }
                if (user.getRole() == Role.ADMIN || user.getRole() == Role.USER) {
                    if (request.getNewStatus() == TicketStatus.INSTALLATION_DONE) {
                        ticket.setStatus(TicketStatus.INSTALLATION_DONE);
                        TicketModel savedTickets = (TicketModel)this.ticketRepository.save((Object)ticket);
                        this.updateStatus(savedTickets, request, user);
                        break;
                    }
                    throw new RuntimeException("Invalid status transition from RECEIVED.");
                }
                throw new UnavailableException("Only Admin or User can change the status from RECEIVED.");
            }
            case 7: {
                if (user.getRole() == Role.GM || user.getRole() == Role.RM || user.getRole() == Role.SUPERADMIN) {
                    ticket.setStatus(TicketStatus.VERIFY);
                    ticket.setCompletedAt(LocalDateTime.now());
                    TicketModel savedTicket = (TicketModel)this.ticketRepository.save((Object)ticket);
                    this.updateStatus(savedTicket, request, user);
                    break;
                }
                ticket.setStatus(TicketStatus.VERIFY);
                TicketModel savedTicket = (TicketModel)this.ticketRepository.save((Object)ticket);
                this.updateStatus(savedTicket, request, user);
                break;
            }
            default: {
                this.ticketRepository.save((Object)ticket);
            }
        }
        this.ticketRepository.save((Object)ticket);
        return "Ticket Updated successfully+.";
    }

    private void reduceStockQuantityforNonPromotional(Long stockId, Integer quantity, Long stockid, TicketModel ticketModel) {
        StockModel stock = (StockModel)this.stockRepository.findByCategoryid(stockId).orElseThrow(() -> new RuntimeException("Stock not found for ID: " + stockId));
        StockUpdateModel stockUpdateModels = (StockUpdateModel)this.stockUpdateRepository.findById((Object)stockid).orElseThrow(() -> new RuntimeException("Stock not found for ID: " + stockid));
        Integer newQuantity = stock.getTotalunits() - quantity;
        double totalunits = stock.getTotalunits().intValue();
        Integer newqnty = quantity;
        int balanceqnty = Math.round(newQuantity.intValue());
        Double stockamount = stockUpdateModels.getStockamount();
        Double totalamount = stock.getTotalamount() - stockamount;
        if (newQuantity < 0) {
            throw new RuntimeException("Insufficient stock quantity. Current quantity: " + newQuantity);
        }
        stock.setTotalunits(newQuantity);
        stock.setTotalamount(totalamount);
        this.stockRepository.save((Object)stock);
        StockUpdateModel stockUpdateModel = new StockUpdateModel();
        stockUpdateModel.setBrandid(stock.getBrandid());
        stockUpdateModel.setStockid(stock.getStockid());
        stockUpdateModel.setV_name(stock.getV_name());
        stockUpdateModel.setCategoryid(stockId);
        if (ticketModel.getTicket().equalsIgnoreCase("customer")) {
            stockUpdateModel.setCustomerid(ticketModel.getCustomerid());
        } else {
            stockUpdateModel.setMktgid(ticketModel.getMktgid());
        }
        stockUpdateModel.setStocktype(stock.getStocktype());
        stockUpdateModel.setNewqnty(newqnty);
        stockUpdateModel.setBalanceqnty(Integer.valueOf(balanceqnty));
        stockUpdateModel.setMeasureunits(stock.getMeasureunits());
        stockUpdateModel.setStockamount(stockamount);
        stockUpdateModel.setTotalamount(totalamount);
        stockUpdateModel.setUpdatedQuantity("-" + quantity.toString());
        stockUpdateModel.setFinalunits(newQuantity.toString());
        stockUpdateModel.setCreatedTimestamp(LocalDateTime.now());
        stockUpdateModel.setReturnkey("1");
        this.stockUpdateRepository.save((Object)stockUpdateModel);
    }

    private void reduceStockQuantityforPromotional(Long stockId, Integer quantity, TicketModel ticketModel) {
        Double perunit_price;
        StockModel stock = (StockModel)this.stockRepository.findByCategoryid(stockId).orElseThrow(() -> new RuntimeException("Stock not found for ID: " + stockId));
        Integer newQuantity = stock.getTotalunits() - quantity;
        double totalunits = stock.getTotalunits().intValue();
        Double finalprice = perunit_price = Double.valueOf(stock.getTotalamount() / totalunits);
        Integer newqnty = quantity;
        int balanceqnty = Math.round(newQuantity.intValue());
        Double stockamount = perunit_price * (double)newqnty.intValue();
        Double totalamount = stock.getTotalamount() - stockamount;
        if (newQuantity < 0) {
            throw new RuntimeException("Insufficient stock quantity. Current quantity: " + newQuantity);
        }
        stock.setTotalunits(newQuantity);
        stock.setTotalamount(totalamount);
        this.stockRepository.save((Object)stock);
        StockUpdateModel stockUpdateModel = new StockUpdateModel();
        stockUpdateModel.setBrandid(stock.getBrandid());
        stockUpdateModel.setStockid(stock.getStockid());
        stockUpdateModel.setV_name(stock.getV_name());
        stockUpdateModel.setCategoryid(stockId);
        if (ticketModel.getTicket().equalsIgnoreCase("customer")) {
            stockUpdateModel.setCustomerid(ticketModel.getCustomerid());
        } else {
            stockUpdateModel.setMktgid(ticketModel.getMktgid());
        }
        stockUpdateModel.setStocktype(stock.getStocktype());
        stockUpdateModel.setPerunit_price(perunit_price);
        stockUpdateModel.setNewqnty(newqnty);
        stockUpdateModel.setBalanceqnty(Integer.valueOf(balanceqnty));
        stockUpdateModel.setHandlingcharges(Double.valueOf(0.0));
        stockUpdateModel.setMeasureunits(stock.getMeasureunits());
        stockUpdateModel.setStockamount(stockamount);
        stockUpdateModel.setTotalamount(totalamount);
        stockUpdateModel.setUpdatedQuantity("-" + quantity.toString());
        stockUpdateModel.setFinalprice(finalprice);
        stockUpdateModel.setFinalunits(newQuantity.toString());
        stockUpdateModel.setCreatedTimestamp(LocalDateTime.now());
        stockUpdateModel.setReturnkey("1");
        this.stockUpdateRepository.save((Object)stockUpdateModel);
    }

    private void addStockQuantity(Long stockId, Integer quantity) {
        Double perunit_price;
        StockModel stock = (StockModel)this.stockRepository.findByCategoryid(stockId).orElseThrow(() -> new RuntimeException("Stock not found for ID: " + stockId));
        Integer newQuantity = stock.getTotalunits() + quantity;
        double totalunits = stock.getTotalunits().intValue();
        Double finalprice = perunit_price = Double.valueOf(stock.getTotalamount() / totalunits);
        Integer newqnty = quantity;
        int balanceqnty = Math.round(newQuantity.intValue());
        Double stockamount = perunit_price * (double)newqnty.intValue();
        Double totalamount = stock.getTotalamount() + stockamount;
        if (newQuantity < 0) {
            throw new RuntimeException("Insufficient stock quantity. Current quantity: " + newQuantity);
        }
        stock.setTotalunits(newQuantity);
        stock.setTotalamount(totalamount);
        this.stockRepository.save((Object)stock);
        StockUpdateModel stockUpdateModel = new StockUpdateModel();
        stockUpdateModel.setStockid(stock.getStockid());
        stockUpdateModel.setV_name(stock.getV_name());
        stockUpdateModel.setCategoryid(stockId);
        stockUpdateModel.setStocktype(stock.getStocktype());
        stockUpdateModel.setPerunit_price(perunit_price);
        stockUpdateModel.setNewqnty(newqnty);
        stockUpdateModel.setBalanceqnty(Integer.valueOf(balanceqnty));
        stockUpdateModel.setHandlingcharges(Double.valueOf(0.0));
        stockUpdateModel.setMeasureunits(stock.getMeasureunits());
        stockUpdateModel.setStockamount(stockamount);
        stockUpdateModel.setTotalamount(totalamount);
        stockUpdateModel.setUpdatedQuantity("+" + quantity.toString());
        stockUpdateModel.setFinalprice(finalprice);
        stockUpdateModel.setFinalunits(newQuantity.toString());
        stockUpdateModel.setCreatedTimestamp(LocalDateTime.now());
        stockUpdateModel.setReturnkey("1");
        this.stockUpdateRepository.save((Object)stockUpdateModel);
    }

    private void updateStatus(TicketModel ticket, TicketStatusUpdateRequest request, UserResponse user) {
        TicketStatusTime statusTime = new TicketStatusTime();
        statusTime.setTicketid(ticket.getId());
        statusTime.setTicket(ticket);
        statusTime.setStatus(ticket.getStatus());
        statusTime.setUserid(user.getId());
        statusTime.setUpdatedat(LocalDateTime.now());
        this.statusTimeRepository.save((Object)statusTime);
    }
}

