/*
 * Decompiled with CFR 0.152.
 */
package com.riot.Branding.service;

import com.riot.Branding.dao.FileDAO;
import com.riot.Branding.model.ApprovalStatus;
import com.riot.Branding.model.CustomerModel;
import com.riot.Branding.model.FileModel;
import com.riot.Branding.model.MktgIssuedProductModel;
import com.riot.Branding.model.Role;
import com.riot.Branding.model.StockModel;
import com.riot.Branding.model.StockUpdateModel;
import com.riot.Branding.model.TicketMaterialModel;
import com.riot.Branding.model.TicketModel;
import com.riot.Branding.model.TicketStatus;
import com.riot.Branding.model.TicketStatusTime;
import com.riot.Branding.model.TicketType;
import com.riot.Branding.model.User;
import com.riot.Branding.model.VendorModel;
import com.riot.Branding.notification.Notification;
import com.riot.Branding.repository.CustomerMartialRepository;
import com.riot.Branding.repository.CustomerRepository;
import com.riot.Branding.repository.MktgIssuedProductRepository;
import com.riot.Branding.repository.NotificationRepository;
import com.riot.Branding.repository.StockRepository;
import com.riot.Branding.repository.StockUpdateRepository;
import com.riot.Branding.repository.TicketMaterialRepository;
import com.riot.Branding.repository.TicketRepository;
import com.riot.Branding.repository.UserRepository;
import com.riot.Branding.repository.VendorRepository;
import com.riot.Branding.request.TicketMaterialRequest;
import com.riot.Branding.request.TicketRequest;
import com.riot.Branding.request.TicketStatusUpdateRequest;
import com.riot.Branding.response.TicketResponse;
import com.riot.Branding.response.UserResponse;
import com.riot.Branding.service.AuthenticationService;
import com.riot.Branding.service.StockService;
import com.riot.Branding.service.TicketService;
import com.riot.Branding.service.TicketServiceImpl;
import com.riot.Branding.service.UserService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TicketServiceImpl
implements TicketService {
    @Autowired
    private TicketRepository ticketRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private CustomerRepository customerRepository;
    @Autowired
    private VendorRepository vendorRepository;
    @Autowired
    NotificationRepository notificationRepository;
    @Autowired
    private AuthenticationService authenticationService;
    @Autowired
    private StockRepository stockRepository;
    @Autowired
    StockUpdateRepository stockUpdateRepository;
    @Autowired
    private CustomerMartialRepository customerMartialRepository;
    @Autowired
    private TicketMaterialRepository materialRepository;
    @Autowired
    private FileDAO fileDAO;
    @Autowired
    private StockService stockService;
    @Autowired
    private MktgIssuedProductRepository issuedProductRepository;
    @Autowired
    private UserService userService;
    private static final Logger logger = LoggerFactory.getLogger(TicketServiceImpl.class);

    public String generateTicketCode() {
        String prefix = "TK";
        String lastCode = this.ticketRepository.findTopByOrderByTicketcodeDesc().map(TicketModel::getTicketcode).orElse(null);
        long nextNumber = 1L;
        if (lastCode != null && lastCode.startsWith(prefix)) {
            try {
                String numericPart = lastCode.substring(prefix.length());
                nextNumber = Long.parseLong(numericPart) + 1L;
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Failed to parse the last bill number: " + lastCode, e);
            }
        }
        return prefix + String.format("%04d", nextNumber);
    }

    public TicketModel createTicket(TicketRequest ticketRequest, String token) {
        logger.debug("Entering createTicket method.");
        try {
            UserResponse user = this.authenticationService.getDetails(token);
            String ticketId = this.generateTicketCode();
            if (TicketType.RETURN.equals((Object)ticketRequest.getType())) {
                TicketModel ticketModels = new TicketModel();
                ticketModels.setType(ticketRequest.getType());
                ticketModels.setDescription(ticketRequest.getDescription());
                ticketModels.setCreatedBy(user.getId());
                ticketModels.setTicketcode(ticketId);
                if (user.getRole() == Role.ADMIN || user.getRole() == Role.SUPERADMIN) {
                    logger.debug("User role is ADMIN or SUPERADMIN. Validating MKTG ID.");
                    if (ticketRequest.getMktgid() == null) {
                        throw new RuntimeException("MKTG ID must be provided by Admin.");
                    }
                    ticketModels.setMktgid(ticketRequest.getMktgid());
                } else {
                    ticketModels.setMktgid(user.getId());
                }
                ticketModels.setStatus(TicketStatus.DISPATCH);
                ticketModels.setApprovalStatus(ApprovalStatus.PENDING);
                TicketModel savedTicketModels = (TicketModel)this.ticketRepository.save((Object)ticketModels);
                ArrayList<TicketMaterialModel> materialModels = new ArrayList<TicketMaterialModel>();
                for (TicketMaterialRequest model : ticketRequest.getMaterialModels()) {
                    TicketMaterialModel materialModel = new TicketMaterialModel();
                    materialModel.setCategoryid(model.getCategoryid());
                    materialModel.setQnty(model.getIssuedqnty());
                    materialModel.setCategory(model.getCategory());
                    materialModel.setTicket(savedTicketModels);
                    materialModel.setQntydescription(model.getQntydescription());
                    materialModels.add(materialModel);
                    Optional pdtopt = this.issuedProductRepository.findByCategoryidAndMktgid(materialModel.getCategoryid(), savedTicketModels.getMktgid());
                    if (pdtopt.isEmpty()) {
                        throw new RuntimeException("Category  with ID " + materialModel.getCategoryid() + " is not present.");
                    }
                    MktgIssuedProductModel issuedProductModel = (MktgIssuedProductModel)pdtopt.get();
                    Integer qnty = issuedProductModel.getIssuedqnty() - model.getIssuedqnty();
                    issuedProductModel.setIssuedqnty(qnty);
                    this.issuedProductRepository.save((Object)issuedProductModel);
                }
                logger.debug("Saving TicketMaterialModels: {}", materialModels);
                this.materialRepository.saveAll(materialModels);
                savedTicketModels.setMaterialModels(materialModels);
                logger.debug("Updating saved TicketModel with materials.");
                this.ticketRepository.save((Object)savedTicketModels);
                this.createAndSaveNotification(ticketRequest, savedTicketModels);
                return savedTicketModels;
            }
            TicketModel ticketModel = this.initializeTicketModel(ticketRequest, user, ticketId);
            logger.debug("Saving initial TicketModel.");
            TicketModel savedTicketModel = (TicketModel)this.ticketRepository.save((Object)ticketModel);
            if (savedTicketModel.getId() == null) {
                throw new RuntimeException("Ticket could not be saved. No ID generated.");
            }
            ArrayList<TicketMaterialModel> materialModels = new ArrayList<TicketMaterialModel>();
            for (TicketMaterialRequest model : ticketRequest.getMaterialModels()) {
                TicketMaterialModel materialModel = new TicketMaterialModel();
                materialModel.setCategoryid(model.getCategoryid());
                materialModel.setQnty(model.getQnty());
                materialModel.setCategory(model.getCategory());
                materialModel.setTicket(savedTicketModel);
                materialModel.setQntydescription(model.getQntydescription());
                materialModels.add(materialModel);
            }
            logger.debug("Saving TicketMaterialModels: {}", materialModels);
            this.materialRepository.saveAll(materialModels);
            savedTicketModel.setMaterialModels(materialModels);
            logger.debug("Updating saved TicketModel with materials.");
            this.ticketRepository.save((Object)savedTicketModel);
            this.createAndSaveNotification(ticketRequest, savedTicketModel);
            return savedTicketModel;
        }
        catch (RuntimeException e) {
            logger.error("Runtime exception occurred: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("Error creating ticket: " + e.getMessage(), e);
        }
        catch (Exception e) {
            logger.error("Unexpected exception occurred: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("An unexpected error occurred while creating the ticket: " + e.getMessage(), e);
        }
    }

    private TicketModel initializeTicketModel(TicketRequest ticketRequest, UserResponse user, String ticketId) {
        logger.debug("Initializing TicketModel with ticketRequest: {}, user: {}, ticketId: {}", new Object[]{ticketRequest, user, ticketId});
        TicketModel ticketModel = new TicketModel();
        try {
            ticketModel.setType(ticketRequest.getType());
            logger.debug("Set ticket type: {}", (Object)ticketRequest.getType());
            ticketModel.setDescription(ticketRequest.getDescription());
            logger.debug("Set ticket description: {}", (Object)ticketRequest.getDescription());
            ticketModel.setCreatedBy(user.getId());
            logger.debug("Set created by: {}", (Object)user.getId());
            ticketModel.setTicketcode(ticketId);
            logger.debug("Set ticket code: {}", (Object)ticketId);
            if (ticketRequest.getTicket().equals("self")) {
                ticketModel.setCustomerid(null);
                logger.debug("Set customer ID: {}", (Object)ticketRequest.getCustomerid());
                ticketModel.setRegion(null);
                logger.debug("Set region: {}", (Object)ticketRequest.getRegion());
                ticketModel.setTicket(ticketRequest.getTicket());
            } else {
                ticketModel.setCustomerid(ticketRequest.getCustomerid());
                logger.debug("Set customer ID: {}", (Object)ticketRequest.getCustomerid());
                ticketModel.setTicket(ticketRequest.getTicket());
            }
            if (user.getRole() == Role.ADMIN || user.getRole() == Role.SUPERADMIN) {
                logger.debug("User role is ADMIN or SUPERADMIN. Validating MKTG ID.");
                if (ticketRequest.getMktgid() == null) {
                    logger.error("MKTG ID must be provided by Admin.");
                    throw new RuntimeException("MKTG ID must be provided by Admin.");
                }
                ticketModel.setMktgid(ticketRequest.getMktgid());
                logger.debug("Set MKTG ID: {}", (Object)ticketRequest.getMktgid());
            } else if (user.getRole() == Role.USER) {
                ticketModel.setMktgid(user.getId());
                logger.debug("Set MKTG ID to user's ID: {}", (Object)user.getId());
            } else {
                ticketModel.setMktgid(ticketRequest.getMktgid());
            }
            ticketModel.setStatus(TicketStatus.PENDING);
            logger.debug("Set ticket status: PENDING");
            ticketModel.setApprovalStatus(ApprovalStatus.PENDING);
            logger.debug("Set approval status: PENDING");
        }
        catch (RuntimeException e) {
            logger.error("Error initializing TicketModel: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("Error initializing ticket model: " + e.getMessage(), e);
        }
        logger.debug("Initialized TicketModel: {}", (Object)ticketModel);
        return ticketModel;
    }

    private void createAndSaveNotification(TicketRequest ticketRequest, TicketModel savedTicket) {
        Notification notification = new Notification();
        notification.setMktgname(this.username(savedTicket.getMktgid()));
        notification.setTicketcode(savedTicket.getTicketcode());
        notification.setTickettype(savedTicket.getType().toString());
        if (savedTicket.getType().equals((Object)TicketType.RETURN)) {
            notification.setPerson("Self Ticket " + this.username(savedTicket.getMktgid()) + ".");
        } else {
            notification.setPerson(this.getPersonName(ticketRequest, savedTicket));
        }
        notification.setCreatedAt(LocalDateTime.now());
        notification.setSended(Boolean.valueOf(false));
        this.notificationRepository.save((Object)notification);
    }

    private String getPersonName(TicketRequest ticketRequest, TicketModel savedTicket) {
        if ("Public".equalsIgnoreCase(ticketRequest.getTitle())) {
            return "Public";
        }
        if ("self".equalsIgnoreCase(ticketRequest.getTicket())) {
            return "Self Ticket " + this.username(savedTicket.getMktgid()) + ".";
        }
        return this.customerRepository.findById((Object)savedTicket.getCustomerid()).map(CustomerModel::getC_name).orElse("Not Mentioned");
    }

    public TicketModel getTicketsByIdWithoutvalue(Long id) {
        return (TicketModel)this.ticketRepository.findById((Object)id).orElseThrow(() -> new RuntimeException("Ticket not found with id " + id));
    }

    public TicketResponse getTicketById(Long id, String token) {
        UserResponse user = this.authenticationService.getDetails(token);
        Optional ticket = this.ticketRepository.findById((Object)id);
        return ticket.map(t -> this.convertToDTO(t, user)).orElseThrow(() -> new RuntimeException("Ticket not found with id " + id));
    }

    public List<TicketResponse> getAllTicketsRoleBased(String token) {
        UserResponse user = this.authenticationService.getDetails(token);
        User userdetail = this.userService.findUserById(user.getId());
        List tickets = new ArrayList();
        if (user.getRole().equals((Object)Role.USER)) {
            tickets = this.ticketRepository.findByMktgid(user.getId());
            System.out.println("Fetched USER Tickets: " + tickets.size());
        } else {
            if (user.getRole().equals((Object)Role.GM) || user.getRole().equals((Object)Role.ADMIN)) {
                List allTickets = this.ticketRepository.findAll();
                System.out.println("Fetched All Tickets for GM/RM/ADMIN: " + allTickets.size());
                List rmUsers = this.userRepository.findByGuideidAndRoleAndStatus(user.getId(), Role.RM, true);
                System.out.println("RM Users Found: " + rmUsers.size());
                ArrayList allMarketingUsers = new ArrayList();
                for (User rmUser : rmUsers) {
                    List mktgUsers = this.userRepository.findByGuideidAndRoleAndStatus(rmUser.getId(), Role.USER, true);
                    allMarketingUsers.addAll(mktgUsers);
                }
                List directMarketingUsers = this.userRepository.findByGuideidAndRoleAndStatus(user.getId(), Role.USER, true);
                allMarketingUsers.addAll(directMarketingUsers);
                System.out.println("Total Marketing Users Found: " + allMarketingUsers.size());
                Long loggedInUserBrandId = userdetail.getBrandid();
                List filteredTickets = allTickets.stream().filter(ticket -> allMarketingUsers.stream().anyMatch(mktgUser -> Objects.equals(ticket.getMktgid(), mktgUser.getId()) && Objects.equals(mktgUser.getBrandid(), loggedInUserBrandId))).collect(Collectors.toList());
                System.out.println("Filtered Tickets After Brand ID Check: " + filteredTickets.size());
                return filteredTickets.stream().map(arg_0 -> this.convertToDTO(arg_0)).collect(Collectors.toList());
            }
            if (user.getRole().equals((Object)Role.ADMIN)) {
                List allTickets = this.ticketRepository.findAll();
                System.out.println("Fetched All Tickets for GM/RM/ADMIN: " + allTickets.size());
                ArrayList allMarketingUsers = new ArrayList();
                List mktgUsers = this.userRepository.findByGuideidAndRoleAndStatus(user.getId(), Role.USER, true);
                allMarketingUsers.addAll(mktgUsers);
                List directMarketingUsers = this.userRepository.findByGuideidAndRoleAndStatus(user.getId(), Role.USER, true);
                allMarketingUsers.addAll(directMarketingUsers);
                System.out.println("Total Marketing Users Found: " + allMarketingUsers.size());
                Long loggedInUserBrandId = userdetail.getBrandid();
                List filteredTickets = allTickets.stream().filter(ticket -> allMarketingUsers.stream().anyMatch(mktgUser -> Objects.equals(ticket.getMktgid(), mktgUser.getId()) && Objects.equals(mktgUser.getBrandid(), loggedInUserBrandId))).collect(Collectors.toList());
                System.out.println("Filtered Tickets After Brand ID Check: " + filteredTickets.size());
                return filteredTickets.stream().map(arg_0 -> this.convertToDTO(arg_0)).collect(Collectors.toList());
            }
            if (user.getRole().equals((Object)Role.SUPERADMIN)) {
                tickets = this.ticketRepository.findAll();
                System.out.println("Fetched SUPERADMIN Tickets: " + tickets.size());
            }
        }
        return tickets.stream().map(arg_0 -> this.convertToDTO(arg_0)).collect(Collectors.toList());
    }

    public List<TicketResponse> getAllTickets() {
        List ticket = this.ticketRepository.findAll();
        return ticket.stream().map(arg_0 -> this.convertToDTO(arg_0)).collect(Collectors.toList());
    }

    private TicketResponse convertToDTO(TicketModel ticketModel) {
        TicketResponse dto = new TicketResponse();
        dto.setId(ticketModel.getId());
        dto.setApprovalid(this.username(ticketModel.getApprovalid()));
        dto.setAlteredBy(this.username(ticketModel.getAlteredBy()));
        dto.setCreatedBy(this.username(ticketModel.getCreatedBy()));
        dto.setDescription(ticketModel.getDescription());
        dto.setCustomerid(ticketModel.getCustomerid());
        dto.setCustomername(this.customername(ticketModel.getCustomerid()));
        dto.setTicketcode(ticketModel.getTicketcode());
        dto.setMktgid(ticketModel.getMktgid());
        dto.setMktgname(this.username(ticketModel.getMktgid()));
        dto.setType(ticketModel.getType());
        dto.setStatus(ticketModel.getStatus());
        dto.setDispatchedAt(ticketModel.getDispatchedAt());
        dto.setCompletedAt(ticketModel.getCompletedAt());
        dto.setCreatedAt(ticketModel.getCreatedAt());
        dto.setRemarks(ticketModel.getRemarks());
        dto.setTicket(ticketModel.getTicket());
        List files = this.fileDAO.findByTicketid(ticketModel.getId());
        List materialRequests = ticketModel.getMaterialModels().stream().map(arg_0 -> this.convertMaterialModelToDTO(arg_0)).collect(Collectors.toList());
        dto.setMaterialModels(materialRequests);
        return dto;
    }

    private TicketResponse convertToDTO(TicketModel ticketModel, UserResponse response) {
        TicketResponse dto = new TicketResponse();
        dto.setId(ticketModel.getId());
        dto.setApprovalid(this.username(ticketModel.getApprovalid()));
        dto.setAlteredBy(this.username(ticketModel.getAlteredBy()));
        dto.setCreatedBy(this.username(ticketModel.getCreatedBy()));
        dto.setDescription(ticketModel.getDescription());
        dto.setCustomerid(ticketModel.getCustomerid());
        dto.setCustomername(this.customername(ticketModel.getCustomerid()));
        dto.setTicketcode(ticketModel.getTicketcode());
        dto.setMktgid(ticketModel.getMktgid());
        dto.setMktgname(this.username(ticketModel.getMktgid()));
        dto.setType(ticketModel.getType());
        dto.setStatus(ticketModel.getStatus());
        dto.setDispatchedAt(ticketModel.getDispatchedAt());
        dto.setCompletedAt(ticketModel.getCompletedAt());
        dto.setCreatedAt(ticketModel.getCreatedAt());
        dto.setTrackingstatus(ticketModel.getTrackingstatus());
        dto.setListstatus(this.getListOfTicketStatuses(ticketModel, response));
        dto.setRemarks(ticketModel.getRemarks());
        dto.setApprovalStatus(ticketModel.getApprovalStatus());
        if (ticketModel.getApprovalid() != null) {
            dto.setApprovalid(ticketModel.getApprovalid().toString());
        }
        List files = this.fileDAO.findByTicketid(ticketModel.getId());
        dto.setFiles(files);
        List materialRequests = ticketModel.getMaterialModels().stream().map(arg_0 -> this.convertMaterialModelToDTO(arg_0)).collect(Collectors.toList());
        dto.setMaterialModels(materialRequests);
        List statusTimes = ticketModel.getStatusTimes().stream().map(arg_0 -> this.convertTicketStatusTimeToDTO(arg_0)).collect(Collectors.toList());
        dto.setStatusTimes(statusTimes);
        return dto;
    }

    private TicketMaterialRequest convertMaterialModelToDTO(TicketMaterialModel materialRequest) {
        TicketMaterialRequest request = new TicketMaterialRequest();
        request.setMaterialid(materialRequest.getMaterialid());
        request.setCategoryid(materialRequest.getCategoryid());
        request.setCategory(materialRequest.getCategory());
        request.setQnty(materialRequest.getQnty());
        request.setIssuedqnty(materialRequest.getIssuedqnty());
        request.setQntydescription(materialRequest.getQntydescription());
        return request;
    }

    private TicketStatusTime convertTicketStatusTimeToDTO(TicketStatusTime statusTime) {
        TicketStatusTime request = new TicketStatusTime();
        request.setId(statusTime.getId());
        request.setStatus(statusTime.getStatus());
        request.setTicketid(statusTime.getTicketid());
        request.setUserid(statusTime.getUserid());
        return request;
    }

    public List<TicketModel> findAllTickets() {
        return this.ticketRepository.findAll();
    }

    public TicketModel updateTicket(Long ticketId, TicketRequest ticketRequest, String token) {
        UserResponse response = this.authenticationService.getDetails(token);
        logger.debug("Entering updateTicket method with ticketId: {}, ticketRequest: {}", (Object)ticketId, (Object)ticketRequest);
        try {
            Optional optionalTicket = this.ticketRepository.findById((Object)ticketId);
            if (optionalTicket.isEmpty()) {
                throw new RuntimeException("Ticket not found for ID: " + ticketId);
            }
            TicketModel ticket = (TicketModel)optionalTicket.get();
            logger.debug("Retrieved ticket: {}", (Object)ticket);
            if (!TicketStatus.PENDING.equals((Object)ticket.getStatus())) {
                throw new RuntimeException("Only tickets with status 'Pending' can be updated.");
            }
            ticket.setDescription(ticketRequest.getDescription());
            ticket.setType(ticketRequest.getType());
            ticket.setTicket(ticketRequest.getTicket());
            ticket.setId(ticketRequest.getId());
            ticket.setAlteredBy(response.getId());
            ticket.setDescription(ticketRequest.getDescription());
            ticket.setCustomerid(ticketRequest.getCustomerid());
            ticket.setTicketcode(ticketRequest.getTicketcode());
            ticket.setMktgid(ticketRequest.getMktgid());
            ticket.setType(ticketRequest.getType());
            ticket.setStatus(ticketRequest.getStatus());
            ticket.setDispatchedAt(ticketRequest.getDispatchedAt());
            ticket.setCompletedAt(ticketRequest.getCompletedAt());
            ticket.setCreatedAt(ticketRequest.getCreatedAt());
            ticket.setRemarks(ticketRequest.getRemarks());
            ticket.setTicket(ticketRequest.getTicket());
            if (TicketType.RETURN.equals((Object)ticketRequest.getType())) {
                if (ticketRequest.getMktgid() == null) {
                    throw new RuntimeException("MKTG ID is required for RETURN tickets.");
                }
                ticket.setMktgid(ticketRequest.getMktgid());
            }
            List existingMaterials = ticket.getMaterialModels();
            List updatedMaterialIds = ticketRequest.getMaterialModels().stream().map(TicketMaterialRequest::getMaterialid).collect(Collectors.toList());
            existingMaterials.removeIf(material -> !updatedMaterialIds.contains(material.getMaterialid()));
            for (TicketMaterialRequest materialRequest : ticketRequest.getMaterialModels()) {
                Optional<TicketMaterialModel> existingMaterialOpt = existingMaterials.stream().filter(material -> material.getMaterialid().equals(materialRequest.getMaterialid())).findFirst();
                if (existingMaterialOpt.isPresent()) {
                    TicketMaterialModel material2 = existingMaterialOpt.get();
                    material2.setCategoryid(materialRequest.getCategoryid());
                    material2.setQnty(materialRequest.getQnty());
                    material2.setQntydescription(materialRequest.getQntydescription());
                    continue;
                }
                TicketMaterialModel newMaterial = new TicketMaterialModel();
                newMaterial.setCategoryid(materialRequest.getCategoryid());
                newMaterial.setQnty(materialRequest.getQnty());
                newMaterial.setQntydescription(materialRequest.getQntydescription());
                newMaterial.setTicket(ticket);
                existingMaterials.add(newMaterial);
            }
            ticket.setMaterialModels(existingMaterials);
            logger.debug("Saving updated ticket: {}", (Object)ticket);
            TicketModel updatedTicket = (TicketModel)this.ticketRepository.save((Object)ticket);
            return updatedTicket;
        }
        catch (RuntimeException e) {
            logger.error("Runtime exception occurred: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("Error updating ticket: " + e.getMessage(), e);
        }
        catch (Exception e) {
            logger.error("Unexpected exception occurred: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("An unexpected error occurred while updating the ticket: " + e.getMessage(), e);
        }
    }

    public void deleteTicket(Long id) {
        TicketModel existingTicket = this.getTicketsByIdWithoutvalue(id);
        this.ticketRepository.delete((Object)existingTicket);
    }

    public List<TicketModel> getPendingTicketsForAdmin(String as) {
        try {
            UserResponse user = this.authenticationService.getDetails(as);
            if (user.getRole().equals((Object)Role.ADMIN)) {
                return this.ticketRepository.findByStatus(TicketStatus.PENDING);
            }
            if (user.getRole().equals((Object)Role.GM)) {
                return this.ticketRepository.findByStatus(TicketStatus.MOVE_TO_GM);
            }
            throw new RuntimeException("User does not have the necessary permissions to view tickets.");
        }
        catch (NullPointerException e) {
            throw new RuntimeException("Failed to retrieve user details. Ensure that the user is properly authenticated.");
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Failed to retrieve pending tickets: " + e.getMessage());
        }
        catch (Exception e) {
            throw new RuntimeException("An unexpected error occurred while retrieving pending tickets: " + e.getMessage());
        }
    }

    public String updateTicketStatus(Long ticketId, TicketStatusUpdateRequest request, String token) throws Exception {
        TicketModel ticket = (TicketModel)this.ticketRepository.findById((Object)ticketId).orElseThrow(() -> new RuntimeException("Ticket not found"));
        System.err.println("WELCOME");
        UserResponse user = this.authenticationService.getDetails(token);
        switch (1.$SwitchMap$com$riot$Branding$model$Role[user.getRole().ordinal()]) {
            case 1: 
            case 2: {
                System.err.println("SUPERADMIN");
                System.err.println("SUPERADMIN " + ticket.getStatus());
            }
            case 3: {
                return this.handleUser(ticket, request);
            }
            case 4: 
            case 5: {
                return this.handleGM(ticket, request, user);
            }
        }
        throw new RuntimeException("Unauthorized action for this role.");
    }

    private String handleUser(TicketModel ticket, TicketStatusUpdateRequest request) {
        try {
            switch (1.$SwitchMap$com$riot$Branding$model$TicketStatus[ticket.getStatus().ordinal()]) {
                case 1: {
                    if (request.getNewStatus() == TicketStatus.RECEIVED) {
                        ticket.setStatus(TicketStatus.RECEIVED);
                        this.ticketRepository.save((Object)ticket);
                        return "Ticket status updated successfully to RECEIVED.";
                    }
                    throw new RuntimeException("Invalid status transition from DISPATCHED to " + request.getNewStatus());
                }
                case 2: {
                    ticket.setStatus(TicketStatus.DELIVERED);
                    TicketModel savedTicket = (TicketModel)this.ticketRepository.save((Object)ticket);
                    if (ticket.getStatus() == TicketStatus.DELIVERED) {
                        for (Long fileId : request.getFileIds()) {
                            FileModel fileModel = this.fileDAO.getByFileid(fileId.longValue());
                            fileModel.setTicketid(savedTicket.getId().toString());
                            this.fileDAO.save(fileModel);
                        }
                        return "Ticket status updated successfully to DELIVERED.";
                    }
                    throw new RuntimeException("Invalid status transition from RECEIVED to " + request.getNewStatus());
                }
            }
            throw new RuntimeException("Unauthorized action for USER or invalid transition.");
        }
        catch (RuntimeException e) {
            return "Error updating ticket status: " + e.getMessage();
        }
        catch (Exception e) {
            return "An unexpected error occurred: " + e.getMessage();
        }
    }

    private Double checkTicketCost(Long stockId, Double totalsqft) {
        StockModel stock = (StockModel)this.stockRepository.findByCategoryid(stockId).orElseThrow(() -> new RuntimeException("Stock not found for ID: " + stockId));
        Double ticketcost = totalsqft * stock.getFinalprice();
        return ticketcost;
    }

    private Double checkTicketCost(Long stockId, Integer qnty) {
        StockModel stock = (StockModel)this.stockRepository.findByCategoryid(stockId).orElseThrow(() -> new RuntimeException("Stock not found for ID: " + stockId));
        Double ticketcost = (double)qnty.intValue() * stock.getFinalprice();
        return ticketcost;
    }

    private void reduceStockQuantity(Long stockId, Integer quantity) {
        StockModel stock = (StockModel)this.stockRepository.findByCategoryid(stockId).orElseThrow(() -> new RuntimeException("Stock not found for ID: " + stockId));
        Integer newQuantity = stock.getTotalunits() - quantity;
        if (newQuantity < 0) {
            throw new RuntimeException("Insufficient stock quantity. Current quantity: " + newQuantity);
        }
        stock.setTotalunits(newQuantity);
        this.stockRepository.save((Object)stock);
        Optional existingStockopt = this.stockRepository.findByCategoryid(stockId);
        if (existingStockopt.isEmpty()) {
            throw new RuntimeException("Stock not found with category ID: " + stockId);
        }
        StockModel existingStock = (StockModel)existingStockopt.get();
        StockUpdateModel stockUpdateModel = new StockUpdateModel();
        stockUpdateModel.setStockid(existingStock.getStockid());
        stockUpdateModel.setV_name(existingStock.getV_name());
        stockUpdateModel.setCategoryid(stockId);
        stockUpdateModel.setStocktype(existingStock.getStocktype());
        stockUpdateModel.setPerunit_price(Double.valueOf(0.0));
        stockUpdateModel.setHandlingcharges(Double.valueOf(0.0));
        stockUpdateModel.setUpdatedQuantity("-" + quantity.toString());
        stockUpdateModel.setFinalprice(Double.valueOf(0.0));
        stockUpdateModel.setFinalunits(newQuantity.toString());
        stockUpdateModel.setCreatedTimestamp(LocalDateTime.now());
        stockUpdateModel.setCreatedTimestamp(LocalDateTime.now());
        this.stockUpdateRepository.save((Object)stockUpdateModel);
    }

    private String handleGM(TicketModel ticket, TicketStatusUpdateRequest request, UserResponse user) throws Exception {
        if (!user.getRole().equals((Object)Role.GM) && !user.getRole().equals((Object)Role.RM)) {
            throw new Exception("Unauthorized Login for " + user.getRole() + ".");
        }
        if (request.getNewStatus() == TicketStatus.HOLD || request.getNewStatus() == TicketStatus.REJECTED) {
            if (request.getNewStatus() == TicketStatus.HOLD) {
                ticket.setStatus(TicketStatus.HOLD);
            } else {
                ticket.setStatus(TicketStatus.REJECTED);
            }
            ticket.setRemarks(request.getRemarks());
            return "Ticket status Currently " + request.getNewStatus() + ".";
        }
        if (ticket.getType().equals((Object)TicketType.PROMOTIONAL_MATERIAL) && ticket.getStatus() == TicketStatus.MOVE_TO_GM) {
            ticket.setStatus(TicketStatus.APPROVE);
            ticket.setApprovalid(user.getId());
            ticket.setApprovalStatus(ApprovalStatus.APPROVED_BY_GM);
            this.ticketRepository.save((Object)ticket);
            return "Ticket status updated successfully to APPROVED.";
        }
        if (ticket.getType().equals((Object)TicketType.LIGHT_BOARD) || ticket.getType().equals((Object)TicketType.WALL_PAINTING) && ticket.getStatus() == TicketStatus.MOVE_TO_RM) {
            ticket.setStatus(TicketStatus.APPROVE);
            ticket.setApprovalid(user.getId());
            ticket.setApprovalStatus(ApprovalStatus.APPROVED_BY_RM);
            this.ticketRepository.save((Object)ticket);
            return "Ticket status updated successfully to APPROVED.";
        }
        if (ticket.getStatus() == TicketStatus.MOVE_TO_GM && request.getNewStatus() == TicketStatus.APPROVE) {
            ticket.setStatus(TicketStatus.APPROVE);
            this.ticketRepository.save((Object)ticket);
            return "Ticket status updated successfully to APPROVED.";
        }
        throw new RuntimeException("Unauthorized action for GM or invalid transition.");
    }

    public List<TicketModel> findByStatus(TicketStatus status) {
        try {
            return this.ticketRepository.findByStatus(status);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while retrieving tickets: " + e.getMessage());
        }
    }

    public List<TicketStatus> getTicketStatusesByRole(String as) {
        try {
            UserResponse user = this.authenticationService.getDetails(as);
            Role role = user.getRole();
            return switch (1.$SwitchMap$com$riot$Branding$model$Role[role.ordinal()]) {
                case 1, 2 -> Arrays.asList(TicketStatus.MOVE_TO_GM, TicketStatus.APPROVE, TicketStatus.DISPATCH, TicketStatus.REJECTED, TicketStatus.VERIFY);
                case 5 -> Arrays.asList(TicketStatus.APPROVE, TicketStatus.REJECTED);
                case 3 -> Arrays.asList(TicketStatus.RECEIVED, TicketStatus.DELIVERED);
                default -> Arrays.asList(TicketStatus.UNKNOWN);
            };
        }
        catch (Exception e) {
            System.err.println("Error retrieving ticket statuses: " + e.getMessage());
            return Collections.emptyList();
        }
    }

    public String username(Long id) {
        if (id == null) {
            return "N/A";
        }
        Optional user = this.userRepository.findById((Object)id);
        return user.map(User::getName).orElse("N/A");
    }

    public String customername(Long id) {
        if (id == null) {
            return "N/A";
        }
        Optional customer = this.customerRepository.findById((Object)id);
        return customer.map(CustomerModel::getC_name).orElse("N/A");
    }

    public String vendorname(Long id) {
        if (id == null) {
            return "N/A";
        }
        Optional user = this.vendorRepository.findById((Object)id);
        return user.map(VendorModel::getV_name).orElse("N/A");
    }

    public List<MktgIssuedProductModel> findTicketsByMktgAndStatus(Long mktgId) {
        return this.issuedProductRepository.findByMktgid(mktgId);
    }

    private List<TicketStatus> getListOfTicketStatuses(TicketModel ticketModel, UserResponse response) {
        List<Object> statuses = new ArrayList<TicketStatus>();
        switch (1.$SwitchMap$com$riot$Branding$model$Role[response.getRole().ordinal()]) {
            case 1: 
            case 2: {
                statuses = this.getAdminTicketStatuses(ticketModel);
                break;
            }
            case 4: 
            case 5: {
                statuses = this.getGmTicketStatuses(ticketModel, response);
                break;
            }
            case 3: {
                statuses = this.getUserTicketStatuses(ticketModel);
                break;
            }
        }
        return statuses;
    }

    private List<TicketStatus> getAdminTicketStatuses(TicketModel ticketModel) {
        switch (1.$SwitchMap$com$riot$Branding$model$TicketStatus[ticketModel.getStatus().ordinal()]) {
            case 3: 
            case 4: {
                if (ticketModel.getType().equals((Object)TicketType.RETURN)) {
                    return Arrays.asList(TicketStatus.APPROVE, TicketStatus.REJECTED);
                }
                return Arrays.asList(TicketStatus.HOLD);
            }
            case 5: 
            case 6: {
                return Arrays.asList(TicketStatus.HOLD);
            }
            case 7: {
                return Arrays.asList(TicketStatus.DISPATCH);
            }
            case 1: {
                if (ticketModel.getType().equals((Object)TicketType.RETURN)) {
                    return Arrays.asList(TicketStatus.RECEIVED, TicketStatus.RECEIVED$VERIFY);
                }
                return Arrays.asList(TicketStatus.HOLD);
            }
            case 2: {
                if (ticketModel.getType().equals((Object)TicketType.RETURN)) {
                    return Arrays.asList(TicketStatus.VERIFY);
                }
                return new ArrayList<TicketStatus>();
            }
            case 8: 
            case 9: {
                return new ArrayList<TicketStatus>();
            }
            case 10: {
                return Arrays.asList(TicketStatus.VERIFY);
            }
            case 11: {
                return Arrays.asList(TicketStatus.DISPATCH);
            }
        }
        return new ArrayList<TicketStatus>();
    }

    private List<TicketStatus> getGmTicketStatuses(TicketModel ticketModel, UserResponse response) {
        switch (1.$SwitchMap$com$riot$Branding$model$TicketStatus[ticketModel.getStatus().ordinal()]) {
            case 4: 
            case 12: {
                return Arrays.asList(TicketStatus.APPROVE, TicketStatus.HOLD, TicketStatus.REJECTED);
            }
            case 3: {
                return Arrays.asList(TicketStatus.APPROVE, TicketStatus.REJECTED);
            }
            case 5: 
            case 6: {
                if (response.getRole().equals((Object)Role.GM) && ticketModel.getType().equals((Object)TicketType.LIGHT_BOARD)) {
                    return Arrays.asList(TicketStatus.HOLD);
                }
                return Arrays.asList(TicketStatus.APPROVE, TicketStatus.HOLD);
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return new ArrayList<TicketStatus>();
            }
        }
        return new ArrayList<TicketStatus>();
    }

    private List<TicketStatus> getUserTicketStatuses(TicketModel ticketModel) {
        switch (1.$SwitchMap$com$riot$Branding$model$TicketStatus[ticketModel.getStatus().ordinal()]) {
            case 7: {
                if (ticketModel.getType().equals((Object)TicketType.RETURN)) {
                    return Arrays.asList(TicketStatus.DISPATCH);
                }
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return new ArrayList<TicketStatus>();
            }
            case 1: {
                if (ticketModel.getType().equals((Object)TicketType.RETURN)) {
                    return new ArrayList<TicketStatus>();
                }
                return Arrays.asList(TicketStatus.RECEIVED);
            }
            case 2: {
                return Arrays.asList(TicketStatus.DELIVERED);
            }
        }
        return new ArrayList<TicketStatus>();
    }

    @Generated
    public TicketServiceImpl() {
    }
}

