/*
 * Decompiled with CFR 0.152.
 */
package com.riot.Branding.service;

import com.riot.Branding.model.BrandModel;
import com.riot.Branding.model.CustomerModel;
import com.riot.Branding.model.StockMainCategoryModel;
import com.riot.Branding.model.StockModel;
import com.riot.Branding.model.StockSubCategory;
import com.riot.Branding.model.StockUpdateModel;
import com.riot.Branding.model.TicketType;
import com.riot.Branding.repository.BrandRepository;
import com.riot.Branding.repository.StockCategoryRepository;
import com.riot.Branding.repository.StockRepository;
import com.riot.Branding.repository.StockSubCategoryRepository;
import com.riot.Branding.repository.StockUpdateRepository;
import com.riot.Branding.request.StockUpdateRequest;
import com.riot.Branding.response.StockUpdateResponse;
import com.riot.Branding.service.CustomerService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class StockService {
    @Autowired
    private StockRepository stockRepository;
    @Autowired
    private StockUpdateRepository stockUpdateRepository;
    @Autowired
    private StockCategoryRepository categoryRepository;
    @Autowired
    private StockSubCategoryRepository subcategoryRepository;
    @Autowired
    CustomerService customerService;
    @Autowired
    BrandRepository brandRepository;
    private static final Logger logger = LoggerFactory.getLogger(StockService.class);

    public StockUpdateModel createStock(StockUpdateRequest stockRequest) {
        System.err.println("ENTEE 1");
        if (stockRequest.getStocktype().equals((Object)TicketType.PROMOTIONAL_MATERIAL)) {
            return this.PromotionalMaterial(stockRequest);
        }
        if (stockRequest.getStocktype().equals((Object)TicketType.LIGHT_BOARD)) {
            System.err.println("ENTEE ");
            return this.LIGHT_BOARD(stockRequest);
        }
        if (stockRequest.getStocktype().equals((Object)TicketType.WALL_PAINTING)) {
            return this.WallPainting(stockRequest);
        }
        return null;
    }

    public StockUpdateModel PromotionalMaterial(StockUpdateRequest stockRequest) {
        try {
            StockModel model = this.stockRepository.findByCategoryid(stockRequest.getCategoryid()).orElse(new StockModel());
            StockUpdateModel stockUpdateModel = this.populateStockUpdateModel(stockRequest);
            int availableUnits = model.getTotalunits() == null || model.getTotalunits() <= 0 ? 0 : model.getTotalunits();
            int balanceUnits = availableUnits + stockRequest.getNewqnty();
            double totalCost = stockRequest.getPerunit_price() * (double)stockRequest.getNewqnty().intValue() + stockRequest.getHandlingcharges();
            double get_totalcost = model.getTotalamount() == null || model.getTotalamount() <= 0.0 ? 0.0 : model.getTotalamount();
            double perprice_totalcost = get_totalcost + totalCost;
            double finalPrice = perprice_totalcost / (double)(balanceUnits <= 0 ? stockRequest.getNewqnty() : balanceUnits);
            stockUpdateModel.setBalanceqnty(Integer.valueOf(balanceUnits));
            stockUpdateModel.setStockamount(Double.valueOf(totalCost));
            stockUpdateModel.setFinalprice(Double.valueOf(finalPrice));
            double updatedTotalAmount = totalCost + (model.getTotalamount() != null ? model.getTotalamount() : 0.0);
            stockUpdateModel.setTotalamount(Double.valueOf(updatedTotalAmount));
            StockUpdateModel savedStockUpdate = (StockUpdateModel)this.stockUpdateRepository.save((Object)stockUpdateModel);
            this.updateStockModel(model, stockRequest, savedStockUpdate, Double.valueOf(finalPrice));
            StockModel savedStock = (StockModel)this.stockRepository.save((Object)model);
            savedStockUpdate.setStockid(savedStock.getStockid());
            return (StockUpdateModel)this.stockUpdateRepository.save((Object)savedStockUpdate);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Invalid input: " + e.getMessage(), e);
        }
        catch (DataAccessException e) {
            throw new RuntimeException("Database error while creating stock: " + e.getMessage(), e);
        }
        catch (Exception e) {
            logger.error("Unexpected error: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("Unexpected error while creating stock: " + e.getMessage(), e);
        }
    }

    public StockUpdateModel LIGHT_BOARD(StockUpdateRequest stockRequest) {
        try {
            logger.info("Processing LIGHT_BOARD stock update for category: {}", (Object)stockRequest.getCategoryid());
            StockModel model = this.stockRepository.findByCategoryid(stockRequest.getCategoryid()).orElseGet(() -> {
                logger.warn("No existing stock found for category: {}", (Object)stockRequest.getCategoryid());
                return new StockModel();
            });
            double currentTotal = model.getTotalamount() != null ? model.getTotalamount() : 0.0;
            StockUpdateModel stockUpdateModel = this.populateStockUpdateModelForLIGHT_BOARD(stockRequest);
            if (stockUpdateModel == null) {
                throw new RuntimeException("Failed to populate StockUpdateModel for LIGHT_BOARD.");
            }
            int availableUnits = model.getTotalunits() == null || model.getTotalunits() <= 0 ? 0 : model.getTotalunits();
            int balanceUnits = availableUnits + stockRequest.getNewqnty();
            stockUpdateModel.setBalanceqnty(Integer.valueOf(balanceUnits));
            stockUpdateModel.setCustomerid(stockRequest.getCustomerid());
            stockUpdateModel.setStockamount(stockRequest.getStockamount());
            double updatedTotalAmount = stockRequest.getStockamount() + currentTotal;
            stockUpdateModel.setTotalamount(Double.valueOf(updatedTotalAmount));
            logger.info("Stock update model prepared: {}", (Object)stockUpdateModel);
            StockUpdateModel savedStockUpdate = (StockUpdateModel)this.stockUpdateRepository.save((Object)stockUpdateModel);
            logger.info("Saved stock update model: {}", (Object)savedStockUpdate);
            this.updateStockModel(model, stockRequest, savedStockUpdate, Double.valueOf(0.0));
            StockModel savedStock = (StockModel)this.stockRepository.save((Object)model);
            logger.info("Saved stock model: {}", (Object)savedStock);
            savedStockUpdate.setStockid(savedStock.getStockid());
            StockUpdateModel finalSavedStockUpdate = (StockUpdateModel)this.stockUpdateRepository.save((Object)savedStockUpdate);
            logger.info("Final saved stock update model: {}", (Object)finalSavedStockUpdate);
            return finalSavedStockUpdate;
        }
        catch (IllegalArgumentException e) {
            logger.error("Invalid input for stock creation", (Throwable)e);
            throw new RuntimeException("Invalid input: " + e.getMessage(), e);
        }
        catch (DataAccessException e) {
            logger.error("Database error while saving stock", (Throwable)e);
            throw new RuntimeException("Database error: " + e.getMessage(), e);
        }
        catch (Exception e) {
            logger.error("Unexpected error in LIGHT_BOARD method", (Throwable)e);
            throw new RuntimeException("Unexpected error: " + e.getMessage(), e);
        }
    }

    public StockUpdateModel WallPainting(StockUpdateRequest stockRequest) {
        try {
            StockModel model = this.stockRepository.findByCategoryid(stockRequest.getCategoryid()).orElse(new StockModel());
            StockUpdateModel stockUpdateModel = this.populateStockUpdateModelForLIGHT_BOARD(stockRequest);
            stockUpdateModel.setPaintarea(stockRequest.getPaintarea());
            if (stockRequest.getPaintarea().equalsIgnoreCase("Customer")) {
                stockUpdateModel.setCustomerid(stockRequest.getCustomerid());
            } else {
                stockUpdateModel.setMktgid(stockRequest.getMktgid());
            }
            stockUpdateModel.setStockamount(stockRequest.getStockamount());
            double updatedTotalAmount = stockRequest.getStockamount() + (model.getTotalamount() != null ? model.getTotalamount() : 0.0);
            stockUpdateModel.setTotalamount(Double.valueOf(updatedTotalAmount));
            StockUpdateModel savedStockUpdate = (StockUpdateModel)this.stockUpdateRepository.save((Object)stockUpdateModel);
            this.updateStockModel(model, stockRequest, savedStockUpdate, Double.valueOf(0.0));
            StockModel savedStock = (StockModel)this.stockRepository.save((Object)model);
            savedStockUpdate.setStockid(savedStock.getStockid());
            return (StockUpdateModel)this.stockUpdateRepository.save((Object)savedStockUpdate);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Invalid input: " + e.getMessage(), e);
        }
        catch (DataAccessException e) {
            throw new RuntimeException("Database error while creating stock: " + e.getMessage(), e);
        }
        catch (Exception e) {
            logger.error("Unexpected error: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("Unexpected error while creating stock: " + e.getMessage(), e);
        }
    }

    private StockUpdateModel populateStockUpdateModel(StockUpdateRequest stockRequest) {
        System.err.println("Populating StockUpdateModel with request data...");
        return StockUpdateModel.builder().stocktype(stockRequest.getStocktype()).categoryid(stockRequest.getCategoryid()).vendorid(stockRequest.getVendorid()).v_name(stockRequest.getV_name()).measureunits(stockRequest.getMeasureunits()).newqnty(stockRequest.getNewqnty()).perunit_price(stockRequest.getPerunit_price()).handlingcharges(stockRequest.getHandlingcharges()).brandid(stockRequest.getBrandid()).description(stockRequest.getDescription()).createdTimestamp(LocalDateTime.now()).updatedQuantity("+" + stockRequest.getNewqnty()).build();
    }

    private StockUpdateModel populateStockUpdateModelForLIGHT_BOARD(StockUpdateRequest stockRequest) {
        System.err.println("Populating StockUpdateModel with request data...");
        return StockUpdateModel.builder().stocktype(stockRequest.getStocktype()).categoryid(stockRequest.getCategoryid()).vendorid(stockRequest.getVendorid()).v_name(stockRequest.getV_name()).measureunits(stockRequest.getMeasureunits()).newqnty(stockRequest.getNewqnty()).handlingcharges(stockRequest.getHandlingcharges()).brandid(stockRequest.getBrandid()).description(stockRequest.getDescription()).createdTimestamp(LocalDateTime.now()).updatedQuantity("+" + stockRequest.getNewqnty()).build();
    }

    private void updateStockModel(StockModel model, StockUpdateRequest stockRequest, StockUpdateModel stockUpdateModel, Double finalPrice) {
        System.err.println("Updating StockModel with new data...");
        model.setStocktype(stockRequest.getStocktype());
        model.setCategoryid(stockRequest.getCategoryid());
        model.setVendorid(stockRequest.getVendorid());
        model.setBrandid(stockRequest.getBrandid());
        model.setV_name(stockRequest.getV_name());
        model.setMeasureunits(stockRequest.getMeasureunits());
        model.setTotalunits(stockUpdateModel.getBalanceqnty());
        if (finalPrice != 0.0) {
            model.setFinalprice(finalPrice);
        }
        model.setTotalamount(stockUpdateModel.getTotalamount());
        System.err.println("StockModel updated: " + model);
    }

    public List<StockUpdateResponse> getAllStocks() {
        ArrayList<StockUpdateResponse> stockResponses = new ArrayList<StockUpdateResponse>();
        try {
            List stockModels = this.stockRepository.findAll();
            for (StockModel stockModel : stockModels) {
                StockUpdateResponse response = this.mapToStockResponse(stockModel);
                stockResponses.add(response);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error retrieving stocks: " + e.getMessage());
        }
        return stockResponses;
    }

    public StockModel getStockById(Long id) {
        try {
            return (StockModel)this.stockRepository.findById((Object)id).orElseThrow(() -> new RuntimeException("Stock not found with id: " + id));
        }
        catch (Exception e) {
            throw new RuntimeException("Error retrieving stock: " + e.getMessage());
        }
    }

    public void deleteStock(Long id) {
        try {
            StockUpdateModel stockupdatedetails = (StockUpdateModel)this.stockUpdateRepository.findById((Object)id).orElseThrow(() -> new RuntimeException("Stock update not found for ID: " + id));
            StockModel existingStock = this.getStockById(stockupdatedetails.getStockid());
            if (existingStock.getTotalunits() < stockupdatedetails.getNewqnty()) {
                throw new RuntimeException("Error: Cannot reduce stock below zero.");
            }
            Optional previousStockUpdate = this.stockUpdateRepository.findTopByCategoryidAndSidLessThanOrderBySidDesc(stockupdatedetails.getCategoryid(), id);
            if (previousStockUpdate.isPresent()) {
                StockUpdateModel prevStock = (StockUpdateModel)previousStockUpdate.get();
                existingStock.setFinalprice(prevStock.getFinalprice());
                existingStock.setTotalunits(prevStock.getBalanceqnty());
                existingStock.setPerunit(prevStock.getPerunit_price());
            } else {
                existingStock.setFinalprice(Double.valueOf(0.0));
                existingStock.setTotalunits(Integer.valueOf(0));
                existingStock.setPerunit(Double.valueOf(0.0));
            }
            this.stockRepository.save((Object)existingStock);
            this.stockUpdateRepository.deleteById((Object)id);
        }
        catch (Exception e) {
            throw new RuntimeException("Error deleting stock: " + e.getMessage());
        }
    }

    public List<StockUpdateResponse> getStockByType(TicketType type) {
        try {
            ArrayList<StockUpdateResponse> stockResponses = new ArrayList<StockUpdateResponse>();
            List stockList = this.stockRepository.findByStocktype(type);
            if (stockList.isEmpty()) {
                throw new RuntimeException("Stock not found with type: " + type);
            }
            for (StockModel stockModel : stockList) {
                StockUpdateResponse response = this.mapToStockResponse(stockModel);
                stockResponses.add(response);
            }
            return stockResponses;
        }
        catch (Exception e) {
            throw new RuntimeException("Error retrieving stock: " + e.getMessage());
        }
    }

    public ResponseEntity<Map<String, Object>> getUpdatedStockById(Long id) {
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        ArrayList<StockUpdateResponse> stockResponses = new ArrayList<StockUpdateResponse>();
        Integer totalStockQnty = 0;
        Integer issuedStockQnty = 0;
        Integer balanceStockQnty = 0;
        try {
            List stockModels = (List)this.stockUpdateRepository.findByStockid(id).orElseThrow(() -> new RuntimeException("Stock not found with id: " + id));
            for (StockUpdateModel stockModel : stockModels) {
                if (stockModel.getUpdatedQuantity().contains("-")) {
                    issuedStockQnty = issuedStockQnty + stockModel.getNewqnty();
                } else if (stockModel.getUpdatedQuantity().contains("+")) {
                    totalStockQnty = totalStockQnty + stockModel.getNewqnty();
                }
                StockUpdateResponse response = this.mapToStockUpdateResponse(stockModel);
                response.setBrandname(this.getBrandName(stockModel.getBrandid()));
                if (stockModel.getCustomerid() != null) {
                    response.setCustomername(this.getCustomerName(stockModel.getCustomerid()));
                }
                stockResponses.add(response);
            }
            stockResponses.sort((a, b) -> b.getCreatedTimestamp().compareTo(a.getCreatedTimestamp()));
            balanceStockQnty = totalStockQnty - issuedStockQnty;
            responseMap.put("Total Stock Quantity ", totalStockQnty);
            responseMap.put("Issued Stock Quantity ", issuedStockQnty);
            responseMap.put("Balance Stock Quantity ", balanceStockQnty);
            responseMap.put("data", stockResponses);
            responseMap.put("Status", 1);
            responseMap.put("Message", "Stock Retrieved Successfully!");
        }
        catch (NoSuchElementException e) {
            responseMap.put("Status", 0);
            responseMap.put("Message", "Stock not found with id: " + id);
        }
        catch (Exception e) {
            responseMap.put("Status", 0);
            responseMap.put("Message", "Error retrieving stock: " + e.getMessage());
        }
        return ResponseEntity.ok(responseMap);
    }

    public List<StockMainCategoryModel> addCategory(StockMainCategoryModel designationModel) {
        try {
            if (designationModel.getCategory() == null || designationModel.getCategory().trim().isEmpty()) {
                throw new IllegalArgumentException("Category is mandatory.");
            }
            Optional existingDesignation = this.categoryRepository.findByCategory(designationModel.getCategory());
            if (existingDesignation.isEmpty()) {
                designationModel.setBrandname(this.getBrandName(designationModel.getBrandid()));
                this.categoryRepository.save((Object)designationModel);
            }
            return this.categoryRepository.findAll();
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Validation error: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to add category: " + e.getMessage(), e);
        }
    }

    public List<StockMainCategoryModel> getAllCategory() {
        try {
            return this.categoryRepository.findAll();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retrieve all categories: " + e.getMessage(), e);
        }
    }

    public List<StockSubCategory> addSubCategory(StockSubCategory designationModel) {
        try {
            if (designationModel.getCategory() == null || designationModel.getCategory().trim().isEmpty()) {
                throw new IllegalArgumentException("Category is mandatory.");
            }
            Optional existingDesignation = this.subcategoryRepository.findByCategory(designationModel.getCategory());
            if (existingDesignation.isEmpty()) {
                this.subcategoryRepository.save((Object)designationModel);
            }
            return this.subcategoryRepository.findAll();
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Validation error: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to add category: " + e.getMessage(), e);
        }
    }

    public List<StockSubCategory> getAllSubCategory() {
        try {
            return this.subcategoryRepository.findAll();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retrieve all categories: " + e.getMessage(), e);
        }
    }

    public List<StockUpdateResponse> getAllUpdatedStocks() {
        ArrayList<StockUpdateResponse> stockResponses = new ArrayList<StockUpdateResponse>();
        try {
            List stockModels = this.stockUpdateRepository.findAll();
            for (StockUpdateModel stockModel : stockModels) {
                StockUpdateResponse response = this.mapToStockUpdateResponse(stockModel);
                stockResponses.add(response);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error retrieving stocks: " + e.getMessage());
        }
        return stockResponses;
    }

    public String getcategoryname(Long id) {
        try {
            Optional categoryModel = this.categoryRepository.findById((Object)id);
            if (categoryModel.isEmpty()) {
                return null;
            }
            return ((StockMainCategoryModel)categoryModel.get()).getCategory();
        }
        catch (Exception e) {
            throw new RuntimeException("Error retrieving stock: " + e.getMessage());
        }
    }

    public String getStockcategoryname(Long id) {
        try {
            Optional categoryModel = this.subcategoryRepository.findById((Object)id);
            if (categoryModel.isEmpty()) {
                return null;
            }
            return ((StockSubCategory)categoryModel.get()).getCategory();
        }
        catch (Exception e) {
            throw new RuntimeException("Error retrieving stock: " + e.getMessage());
        }
    }

    public StockUpdateResponse mapToStockUpdateResponse(StockUpdateModel stockRequest) {
        return StockUpdateResponse.builder().stocktype(stockRequest.getStocktype()).sid(stockRequest.getSid()).category(this.getcategoryname(stockRequest.getCategoryid())).categoryid(stockRequest.getCategoryid()).customerid(stockRequest.getCustomerid()).balanceqnty(stockRequest.getBalanceqnty()).vendorid(stockRequest.getVendorid()).brandid(stockRequest.getBrandid()).v_name(stockRequest.getV_name()).stockamount(stockRequest.getStockamount()).finalprice(stockRequest.getFinalprice()).measureunits(stockRequest.getMeasureunits()).newqnty(stockRequest.getNewqnty()).perunit_price(stockRequest.getPerunit_price()).handlingcharges(stockRequest.getHandlingcharges()).description(stockRequest.getDescription()).totalamount(stockRequest.getTotalamount()).createdTimestamp(stockRequest.getCreatedTimestamp()).updatedQuantity(stockRequest.getUpdatedQuantity()).returnkey(stockRequest.getReturnkey() != null ? stockRequest.getReturnkey() : "0").build();
    }

    public StockUpdateResponse mapToStockResponse(StockModel stockModel) {
        StockUpdateResponse response = new StockUpdateResponse();
        try {
            response.setStockid(stockModel.getStockid());
            response.setCategoryid(stockModel.getCategoryid());
            response.setVendorid(stockModel.getVendorid());
            response.setBrandid(stockModel.getBrandid());
            response.setMeasureunits(stockModel.getMeasureunits());
            String categoryName = this.getcategoryname(stockModel.getCategoryid());
            if (categoryName == null) {
                categoryName = "Unknown";
            }
            response.setCategoryname(categoryName);
            response.setCategory(categoryName);
            response.setStocktype(stockModel.getStocktype());
            response.setV_name(stockModel.getV_name());
            response.setTotalunits(stockModel.getTotalunits() != null ? stockModel.getTotalunits().toString() : "0");
            response.setFinalprice(Double.valueOf(stockModel.getFinalprice() != null ? stockModel.getFinalprice() : 0.0));
        }
        catch (Exception e) {
            throw new RuntimeException("Error mapping StockModel to StockUpdateResponse: " + e.getMessage(), e);
        }
        return response;
    }

    public List<StockUpdateResponse> getStocksBYId(Long customerid) {
        ArrayList<StockUpdateResponse> stockResponses = new ArrayList<StockUpdateResponse>();
        try {
            List stockModels = this.stockUpdateRepository.findByCustomeridWithPositiveQuantity(customerid);
            for (StockUpdateModel stockModel : stockModels) {
                StockUpdateResponse response = this.mapToStockUpdateResponse(stockModel);
                stockResponses.add(response);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error retrieving stocks: " + e.getMessage());
        }
        return stockResponses;
    }

    private String getBrandName(Long brandId) {
        if (brandId == null) {
            return "N/A";
        }
        return this.brandRepository.findById((Object)brandId).map(BrandModel::getB_name).orElse("Unknown Brand");
    }

    public String getCustomerName(Long customerId) {
        Optional customerModel = this.customerService.getCustomerById(customerId);
        return customerModel.isPresent() ? ((CustomerModel)customerModel.get()).getC_name() : "N/A";
    }
}

