/*
 * Decompiled with CFR 0.152.
 */
package com.riot.Branding.service;

import com.riot.Branding.dao.FileDAO;
import com.riot.Branding.model.CustomerMartialModel;
import com.riot.Branding.model.CustomerModel;
import com.riot.Branding.model.Role;
import com.riot.Branding.model.StockModel;
import com.riot.Branding.model.StockUpdateModel;
import com.riot.Branding.model.TicketMaterialModel;
import com.riot.Branding.model.TicketModel;
import com.riot.Branding.model.User;
import com.riot.Branding.model.VendorModel;
import com.riot.Branding.repository.CustomerRepository;
import com.riot.Branding.repository.StockRepository;
import com.riot.Branding.repository.StockUpdateRepository;
import com.riot.Branding.repository.TicketRepository;
import com.riot.Branding.repository.UserRepository;
import com.riot.Branding.repository.VendorRepository;
import com.riot.Branding.request.CustomerDTO;
import com.riot.Branding.request.CustomerMartialDTO;
import com.riot.Branding.request.FilterRequest;
import com.riot.Branding.request.TicketMaterialRequest;
import com.riot.Branding.request.VendorRequest;
import com.riot.Branding.response.StockUpdateResponse;
import com.riot.Branding.response.TicketResponse;
import com.riot.Branding.response.UserFieldResponse;
import com.riot.Branding.response.UserResponse;
import com.riot.Branding.service.AuthenticationService;
import com.riot.Branding.service.CustomerServiceImpl;
import com.riot.Branding.service.StockService;
import com.riot.Branding.service.TicketServiceImpl;
import com.riot.Branding.service.UserServiceImpl;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FilterService {
    @Autowired
    private AuthenticationService authenticationService;
    @Autowired
    private CustomerRepository customerMartialRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private VendorRepository vendorRepository;
    @Autowired
    private TicketRepository ticketRepository;
    @Autowired
    private StockRepository stockRepository;
    @Autowired
    private UserServiceImpl userServiceImpl;
    @Autowired
    private CustomerServiceImpl customerServiceImpl;
    @Autowired
    private StockService stockService;
    @Autowired
    private StockUpdateRepository stockUpdateRepository;
    @Autowired
    private TicketServiceImpl ticketServiceImpl;
    @Autowired
    private FileDAO fileDAO;
    @Autowired
    private CustomerRepository customerRepository;

    public List<UserFieldResponse> filterUsers(FilterRequest filterRequest, String token) {
        try {
            ArrayList userResponse;
            UserResponse response = this.authenticationService.getDetails(token);
            User userDetail = this.userServiceImpl.findUserById(response.getId());
            Role userRole = userDetail.getRole();
            if (Role.SUPERADMIN.equals((Object)userRole)) {
                userResponse = this.isFilterRequestEmpty(filterRequest) ? this.userServiceImpl.getAllUsers().stream().filter(user -> !Role.SUPERADMIN.equals((Object)user.getRole())).collect(Collectors.toList()) : this.userRepository.findUsersByFilters(filterRequest.getCity(), filterRequest.getDesignationid(), filterRequest.getBrandid(), Boolean.valueOf(true));
            } else if (Role.GM.equals((Object)userRole)) {
                List<Object> filteredUsers = new ArrayList();
                List rmUsers = this.userRepository.findByGuideidAndRoleAndStatus(userDetail.getId(), Role.RM, true);
                ArrayList marketingUsersFromRMs = new ArrayList();
                for (User rmUser : rmUsers) {
                    List mktgUsers = this.userRepository.findByGuideidAndRoleAndStatus(rmUser.getId(), Role.USER, true);
                    marketingUsersFromRMs.addAll(mktgUsers);
                }
                List directMarketingUsers = this.userRepository.findByGuideidAndRoleAndStatus(userDetail.getId(), Role.USER, true);
                filteredUsers.addAll(marketingUsersFromRMs);
                filteredUsers.addAll(directMarketingUsers);
                if (!this.isFilterRequestEmpty(filterRequest)) {
                    filteredUsers = filteredUsers.stream().filter(user -> this.matchesFilter(user, filterRequest)).collect(Collectors.toList());
                }
                userResponse = filteredUsers;
            } else if (Role.RM.equals((Object)userRole)) {
                List<Object> filteredUsers = new ArrayList();
                ArrayList marketingUsersFromRMs = new ArrayList();
                List mktgUsers = this.userRepository.findByGuideidAndRoleAndStatus(userDetail.getId(), Role.USER, true);
                marketingUsersFromRMs.addAll(mktgUsers);
                List directMarketingUsers = this.userRepository.findByGuideidAndRoleAndStatus(userDetail.getId(), Role.USER, true);
                filteredUsers.addAll(marketingUsersFromRMs);
                filteredUsers.addAll(directMarketingUsers);
                if (!this.isFilterRequestEmpty(filterRequest)) {
                    filteredUsers = filteredUsers.stream().filter(user -> this.matchesFilter(user, filterRequest)).collect(Collectors.toList());
                }
                userResponse = filteredUsers;
            } else {
                Long brandId = userDetail.getBrandid();
                userResponse = this.isFilterRequestEmpty(filterRequest) ? this.userServiceImpl.getAllUsers().stream().filter(user -> brandId.equals(user.getBrandid()) && Boolean.TRUE.equals(user.getStatus()) && !Role.SUPERADMIN.equals((Object)user.getRole())).collect(Collectors.toList()) : this.userRepository.findUsersByFilters(filterRequest.getCity(), filterRequest.getDesignationid(), brandId, Boolean.valueOf(true));
            }
            return userResponse.stream().map(arg_0 -> this.convertToDTO(arg_0)).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to filter Users: " + e.getMessage(), e);
        }
    }

    private boolean matchesFilter(User user, FilterRequest filterRequest) {
        return !(filterRequest.getCity() != null && !filterRequest.getCity().equals(user.getCity()) || filterRequest.getDesignationid() != null && !filterRequest.getDesignationid().equals(user.getDesignationid()) || filterRequest.getBrandid() != null && !filterRequest.getBrandid().equals(user.getBrandid()));
    }

    public List<CustomerDTO> filterCustomer(FilterRequest filterRequest, String token) {
        try {
            List customerModels;
            UserResponse response = this.authenticationService.getDetails(token);
            User userdetail = this.userServiceImpl.findUserById(response.getId());
            Long brandid = userdetail.getBrandid();
            if (response.getRole().equals((Object)Role.SUPERADMIN)) {
                customerModels = this.customerRepository.findAll();
            } else if (response.getRole().equals((Object)Role.USER)) {
                customerModels = this.customerRepository.findByMktgref(userdetail.getId());
            } else {
                List marketingUsers = this.userRepository.findByBrandid(brandid);
                List marketingIds = marketingUsers.stream().map(User::getId).collect(Collectors.toList());
                customerModels = this.customerRepository.findByMktgrefIn(marketingIds);
            }
            customerModels = customerModels.stream().filter(customer -> !(filterRequest.getCity() != null && !customer.getCity().equalsIgnoreCase(filterRequest.getCity().trim()) || filterRequest.getDistrict() != null && !customer.getDistrict().equalsIgnoreCase(filterRequest.getDistrict().trim()) || filterRequest.getMktgid() != null && !customer.getMktgref().equals(filterRequest.getMktgid()))).collect(Collectors.toList());
            return customerModels.stream().map(arg_0 -> this.convertToCustomerDTO(arg_0)).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to filter customers: " + e.getMessage());
        }
    }

    public List<VendorRequest> filterVendors(FilterRequest filterRequest, String token) {
        List vendorModels = this.vendorRepository.findVendorsByFilters(filterRequest.getProductDealing(), filterRequest.getState(), filterRequest.getCity(), filterRequest.getDistrict());
        return vendorModels.stream().map(arg_0 -> this.convertToVendorRequest(arg_0)).collect(Collectors.toList());
    }

    public List<TicketResponse> filterTicket(FilterRequest filterRequest, String token) {
        try {
            UserResponse response = this.authenticationService.getDetails(token);
            User userDetail = this.userServiceImpl.findUserById(response.getId());
            Role userRole = userDetail.getRole();
            System.out.println("User Role: " + userRole);
            System.out.println("Filter Request - Type: " + filterRequest.getType() + ", Status: " + filterRequest.getStatus());
            List model = new ArrayList();
            if (Role.SUPERADMIN.equals((Object)userRole)) {
                System.out.println("Role: SUPERADMIN - Fetching all filtered tickets");
                model = this.ticketRepository.findTicketsByFilters(filterRequest.getType(), filterRequest.getStatus());
            } else if (Role.USER.equals((Object)userRole)) {
                Long userId = userDetail.getId();
                System.out.println("Role: USER - Fetching tickets for User ID: " + userId);
                model = this.ticketRepository.findTicketsByMktgAndFilters(userId, filterRequest.getType(), filterRequest.getStatus());
            } else if (Role.GM.equals((Object)userRole)) {
                System.out.println("Role: GM/RM - Fetching all tickets for further filtering");
                allTickets = this.ticketRepository.findAll();
                List rmUsers = this.userRepository.findByGuideidAndRoleAndStatus(response.getId(), Role.RM, true);
                System.out.println("Total RM Users Found: " + rmUsers.size());
                ArrayList allMarketingUsers = new ArrayList();
                for (User rmUser : rmUsers) {
                    List mktgUsers = this.userRepository.findByGuideidAndRoleAndStatus(rmUser.getId(), Role.USER, true);
                    System.out.println("RM ID: " + rmUser.getId() + " | Marketing Users Found: " + mktgUsers.size());
                    allMarketingUsers.addAll(mktgUsers);
                }
                List directMarketingUsers = this.userRepository.findByGuideidAndRoleAndStatus(response.getId(), Role.USER, true);
                System.out.println("Direct Marketing Users Reporting to GM: " + directMarketingUsers.size());
                allMarketingUsers.addAll(directMarketingUsers);
                System.out.println("Total Marketing Users Found: " + allMarketingUsers.size());
                ArrayList filteredTickets = new ArrayList();
                for (User mktgUser : allMarketingUsers) {
                    filteredTickets.addAll(allTickets.stream().filter(ticket -> {
                        boolean match = !(!Objects.equals(ticket.getMktgid(), mktgUser.getId()) || !Objects.equals(mktgUser.getBrandid(), userDetail.getBrandid()) || filterRequest.getStatus() != null && !Objects.equals(ticket.getStatus(), filterRequest.getStatus()) || filterRequest.getType() != null && !Objects.equals(ticket.getType(), filterRequest.getType()));
                        System.out.println("Ticket ID: " + ticket.getId() + " | Ticket Mktg ID: " + ticket.getMktgid() + " | Marketing User ID: " + mktgUser.getId() + " | Status: " + ticket.getStatus() + " | Type: " + ticket.getType() + " | Match Found: " + match);
                        return match;
                    }).collect(Collectors.toList()));
                }
                System.out.println("Total Filtered Tickets for GM/RM: " + filteredTickets.size());
                model = filteredTickets;
            } else if (Role.RM.equals((Object)userRole)) {
                System.out.println("Role: GM/RM - Fetching all tickets for further filtering");
                allTickets = this.ticketRepository.findAll();
                ArrayList allMarketingUsers = new ArrayList();
                List mktgUsers = this.userRepository.findByGuideidAndRoleAndStatus(response.getId(), Role.USER, true);
                System.out.println("RM ID: " + response.getId() + " | Marketing Users Found: " + mktgUsers.size());
                allMarketingUsers.addAll(mktgUsers);
                List directMarketingUsers = this.userRepository.findByGuideidAndRoleAndStatus(response.getId(), Role.USER, true);
                System.out.println("Direct Marketing Users Reporting to GM: " + directMarketingUsers.size());
                allMarketingUsers.addAll(directMarketingUsers);
                System.out.println("Total Marketing Users Found: " + allMarketingUsers.size());
                ArrayList filteredTickets = new ArrayList();
                for (User mktgUser : allMarketingUsers) {
                    filteredTickets.addAll(allTickets.stream().filter(ticket -> {
                        boolean match = !(!Objects.equals(ticket.getMktgid(), mktgUser.getId()) || !Objects.equals(mktgUser.getBrandid(), userDetail.getBrandid()) || filterRequest.getStatus() != null && !Objects.equals(ticket.getStatus(), filterRequest.getStatus()) || filterRequest.getType() != null && !Objects.equals(ticket.getType(), filterRequest.getType()));
                        System.out.println("Ticket ID: " + ticket.getId() + " | Ticket Mktg ID: " + ticket.getMktgid() + " | Marketing User ID: " + mktgUser.getId() + " | Status: " + ticket.getStatus() + " | Type: " + ticket.getType() + " | Match Found: " + match);
                        return match;
                    }).collect(Collectors.toList()));
                }
                System.out.println("Total Filtered Tickets for GM/RM: " + filteredTickets.size());
                model = filteredTickets;
            }
            List<TicketResponse> ticketResponses = model.stream().map(arg_0 -> this.convertToTicketDTO(arg_0)).collect(Collectors.toList());
            System.out.println("Final Ticket Response Size: " + ticketResponses.size());
            return ticketResponses;
        }
        catch (Exception e) {
            System.err.println("Failed to filter tickets: " + e.getMessage());
            e.printStackTrace();
            throw new RuntimeException("Failed to filter tickets: " + e.getMessage(), e);
        }
    }

    public List<StockUpdateResponse> filterStock(FilterRequest filterRequest, String token) {
        List stocks = filterRequest.getStocktype() != null ? this.stockRepository.findByStocktype(filterRequest.getStocktype()) : this.stockRepository.findAll();
        return stocks.stream().map(arg_0 -> this.mapToStockResponse(arg_0)).collect(Collectors.toList());
    }

    public List<StockUpdateResponse> filterUpdatedStock(FilterRequest filterRequest, String token) {
        List<Object> stocks = filterRequest.getCategoryid() != null ? this.stockUpdateRepository.findByCategoryid(filterRequest.getCategoryid()) : this.stockUpdateRepository.findAll();
        boolean isTimeRangeNull = filterRequest.getTimeRange() == null;
        boolean isStocksNull = filterRequest.getStocks() == null;
        boolean isBrandNull = filterRequest.getBrandid() == null;
        boolean isDateRangeNull = filterRequest.getFromdate() == null && filterRequest.getTodate() == null;
        System.err.println(isTimeRangeNull);
        System.err.println(isStocksNull);
        if (isTimeRangeNull && isStocksNull && isDateRangeNull && isBrandNull) {
            return stocks.stream().sorted(Comparator.comparing(StockUpdateModel::getCreatedTimestamp).reversed()).map(arg_0 -> this.mapToStockUpdateResponse(arg_0)).collect(Collectors.toList());
        }
        if (!isDateRangeNull) {
            LocalDate fromDate = filterRequest.getFromdate() != null ? filterRequest.getFromdate() : LocalDate.MIN;
            LocalDate toDate = filterRequest.getTodate() != null ? filterRequest.getTodate() : LocalDate.MAX;
            stocks = stocks.stream().filter(stock -> {
                LocalDate stockDate = stock.getCreatedTimestamp().toLocalDate();
                return !(!stockDate.isEqual(fromDate) && !stockDate.isAfter(fromDate) || !stockDate.isEqual(toDate) && !stockDate.isBefore(toDate));
            }).collect(Collectors.toList());
        }
        if (!isTimeRangeNull && !filterRequest.getTimeRange().isEmpty()) {
            LocalDateTime now = LocalDateTime.now();
            stocks = stocks.stream().filter(arg_0 -> FilterService.lambda$filterUpdatedStock$8(switch (filterRequest.getTimeRange().toLowerCase()) {
                case "24hours" -> now.minusHours(24L);
                case "7days" -> now.minusDays(7L);
                case "1month" -> now.minusMonths(1L);
                default -> LocalDateTime.MIN;
            }, arg_0)).collect(Collectors.toList());
        }
        if (!isStocksNull) {
            stocks = stocks.stream().filter(stock -> {
                String updatedQuantity = stock.getUpdatedQuantity();
                if (updatedQuantity == null) {
                    return false;
                }
                return Boolean.TRUE.equals(filterRequest.getStocks()) ? updatedQuantity.startsWith("+") : updatedQuantity.startsWith("-");
            }).collect(Collectors.toList());
        }
        if (!isBrandNull) {
            stocks = stocks.stream().filter(stock -> stock.getBrandid() != null && stock.getBrandid() == filterRequest.getBrandid()).collect(Collectors.toList());
        }
        return stocks.stream().sorted(Comparator.comparing(StockUpdateModel::getCreatedTimestamp).reversed()).map(arg_0 -> this.mapToStockUpdateResponse(arg_0)).collect(Collectors.toList());
    }

    private boolean isFilterRequestEmpty(FilterRequest filterRequest) {
        return filterRequest == null || filterRequest.getBrandid() == null && filterRequest.getCity() == null && filterRequest.getDesignationid() == null && filterRequest.getDistrict() == null && filterRequest.getMktgid() == null && filterRequest.getProductDealing() == null && filterRequest.getState() == null && filterRequest.getType() == null && filterRequest.getStocktype() == null && (filterRequest.getTimeRange() == null || filterRequest.getTimeRange().isEmpty()) && filterRequest.getStocks() == null && filterRequest.getStatus() == null;
    }

    public StockUpdateResponse mapToStockResponse(StockModel stockModel) {
        StockUpdateResponse response = new StockUpdateResponse();
        try {
            response.setStockid(stockModel.getStockid());
            response.setCategoryid(stockModel.getCategoryid());
            String categoryName = this.stockService.getcategoryname(stockModel.getCategoryid());
            response.setCategoryname(categoryName != null ? categoryName : "Unknown");
            response.setStocktype(stockModel.getStocktype());
            response.setVendorid(stockModel.getVendorid());
            response.setV_name(stockModel.getV_name());
            response.setTotalunits(stockModel.getTotalunits() != null ? stockModel.getTotalunits().toString() : "0");
            response.setPerunit(Double.valueOf(stockModel.getPerunit() != null ? stockModel.getPerunit() : 0.0));
            response.setFinalprice(Double.valueOf(stockModel.getFinalprice() != null ? stockModel.getFinalprice() : 0.0));
        }
        catch (Exception e) {
            throw new RuntimeException("Error mapping StockModel to StockUpdateResponse: " + e.getMessage(), e);
        }
        return response;
    }

    private UserFieldResponse convertToDTO(User user) {
        UserFieldResponse dto = new UserFieldResponse();
        dto.setId(user.getId());
        dto.setName(user.getName());
        dto.setBrandid(user.getBrandid());
        dto.setDesignationid(user.getDesignationid());
        dto.setGuideid(user.getGuideid());
        dto.setBrand(this.userServiceImpl.brandname(user.getBrandid()));
        dto.setDesignation(this.userServiceImpl.designationname(user.getDesignationid()));
        dto.setGuidename(this.userServiceImpl.guidename(user.getGuideid()));
        dto.setEmail(user.getEmail());
        dto.setJoiningdate(user.getJoiningdate());
        dto.setMobile(user.getMobile());
        dto.setCountry(user.getCountry());
        dto.setState(user.getState());
        dto.setCity(user.getCity());
        dto.setArea(user.getArea());
        dto.setUsercode(user.getUsercode());
        dto.setAddress(user.getAddress());
        dto.setStatus(user.getStatus());
        dto.setAccess(user.getAccess());
        dto.setProfile(user.getProfile());
        dto.setRole(user.getRole());
        dto.setRegion(user.getRegion());
        dto.setPeriod(user.getPeriod());
        dto.setReason(user.getReason());
        return dto;
    }

    private CustomerDTO convertToCustomerDTO(CustomerModel customerModel) {
        CustomerDTO dto = new CustomerDTO();
        dto.setId(customerModel.getId());
        dto.setC_name(customerModel.getC_name());
        dto.setCategory(customerModel.getCategory());
        dto.setCategoryname(this.customerServiceImpl.categoryname(customerModel.getCategory()));
        dto.setSubcategory(customerModel.getSubcategory());
        dto.setSubcategoryname(this.customerServiceImpl.subcategoryname(customerModel.getSubcategory()));
        dto.setAddress(customerModel.getAddress());
        dto.setCity(customerModel.getCity());
        dto.setErpid(customerModel.getErpid());
        dto.setDistrict(customerModel.getDistrict());
        dto.setState(customerModel.getState());
        dto.setGst(customerModel.getGst());
        dto.setPincode(customerModel.getPincode());
        dto.setMobile(customerModel.getMobile());
        dto.setWhatsappno(customerModel.getWhatsappno());
        dto.setInstaid(customerModel.getInstaid());
        dto.setFbid(customerModel.getFbid());
        dto.setEmail(customerModel.getEmail());
        dto.setCusgrop(customerModel.getCusgrop());
        dto.setExistingid(customerModel.getExistingid());
        dto.setMktgrefname(this.customerServiceImpl.mktgname(customerModel.getMktgref()));
        dto.setMktgref(customerModel.getMktgref());
        dto.setActivestatus(customerModel.getActivestatus());
        dto.setWhatsappno(customerModel.getWhatsappno());
        dto.setUserMartialModels(customerModel.getUserMartialModels().stream().map(arg_0 -> this.convertMartialModelToDTO(arg_0)).collect(Collectors.toList()));
        return dto;
    }

    private CustomerMartialDTO convertMartialModelToDTO(CustomerMartialModel martialModel) {
        CustomerMartialDTO martialDTO = new CustomerMartialDTO();
        martialDTO.setOwnername(martialModel.getOwnername());
        martialDTO.setMartialstatus(martialModel.getMartialstatus());
        martialDTO.setMarriagedate(martialModel.getMarriagedate());
        martialDTO.setDob(martialModel.getDob());
        martialDTO.setDesignation(martialModel.getDesignation());
        martialDTO.setDesignationname(this.customerServiceImpl.designationname(martialModel.getDesignation()));
        martialDTO.setEmail(martialModel.getEmail());
        martialDTO.setWishes(martialModel.getWishes());
        martialDTO.setId(martialModel.getId());
        martialDTO.setWhatsappno(martialModel.getWhatsappno());
        martialDTO.setMobile(martialModel.getMobile());
        return martialDTO;
    }

    public StockUpdateResponse mapToStockUpdateResponse(StockUpdateModel stockModel) {
        StockUpdateResponse response = new StockUpdateResponse();
        response.setSid(Long.valueOf(stockModel.getSid() != null ? stockModel.getSid() : 0L));
        response.setStockid(Long.valueOf(stockModel.getStockid() != null ? stockModel.getStockid() : 0L));
        response.setCategoryid(Long.valueOf(stockModel.getCategoryid() != null ? stockModel.getCategoryid() : 0L));
        response.setCategoryname(stockModel.getCategoryid() != null ? this.stockService.getcategoryname(stockModel.getCategoryid()) : "Unknown");
        response.setCategory(stockModel.getCategoryid() != null ? this.stockService.getcategoryname(stockModel.getCategoryid()) : "Unknown");
        response.setStocktype(stockModel.getStocktype() != null ? stockModel.getStocktype() : null);
        response.setMeasureunits(stockModel.getMeasureunits() != null ? stockModel.getMeasureunits() : "Unknown");
        response.setV_name(stockModel.getV_name() != null ? stockModel.getV_name() : "Unknown Vendor");
        response.setNewqnty(Integer.valueOf(stockModel.getNewqnty() != null ? stockModel.getNewqnty() : 0));
        response.setBalanceqnty(Integer.valueOf(stockModel.getBalanceqnty() != null ? stockModel.getBalanceqnty() : 0));
        response.setStockamount(Double.valueOf(stockModel.getStockamount() != null ? stockModel.getStockamount() : 0.0));
        response.setPerunit_price(Double.valueOf(stockModel.getPerunit_price() != null ? stockModel.getPerunit_price() : 0.0));
        response.setPerunit_price(Double.valueOf(stockModel.getPerunit_price() != null ? stockModel.getPerunit_price() : 0.0));
        response.setHandlingcharges(Double.valueOf(stockModel.getHandlingcharges() != null ? stockModel.getHandlingcharges() : 0.0));
        response.setFinalprice(Double.valueOf(stockModel.getFinalprice() != null ? stockModel.getFinalprice() : 0.0));
        response.setTotalamount(Double.valueOf(stockModel.getTotalamount() != null ? stockModel.getTotalamount() : 0.0));
        response.setCreatedTimestamp(stockModel.getCreatedTimestamp() != null ? stockModel.getCreatedTimestamp() : LocalDateTime.now());
        response.setUpdatedQuantity(stockModel.getUpdatedQuantity() != null ? stockModel.getUpdatedQuantity() : "0");
        return response;
    }

    private TicketResponse convertToTicketDTO(TicketModel ticketModel) {
        TicketResponse dto = new TicketResponse();
        dto.setId(ticketModel.getId());
        dto.setApprovalid(this.ticketServiceImpl.username(ticketModel.getApprovalid()));
        dto.setAlteredBy(this.ticketServiceImpl.username(ticketModel.getAlteredBy()));
        dto.setCreatedBy(this.ticketServiceImpl.username(ticketModel.getCreatedBy()));
        dto.setDescription(ticketModel.getDescription());
        dto.setCustomerid(ticketModel.getCustomerid());
        dto.setCustomername(this.ticketServiceImpl.customername(ticketModel.getCustomerid()));
        dto.setTicketcode(ticketModel.getTicketcode());
        dto.setMktgid(ticketModel.getMktgid());
        dto.setMktgname(this.ticketServiceImpl.username(ticketModel.getMktgid()));
        dto.setType(ticketModel.getType());
        dto.setStatus(ticketModel.getStatus());
        dto.setDispatchedAt(ticketModel.getDispatchedAt());
        dto.setCompletedAt(ticketModel.getCompletedAt());
        dto.setCreatedAt(ticketModel.getCreatedAt());
        for (TicketMaterialModel materialRequest : ticketModel.getMaterialModels()) {
            TicketMaterialRequest request = new TicketMaterialRequest();
            request.setMaterialid(materialRequest.getMaterialid());
            request.setCategoryid(materialRequest.getCategoryid());
            request.setCategory(materialRequest.getCategory());
            request.setQnty(materialRequest.getQnty());
            request.setIssuedqnty(materialRequest.getIssuedqnty());
        }
        List files = this.fileDAO.findByTicketid(ticketModel.getId());
        dto.setFiles(files);
        return dto;
    }

    private VendorRequest convertToVendorRequest(VendorModel vendorModel) {
        VendorRequest vendorRequest = new VendorRequest();
        try {
            vendorRequest.setId(vendorModel.getId());
            vendorRequest.setV_name(vendorModel.getV_name());
            vendorRequest.setAddress(vendorModel.getAddress());
            vendorRequest.setGstno(vendorModel.getGstno());
            vendorRequest.setCity(vendorModel.getCity());
            vendorRequest.setDistrict(vendorModel.getDistrict());
            vendorRequest.setState(vendorModel.getState());
            vendorRequest.setPincode(vendorModel.getPincode());
            vendorRequest.setMobile(vendorModel.getMobile());
            vendorRequest.setEmail(vendorModel.getEmail());
            vendorRequest.setProductDealing(vendorModel.getProductDealing() != null ? vendorModel.getProductDealing() : new ArrayList());
            List categoryIds = vendorModel.getCategoryid() != null ? vendorModel.getCategoryid() : new ArrayList();
            vendorRequest.setCategoryid(categoryIds);
            ArrayList<String> categoryNames = new ArrayList<String>();
            for (Long categoryId : categoryIds) {
                if (categoryId == null) continue;
                String categoryName = this.stockService.getcategoryname(categoryId);
                categoryNames.add(categoryName);
            }
            vendorRequest.setCategory(categoryNames);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to convert vendor data: " + e.getMessage(), e);
        }
        return vendorRequest;
    }

    private static /* synthetic */ boolean lambda$filterUpdatedStock$8(LocalDateTime fromTime, StockUpdateModel stock) {
        return stock.getCreatedTimestamp() != null && stock.getCreatedTimestamp().isAfter(fromTime);
    }
}

