/*
 * Decompiled with CFR 0.152.
 */
package com.riot.Branding.service;

import com.riot.Branding.model.BrandModel;
import com.riot.Branding.model.CustomerMartialModel;
import com.riot.Branding.model.CustomerModel;
import com.riot.Branding.model.DesignationModel;
import com.riot.Branding.model.Role;
import com.riot.Branding.model.StockModel;
import com.riot.Branding.model.StockUpdateModel;
import com.riot.Branding.model.TicketMaterialModel;
import com.riot.Branding.model.TicketModel;
import com.riot.Branding.model.TicketType;
import com.riot.Branding.model.User;
import com.riot.Branding.model.VendorModel;
import com.riot.Branding.repository.BrandRepository;
import com.riot.Branding.repository.CustomerMartialRepository;
import com.riot.Branding.repository.CustomerRepository;
import com.riot.Branding.repository.DesignationRepository;
import com.riot.Branding.repository.StockRepository;
import com.riot.Branding.repository.StockUpdateRepository;
import com.riot.Branding.repository.TicketMaterialRepository;
import com.riot.Branding.repository.TicketRepository;
import com.riot.Branding.repository.UserRepository;
import com.riot.Branding.repository.VendorRepository;
import com.riot.Branding.request.CustomerMartialDTO;
import com.riot.Branding.request.FilterRequest;
import com.riot.Branding.response.UserResponse;
import com.riot.Branding.service.AuthenticationService;
import com.riot.Branding.service.CustomerService;
import com.riot.Branding.service.StockService;
import com.riot.Branding.service.TicketService;
import com.riot.Branding.service.UserService;
import com.riot.Branding.service.VendorServiceImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

@Service
public class ExcelExportService {
    @Autowired
    private UserService userService;
    @Autowired
    private CustomerService customerService;
    @Autowired
    private CustomerRepository customerRepository;
    @Autowired
    private VendorServiceImpl vendorService;
    @Autowired
    private DesignationRepository designationRepository;
    @Autowired
    private BrandRepository brandRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private TicketRepository ticketRepository;
    @Autowired
    private StockService stockService;
    @Autowired
    private TicketService ticketService;
    @Autowired
    private StockRepository stockRepository;
    @Autowired
    private VendorRepository vendorRepository;
    @Autowired
    private StockUpdateRepository stockUpdateRepository;
    @Autowired
    private CustomerMartialRepository customerMartialRepository;
    @Autowired
    private AuthenticationService authenticationService;
    @Autowired
    private TicketMaterialRepository materialRepository;

    private String getDesignationName(Long designationId) {
        if (designationId == null) {
            return "N/A";
        }
        return this.designationRepository.findById((Object)designationId).map(DesignationModel::getDesignation).orElse("Unknown Designation");
    }

    private String getBrandName(Long brandId) {
        if (brandId == null) {
            return "N/A";
        }
        return this.brandRepository.findById((Object)brandId).map(BrandModel::getB_name).orElse("Unknown Brand");
    }

    private String getMktgHeadName(Long guideId) {
        if (guideId == null) {
            return "N/A";
        }
        User user = this.userService.findUserById(guideId);
        String mktghead = user.getName();
        return mktghead;
    }

    private boolean isFilterRequestEmpty(FilterRequest filterRequest) {
        return filterRequest == null || filterRequest.getBrandid() == null && filterRequest.getCity() == null && filterRequest.getDesignationid() == null && filterRequest.getDistrict() == null && filterRequest.getMktgid() == null && filterRequest.getProductDealing() == null && filterRequest.getState() == null && filterRequest.getType() == null && filterRequest.getStocktype() == null && filterRequest.getCategoryid() == null && filterRequest.getStatus() == null && filterRequest.getTimeRange() == null && filterRequest.getStocks() == null;
    }

    public String generateUserCSV(FilterRequest filterRequest, String token) {
        List users;
        UserResponse usertoken = this.authenticationService.getDetails(token);
        User userDetail = this.userService.findUserById(usertoken.getId());
        Role userRole = userDetail.getRole();
        if (Role.SUPERADMIN.equals((Object)userRole)) {
            users = this.isFilterRequestEmpty(filterRequest) ? this.userService.getAllUsers().stream().filter(user -> !Role.SUPERADMIN.equals((Object)user.getRole())).collect(Collectors.toList()) : this.userRepository.findUsersByFilters(filterRequest.getCity(), filterRequest.getDesignationid(), filterRequest.getBrandid(), Boolean.valueOf(true));
        } else {
            Long brandId = userDetail.getBrandid();
            users = this.isFilterRequestEmpty(filterRequest) ? this.userService.getAllUsers().stream().filter(user -> brandId.equals(user.getBrandid()) && Boolean.TRUE.equals(user.getStatus()) && !Role.SUPERADMIN.equals((Object)user.getRole())).collect(Collectors.toList()) : this.userRepository.findUsersByFilters(filterRequest.getCity(), filterRequest.getDesignationid(), brandId, Boolean.valueOf(true));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("S.No,Name,Usercode,Region,Email,Designation,Brand,Marketing Head,Mobile No,Date of Joining,Address,Area,City,State,Country,Role,Status\n");
        for (int i = 0; i < users.size(); ++i) {
            User user2 = (User)users.get(i);
            String mktgHeadName = this.getMktgHeadName(user2.getGuideid());
            String designationName = this.getDesignationName(user2.getDesignationid());
            String brandName = this.getBrandName(user2.getBrandid());
            sb.append(i + 1).append(",").append("\"").append(user2.getName()).append("\",").append("\"").append(user2.getUsercode()).append("\",").append("\"").append(user2.getRegion()).append("\",").append("\"").append(user2.getEmail()).append("\",").append("\"").append(designationName).append("\",").append("\"").append(brandName).append("\",").append("\"").append(mktgHeadName).append("\",").append("\"").append(user2.getMobile()).append("\",").append("\"").append(user2.getJoiningdate()).append("\",").append("\"").append(user2.getAddress()).append("\",").append("\"").append(user2.getArea()).append("\",").append("\"").append(user2.getCity()).append("\",").append("\"").append(user2.getState()).append("\",").append("\"").append(user2.getCountry()).append("\",").append("\"").append(user2.getRole()).append("\",").append("\"").append(user2.getStatus() != null ? (user2.getStatus().booleanValue() ? "Active" : "Inactive") : "Inactive").append("\"\n");
        }
        return sb.toString();
    }

    public String generateCustomerFilterCSV(FilterRequest filterRequest, String token) {
        List customerModels;
        UserResponse response = this.authenticationService.getDetails(token);
        User userdetail = this.userService.findUserById(response.getId());
        Long brandid = userdetail.getBrandid();
        if (response.getRole().equals((Object)Role.SUPERADMIN)) {
            customerModels = this.customerRepository.findAll();
        } else if (response.getRole().equals((Object)Role.USER)) {
            customerModels = this.customerRepository.findByMktgref(userdetail.getId());
        } else {
            List marketingUsers = this.userRepository.findByBrandid(brandid);
            List marketingIds = marketingUsers.stream().map(User::getId).collect(Collectors.toList());
            customerModels = this.customerRepository.findByMktgrefIn(marketingIds);
        }
        customerModels = this.applyCustomerFilters(customerModels, filterRequest);
        StringBuilder sb = new StringBuilder();
        sb.append("Sno,CompanyName,MKTG REF,Category,SubCategory,GST no,Company Mobile No,Email,Address,City,District,Pincode,State,Customer Group,Existing ID,Whatsapp,Instagram,Facebook,Active Status,");
        int maxMartialDetails = customerModels.stream().mapToInt(c -> c.getUserMartialModels() != null ? c.getUserMartialModels().size() : 0).max().orElse(0);
        for (int i = 1; i <= maxMartialDetails; ++i) {
            sb.append("Owner Name ").append(i).append(",").append("Martial Status ").append(i).append(",").append("Marriage Date ").append(i).append(",").append("DOB ").append(i).append(",").append("Designation ").append(i).append(",").append("Owner Email ").append(i).append(",").append("Owner Mobile ").append(i).append(",").append("WhatsApp No").append(i).append(",").append("Wishes ").append(i).append(",");
        }
        sb.setLength(sb.length() - 1);
        sb.append("\n");
        int sno = 1;
        for (CustomerModel customer : customerModels) {
            StringBuilder martialDetails = new StringBuilder();
            if (customer.getUserMartialModels() != null && !customer.getUserMartialModels().isEmpty()) {
                for (CustomerMartialModel martialDetail : customer.getUserMartialModels()) {
                    martialDetails.append("\"").append(martialDetail.getOwnername() != null ? martialDetail.getOwnername() : "N/A").append("\",").append("\"").append(martialDetail.getMartialstatus() != null ? martialDetail.getMartialstatus() : "N/A").append("\",").append("\"").append(martialDetail.getMarriagedate() != null ? martialDetail.getMarriagedate() : "N/A").append("\",").append("\"").append(martialDetail.getDob() != null ? martialDetail.getDob() : "N/A").append("\",").append("\"").append(martialDetail.getDesignation() != null ? martialDetail.getDesignation() : "N/A").append("\",").append("\"").append(martialDetail.getEmail() != null ? martialDetail.getEmail() : "N/A").append("\",").append("\"").append(martialDetail.getMobile() != null ? martialDetail.getMobile() : "N/A").append("\",").append("\"").append(martialDetail.getWhatsappno() != null ? martialDetail.getWhatsappno() : "N/A").append("\",").append("\"").append(martialDetail.getWishes() != null ? (martialDetail.getWishes().booleanValue() ? "Yes" : "No") : "No").append("\",");
                }
            }
            int remainingSlots = maxMartialDetails - (customer.getUserMartialModels() != null ? customer.getUserMartialModels().size() : 0);
            for (int i = 0; i < remainingSlots; ++i) {
                martialDetails.append("\"N/A\",\"N/A\",\"N/A\",\"N/A\",\"N/A\",\"N/A\",\"N/A\",\"N/A\",\"No\",");
            }
            sb.append(sno++).append(",").append("\"").append(customer.getC_name() != null ? customer.getC_name() : "N/A").append("\",").append("\"").append(customer.getMktgref() != null ? customer.getMktgref() : "N/A").append("\",").append("\"").append(customer.getCategory() != null ? customer.getCategory() : "N/A").append("\",").append("\"").append(customer.getSubcategory() != null ? customer.getSubcategory() : "N/A").append("\",").append("\"").append(customer.getGst() != null ? customer.getGst() : "N/A").append("\",").append("\"").append(customer.getMobile() != null ? customer.getMobile() : "N/A").append("\",").append("\"").append(customer.getEmail() != null ? customer.getEmail() : "N/A").append("\",").append("\"").append(customer.getAddress() != null ? customer.getAddress() : "N/A").append("\",").append("\"").append(customer.getCity() != null ? customer.getCity() : "N/A").append("\",").append("\"").append(customer.getDistrict() != null ? customer.getDistrict() : "N/A").append("\",").append("\"").append(customer.getPincode() != null ? customer.getPincode() : "N/A").append("\",").append("\"").append(customer.getState() != null ? customer.getState() : "N/A").append("\",").append("\"").append(customer.getCusgrop() != null ? customer.getCusgrop() : "N/A").append("\",").append("\"").append(customer.getExistingid() != null ? customer.getExistingid() : "N/A").append("\",").append("\"").append(customer.getWhatsappno() != null ? customer.getWhatsappno() : "N/A").append("\",").append("\"").append(customer.getInstaid() != null ? customer.getInstaid() : "N/A").append("\",").append("\"").append(customer.getFbid() != null ? customer.getFbid() : "N/A").append("\",").append("\"").append(customer.getActivestatus() != null ? (customer.getActivestatus().booleanValue() ? "Active" : "Inactive") : "Inactive").append("\",").append(martialDetails.toString()).append("\n");
        }
        return sb.toString();
    }

    public String generateVendorFilterCSV(FilterRequest filterRequest) {
        List vendors;
        if (this.isFilterRequestEmpty(filterRequest)) {
            vendors = this.vendorRepository.findAll();
        } else {
            vendors = this.vendorRepository.findAll();
            vendors = this.applyVendorFilters(vendors, filterRequest);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Sno,Vendor Name,Address,GST No,City,District,State,Pincode,Mobile,Product Dealing\n");
        vendors = this.applyVendorFilters(vendors, filterRequest);
        int sno = 1;
        for (VendorModel vendor : vendors) {
            String productDealing = vendor.getProductDealing() != null ? String.join((CharSequence)", ", vendor.getProductDealing()) : "N/A";
            sb.append(sno++).append(",").append("\"").append(vendor.getV_name() != null ? vendor.getV_name() : "N/A").append("\",").append("\"").append(vendor.getAddress() != null ? vendor.getAddress() : "N/A").append("\",").append("\"").append(vendor.getGstno() != null ? vendor.getGstno() : "N/A").append("\",").append("\"").append(vendor.getCity() != null ? vendor.getCity() : "N/A").append("\",").append("\"").append(vendor.getDistrict() != null ? vendor.getDistrict() : "N/A").append("\",").append("\"").append(vendor.getState() != null ? vendor.getState() : "N/A").append("\",").append("\"").append(vendor.getPincode() != null ? vendor.getPincode() : "N/A").append("\",").append("\"").append(vendor.getMobile() != null ? vendor.getMobile() : "N/A").append("\",").append("\"").append(productDealing).append("\"\n");
        }
        return sb.toString();
    }

    public String generateStockFilterCSV(FilterRequest filterRequest) {
        List stocks;
        if (this.isFilterRequestEmpty(filterRequest)) {
            stocks = this.stockRepository.findAll();
        } else {
            stocks = this.stockRepository.findAll();
            stocks = this.applyStockFilters(stocks, filterRequest);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Sno,Stock Type,Stock Name,Vendor Name,Total Units,Per Unit,Handling Charges,Final Price\n");
        int sno = 1;
        for (StockModel stock : stocks) {
            String vendorName = stock.getV_name() != null ? stock.getV_name() : "N/A";
            String stockType = stock.getStocktype() != null ? stock.getStocktype().toString() : "N/A";
            String totalUnits = stock.getTotalunits() != null ? stock.getTotalunits().toString() : "N/A";
            String perUnit = stock.getPerunit() != null ? stock.getPerunit().toString() : "N/A";
            String finalPrice = stock.getFinalprice() != null ? stock.getFinalprice().toString() : "N/A";
            sb.append(sno++).append(",").append("\"").append(stockType).append("\",").append("\"").append(vendorName).append("\",").append("\"").append(totalUnits).append("\",").append("\"").append(perUnit).append("\",").append("\"").append(finalPrice).append("\",").append("\"").append("\"\n");
        }
        return sb.toString();
    }

    public String generateUpdatedStockFilterCSV(FilterRequest filterRequest) {
        List stocks;
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime fromDate = switch (filterRequest.timeRange.toLowerCase()) {
            case "24hours" -> now.minusHours(24L);
            case "7days" -> now.minusDays(7L);
            case "1month" -> now.minusMonths(1L);
            default -> LocalDateTime.MIN;
        };
        if (this.isFilterRequestEmpty(filterRequest)) {
            stocks = this.stockUpdateRepository.findAll();
        } else {
            stocks = this.stockUpdateRepository.findAll();
            stocks = this.applyUpdatedStockFilters(stocks, filterRequest);
        }
        stocks = stocks.stream().filter(stock -> stock.getCreatedTimestamp() != null && stock.getCreatedTimestamp().isAfter(fromDate)).collect(Collectors.toList());
        StringBuilder sb = new StringBuilder();
        sb.append("Sno,Stock Type,Stock Name,Vendor Name,Updated Units,Per Unit Price,Handling Charges,Final Price,Final Units,Created Timestamp,Updated Quantity\n");
        int sno = 1;
        for (StockUpdateModel stock2 : stocks) {
            String stockType = stock2.getStocktype() != null ? stock2.getStocktype().toString() : "N/A";
            String stockName = stock2.getStockname() != null ? stock2.getStockname() : "N/A";
            String vendorName = stock2.getV_name() != null ? stock2.getV_name() : "N/A";
            String perUnitPrice = stock2.getPerunit_price() != null ? stock2.getPerunit_price().toString() : "N/A";
            String handlingCharges = stock2.getHandlingcharges() != null ? stock2.getHandlingcharges().toString() : "N/A";
            String finalPrice = stock2.getFinalprice() != null ? stock2.getFinalprice().toString() : "N/A";
            String finalUnits = stock2.getFinalunits() != null ? stock2.getFinalunits() : "N/A";
            String createdTimestamp = stock2.getCreatedTimestamp() != null ? stock2.getCreatedTimestamp().toString() : "N/A";
            String updatedQuantity = stock2.getUpdatedQuantity() != null ? stock2.getUpdatedQuantity() : "N/A";
            sb.append(sno++).append(",\"").append(stockType).append("\",\"").append(stockName).append("\",\"").append(vendorName).append("\",\"").append(perUnitPrice).append("\",\"").append(handlingCharges).append("\",\"").append(finalPrice).append("\",\"").append(finalUnits).append("\",\"").append(createdTimestamp).append("\",\"").append(updatedQuantity).append("\"\n");
        }
        return sb.toString();
    }

    public String generateUpdatedStockFilterCSVs(FilterRequest filterRequest) {
        List stocks;
        if (this.isFilterRequestEmpty(filterRequest)) {
            stocks = this.stockUpdateRepository.findAll();
        } else {
            stocks = this.stockUpdateRepository.findAll();
            stocks = this.applyUpdatedStockFilters(stocks, filterRequest);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Sno,Stock Type,Stock Name,Vendor Name,Updated Units,Per Unit Price,Handling Charges,Total Units,Updated Date,Updated Quantity\n");
        int sno = 1;
        for (StockUpdateModel stock : stocks) {
            String stockType = stock.getStocktype() != null ? stock.getStocktype().toString() : "N/A";
            String stockName = stock.getStockname() != null ? stock.getStockname() : "N/A";
            String vendorName = stock.getV_name() != null ? stock.getV_name() : "N/A";
            String perUnitPrice = stock.getPerunit_price() != null ? stock.getPerunit_price().toString() : "N/A";
            String handlingCharges = stock.getHandlingcharges() != null ? stock.getHandlingcharges().toString() : "N/A";
            String finalPrice = stock.getFinalprice() != null ? stock.getFinalprice().toString() : "N/A";
            String finalUnits = stock.getFinalunits() != null ? stock.getFinalunits() : "N/A";
            String createdTimestamp = stock.getCreatedTimestamp() != null ? stock.getCreatedTimestamp().toString() : "N/A";
            String updatedQuantity = stock.getUpdatedQuantity() != null ? stock.getUpdatedQuantity() : "N/A";
            sb.append(sno++).append(",\"").append(stockType).append("\",\"").append(stockName).append("\",\"").append(vendorName).append("\",\"").append(perUnitPrice).append("\",\"").append(handlingCharges).append("\",\"").append(finalUnits).append("\",\"").append(createdTimestamp).append("\",\"").append(updatedQuantity).append("\"\n");
        }
        return sb.toString();
    }

    public ByteArrayInputStream generateCSV(Map<String, List<CustomerMartialDTO>> filteredList) throws IOException {
        List<CustomerMartialDTO> anniversaries;
        StringBuilder csvBuilder = new StringBuilder();
        csvBuilder.append("Type,Owner Name,Marital Status,Marriage Date,DOB,Designation,Email,Mobile\n");
        List<CustomerMartialDTO> birthdays = filteredList.get("birthdays");
        if (birthdays != null) {
            for (CustomerMartialDTO birthday : birthdays) {
                csvBuilder.append("Birthday,").append(birthday.getOwnername()).append(",").append(birthday.getMartialstatus()).append(",").append(birthday.getMarriagedate()).append(",").append(birthday.getDob()).append(",").append(birthday.getDesignation()).append(",").append(birthday.getEmail()).append(",").append(birthday.getMobile()).append("\n");
            }
        }
        if ((anniversaries = filteredList.get("anniversaries")) != null) {
            for (CustomerMartialDTO anniversary : anniversaries) {
                csvBuilder.append("Anniversary,").append(anniversary.getOwnername()).append(",").append(anniversary.getMartialstatus()).append(",").append(anniversary.getMarriagedate()).append(",").append(anniversary.getDob()).append(",").append(anniversary.getDesignation()).append(",").append(anniversary.getEmail()).append(",").append(anniversary.getMobile()).append("\n");
            }
        }
        return new ByteArrayInputStream(csvBuilder.toString().getBytes());
    }

    private CustomerMartialDTO convertMartialModelToDTO(CustomerMartialModel martialModel) {
        CustomerMartialDTO martialDTO = new CustomerMartialDTO();
        martialDTO.setOwnername(martialModel.getOwnername());
        martialDTO.setMartialstatus(martialModel.getMartialstatus());
        martialDTO.setMarriagedate(martialModel.getMarriagedate());
        martialDTO.setDob(martialModel.getDob());
        martialDTO.setDesignation(martialModel.getDesignation());
        martialDTO.setEmail(martialModel.getEmail());
        martialDTO.setWishes(martialModel.getWishes());
        martialDTO.setId(martialModel.getId());
        martialDTO.setMobile(martialModel.getMobile());
        martialDTO.setWhatsappno(martialModel.getWhatsappno());
        return martialDTO;
    }

    private List<User> applyUserFilters(List<User> users, FilterRequest filterRequest) {
        return users.stream().filter(user -> {
            if (filterRequest.getBrandid() != null && !filterRequest.getBrandid().equals(user.getBrandid())) {
                return false;
            }
            if (filterRequest.getDesignationid() != null && !filterRequest.getDesignationid().equals(user.getDesignationid())) {
                return false;
            }
            return filterRequest.getCity() == null || filterRequest.getCity().equals(user.getCity());
        }).collect(Collectors.toList());
    }

    private List<CustomerModel> applyCustomerFilters(List<CustomerModel> customers, FilterRequest filterRequest) {
        return customers.stream().filter(customer -> {
            if (filterRequest.getCity() != null && !filterRequest.getCity().trim().isEmpty() && !filterRequest.getCity().trim().equalsIgnoreCase(customer.getCity())) {
                return false;
            }
            if (filterRequest.getDistrict() != null && !filterRequest.getDistrict().isEmpty() && !filterRequest.getDistrict().equalsIgnoreCase(customer.getDistrict())) {
                return false;
            }
            return filterRequest.getMktgid() == null || filterRequest.getMktgid() == customer.getMktgref();
        }).collect(Collectors.toList());
    }

    private List<VendorModel> applyVendorFilters(List<VendorModel> vendors, FilterRequest filterRequest) {
        return vendors.stream().filter(vendor -> {
            if (filterRequest.getCity() != null && !filterRequest.getCity().isEmpty() && !filterRequest.getCity().equalsIgnoreCase(vendor.getCity())) {
                return false;
            }
            if (filterRequest.getDistrict() != null && !filterRequest.getDistrict().isEmpty() && !filterRequest.getDistrict().equalsIgnoreCase(vendor.getDistrict())) {
                return false;
            }
            if (!(filterRequest.getProductDealing() == null || filterRequest.getProductDealing().isEmpty() || vendor.getProductDealing() != null && vendor.getProductDealing().contains(filterRequest.getProductDealing()))) {
                return false;
            }
            return filterRequest.getState() == null || filterRequest.getState().isEmpty() || filterRequest.getState().equalsIgnoreCase(vendor.getState());
        }).collect(Collectors.toList());
    }

    private List<TicketModel> applyTicketFilters(List<TicketModel> tickets, FilterRequest filterRequest) {
        return tickets.stream().filter(ticket -> {
            if (filterRequest.getType() != null && !filterRequest.getType().equals((Object)ticket.getType())) {
                return false;
            }
            return filterRequest.getStatus() == null || filterRequest.getStatus().equals((Object)ticket.getStatus());
        }).collect(Collectors.toList());
    }

    private List<StockModel> applyStockFilters(List<StockModel> stocks, FilterRequest filterRequest) {
        return stocks.stream().filter(ticket -> filterRequest.getStocktype() == null || filterRequest.getStocktype().equals((Object)ticket.getStocktype())).collect(Collectors.toList());
    }

    private List<StockUpdateModel> applyUpdatedStockFilters(List<StockUpdateModel> stocks, FilterRequest filterRequest) {
        return stocks.stream().filter(ticket -> {
            if (filterRequest.getStocktype() != null && !filterRequest.getStocktype().equals((Object)ticket.getStocktype())) {
                return false;
            }
            return filterRequest.getCategoryid() == null || filterRequest.getCategoryid() == ticket.getCategoryid();
        }).collect(Collectors.toList());
    }

    public ResponseEntity<byte[]> downloadReportforMktgandUser(FilterRequest filterRequest) throws IOException {
        LocalDateTime startDateTime = filterRequest.fromdate != null ? filterRequest.fromdate.atStartOfDay().truncatedTo(ChronoUnit.SECONDS) : null;
        LocalDateTime endDateTime = filterRequest.todate != null ? filterRequest.todate.atTime(LocalTime.MAX).truncatedTo(ChronoUnit.SECONDS) : null;
        Long categoryid = filterRequest.getCategoryid();
        List reportstock = "Customer".equals(filterRequest.getReportfor()) ? this.stockUpdateRepository.findByCustomeridWithNegativeQuantity(filterRequest.getCustomerid()) : this.stockUpdateRepository.findByMktgid(filterRequest.getMktgid());
        List filteredStock = reportstock.stream().filter(stock -> !(startDateTime != null && stock.getCreatedTimestamp().isBefore(startDateTime) || endDateTime != null && stock.getCreatedTimestamp().isAfter(endDateTime) || categoryid != null && !categoryid.equals(stock.getCategoryid()))).collect(Collectors.toList());
        List promotionalStock = filteredStock.stream().filter(stock -> TicketType.PROMOTIONAL_MATERIAL.equals((Object)stock.getStocktype())).collect(Collectors.toList());
        List otherStock = filteredStock.stream().filter(stock -> !TicketType.PROMOTIONAL_MATERIAL.equals((Object)stock.getStocktype())).collect(Collectors.toList());
        XSSFWorkbook workbook = new XSSFWorkbook();
        if (!promotionalStock.isEmpty()) {
            this.createSheetForStockType((Workbook)workbook, "Promotional Stock Report", promotionalStock, true, filterRequest);
        }
        if (!otherStock.isEmpty()) {
            this.createSheetForStockType((Workbook)workbook, "General Stock Report", otherStock, false, filterRequest);
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        workbook.write((OutputStream)outputStream);
        workbook.close();
        outputStream.close();
        Object fileName = "Stock_Report";
        if (filterRequest.fromdate != null) {
            fileName = (String)fileName + "_" + filterRequest.fromdate;
        }
        if (filterRequest.todate != null) {
            fileName = (String)fileName + "_" + filterRequest.todate;
        }
        fileName = (String)fileName + ".xlsx";
        HttpHeaders headersResponse = new HttpHeaders();
        headersResponse.add("Content-Disposition", "attachment; filename=" + (String)fileName);
        return new ResponseEntity((Object)outputStream.toByteArray(), (MultiValueMap)headersResponse, (HttpStatusCode)HttpStatus.OK);
    }

    private void createSheetForStockType(Workbook workbook, String sheetName, List<StockUpdateModel> stockList, boolean isPromotional, FilterRequest filterRequest) {
        String[] stringArray;
        Sheet sheet = workbook.createSheet(sheetName);
        int totalColumns = isPromotional ? 7 : 6;
        Row detailsRow = sheet.createRow(0);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, totalColumns - 1));
        Cell detailsCell = detailsRow.createCell(0);
        if ("Customer".equals(filterRequest.getReportfor())) {
            CustomerModel existingCustomer = this.customerRepository.findById((Object)filterRequest.getCustomerid()).orElse(null);
            if (existingCustomer != null) {
                detailsCell.setCellValue("Customer Name: " + existingCustomer.getC_name() + " | Email: " + existingCustomer.getEmail() + " | Mobile No: " + existingCustomer.getMobile());
            } else {
                detailsCell.setCellValue("Customer details not available");
            }
        } else {
            User user = this.userService.findUserById(filterRequest.getMktgid());
            if (user != null) {
                detailsCell.setCellValue("MKTG Name: " + user.getName() + " | Email: " + user.getEmail() + " | Mobile No: " + user.getMobile());
            } else {
                detailsCell.setCellValue("Marketing details not available");
            }
        }
        CellStyle boldStyle = workbook.createCellStyle();
        Font boldFont = workbook.createFont();
        boldFont.setBold(true);
        boldStyle.setFont(boldFont);
        detailsCell.setCellStyle(boldStyle);
        sheet.createRow(1);
        Row headerRow = sheet.createRow(2);
        if (isPromotional) {
            String[] stringArray2 = new String[8];
            stringArray2[0] = "S.No";
            stringArray2[1] = "StockType";
            stringArray2[2] = "Material Name";
            stringArray2[3] = "Description";
            stringArray2[4] = "Quantity";
            stringArray2[5] = "Per Unit Price";
            stringArray2[6] = "Total Price";
            stringArray = stringArray2;
            stringArray2[7] = "Date";
        } else {
            String[] stringArray3 = new String[7];
            stringArray3[0] = "S.No";
            stringArray3[1] = "StockType";
            stringArray3[2] = "Material Name";
            stringArray3[3] = "Description";
            stringArray3[4] = "Quantity";
            stringArray3[5] = "Total Price";
            stringArray = stringArray3;
            stringArray3[6] = "Date";
        }
        String[] headers = stringArray;
        for (int i = 0; i < headers.length; ++i) {
            Cell cell = headerRow.createCell(i);
            cell.setCellValue(headers[i]);
            cell.setCellStyle(boldStyle);
        }
        int rowIdx = 3;
        int serialNo = 1;
        double totalAmount = 0.0;
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        for (StockUpdateModel stock : stockList) {
            double totalPrice;
            Row row = sheet.createRow(rowIdx++);
            row.createCell(0).setCellValue((double)serialNo++);
            row.createCell(1).setCellValue(stock.getStocktype().toString());
            String categoryName = stock.getCategoryid() != null ? this.stockService.getcategoryname(stock.getCategoryid()) : "N/A";
            row.createCell(2).setCellValue(categoryName);
            row.createCell(3).setCellValue(stock.getDescription() != null ? stock.getDescription() : "N/A");
            row.createCell(4).setCellValue((double)stock.getNewqnty().intValue());
            if (isPromotional) {
                row.createCell(5).setCellValue(stock.getPerunit_price().doubleValue());
                totalPrice = (double)stock.getNewqnty().intValue() * stock.getPerunit_price();
                row.createCell(6).setCellValue(totalPrice);
                row.createCell(7).setCellValue(stock.getCreatedTimestamp().format(formatter));
                totalAmount += totalPrice;
                continue;
            }
            totalPrice = stock.getStockamount();
            row.createCell(5).setCellValue(totalPrice);
            row.createCell(6).setCellValue(stock.getCreatedTimestamp().format(formatter));
            totalAmount += totalPrice;
        }
        Row totalRow = sheet.createRow(rowIdx);
        Cell totalLabelCell = totalRow.createCell(isPromotional ? 5 : 4);
        totalLabelCell.setCellValue("Total Amount:");
        totalLabelCell.setCellStyle(boldStyle);
        Cell totalValueCell = totalRow.createCell(isPromotional ? 6 : 5);
        totalValueCell.setCellValue(totalAmount);
        totalValueCell.setCellStyle(boldStyle);
        for (int i = 0; i < headers.length; ++i) {
            sheet.autoSizeColumn(i);
        }
    }

    public InputStreamResource generateTicketFilterCSV(FilterRequest filterRequest, String token) throws IOException {
        List tickets;
        UserResponse user = this.authenticationService.getDetails(token);
        User userdetail = this.userService.findUserById(user.getId());
        if (this.isFilterRequestEmpty(filterRequest)) {
            tickets = this.ticketRepository.findAll();
        } else {
            tickets = this.ticketRepository.findAll();
            tickets = this.applyTicketFilters(tickets, filterRequest);
        }
        ByteArrayOutputStream outputStream = this.generateExcelReport(tickets);
        return new InputStreamResource((InputStream)new ByteArrayInputStream(outputStream.toByteArray()));
    }

    public ByteArrayOutputStream generateExcelReport(List<TicketModel> tickets) throws IOException {
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet("Ticket Report");
        int rowNum = 0;
        XSSFRow row = sheet.createRow(rowNum++);
        Cell cell = row.createCell(4);
        cell.setCellValue("Ticket Report");
        XSSFCellStyle headerStyle = workbook.createCellStyle();
        XSSFFont headerFont = workbook.createFont();
        headerFont.setBold(true);
        headerFont.setFontHeightInPoints((short)14);
        headerStyle.setFont((Font)headerFont);
        cell.setCellStyle((CellStyle)headerStyle);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 4, 8));
        row = sheet.createRow(rowNum++);
        String[] headers = new String[]{"Sno", "Ticket Code", "Customer Name", "MKTG Name", "Ticket Type", "Status", "Approved By", "Approval Status", "Description", "Dispatched At"};
        int colNum = 0;
        for (String header : headers) {
            cell = row.createCell(colNum++);
            cell.setCellValue(header);
            cell.setCellStyle((CellStyle)headerStyle);
        }
        int maxMaterials = tickets.stream().mapToInt(t -> this.materialRepository.getMaterialsByTicketId(t.getId()).size()).max().orElse(1);
        for (int i = 1; i <= maxMaterials; ++i) {
            cell = row.createCell(colNum++);
            cell.setCellValue("Material " + i + " Name");
            cell.setCellStyle((CellStyle)headerStyle);
            cell = row.createCell(colNum++);
            cell.setCellValue("Material " + i + " Qnty");
            cell.setCellStyle((CellStyle)headerStyle);
            cell = row.createCell(colNum++);
            cell.setCellValue("Material " + i + " Issued Qnty");
            cell.setCellStyle((CellStyle)headerStyle);
            cell = row.createCell(colNum++);
            cell.setCellValue("Material " + i + " Description");
            cell.setCellStyle((CellStyle)headerStyle);
        }
        int sno = 1;
        for (TicketModel ticket : tickets) {
            row = sheet.createRow(rowNum++);
            colNum = 0;
            row.createCell(colNum++).setCellValue((double)sno++);
            row.createCell(colNum++).setCellValue(ticket.getTicketcode() != null ? ticket.getTicketcode() : "N/A");
            row.createCell(colNum++).setCellValue(ticket.getCustomerid() != null ? this.getCustomerName(ticket.getCustomerid()) : "N/A");
            row.createCell(colNum++).setCellValue(ticket.getMktgid() != null ? this.getMktgHeadName(ticket.getMktgid()) : "N/A");
            row.createCell(colNum++).setCellValue(ticket.getType() != null ? ticket.getType().toString() : "N/A");
            row.createCell(colNum++).setCellValue(ticket.getStatus() != null ? ticket.getStatus().toString() : "N/A");
            row.createCell(colNum++).setCellValue(ticket.getApprovalid() != null ? this.getMktgHeadName(ticket.getApprovalid()) : "N/A");
            row.createCell(colNum++).setCellValue(ticket.getApprovalStatus() != null ? ticket.getApprovalStatus().toString() : "N/A");
            row.createCell(colNum++).setCellValue(ticket.getDescription() != null ? ticket.getDescription() : "N/A");
            row.createCell(colNum++).setCellValue(ticket.getDispatchedAt() != null ? ticket.getDispatchedAt().toString() : "N/A");
            List materials = this.materialRepository.getMaterialsByTicketId(ticket.getId());
            for (TicketMaterialModel material : materials) {
                row.createCell(colNum++).setCellValue(material.getCategory());
                row.createCell(colNum++).setCellValue(material.getQnty() != null ? (double)material.getQnty().intValue() : 0.0);
                row.createCell(colNum++).setCellValue(material.getIssuedqnty() != null ? (double)material.getIssuedqnty().intValue() : 0.0);
                row.createCell(colNum++).setCellValue(material.getQntydescription() != null ? material.getQntydescription() : "N/A");
            }
        }
        for (int i = 0; i < colNum; ++i) {
            sheet.autoSizeColumn(i);
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        workbook.write((OutputStream)outputStream);
        workbook.close();
        return outputStream;
    }

    private String getCustomerName(Long customerId) {
        Optional customerModel = this.customerService.getCustomerById(customerId);
        return customerModel.isPresent() ? ((CustomerModel)customerModel.get()).getC_name() : "N/A";
    }
}

