/*
 * Decompiled with CFR 0.152.
 */
package com.riot.Branding.service;

import com.riot.Branding.dao.FileDAO;
import com.riot.Branding.model.FileModel;
import com.riot.Branding.response.ResponseGalleryDTO;
import com.riot.Branding.service.FileService;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class EventGalleryService {
    @Autowired
    private FileService fileService;
    @Autowired
    private FileDAO fileDAO;

    public ResponseEntity<?> add(MultipartFile file) {
        try {
            System.out.println("");
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("ddMMyyyyHHmmssSSS");
            LocalDateTime current = LocalDateTime.now();
            String extension = file.getContentType();
            if (extension == null) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"Invalid file type.");
            }
            String exe = extension.substring(extension.lastIndexOf("/") + 1);
            String fileName = dtf.format(current) + "." + exe;
            String remotePath = "/TomorrowLand/EventGallery/" + fileName;
            this.fileService.upload(remotePath, file);
            String uploadedUrl = "https://storage.megashop.my" + remotePath;
            FileModel fileModel = new FileModel();
            fileModel.setFilelink(uploadedUrl);
            fileModel = this.fileDAO.save(fileModel);
            ResponseGalleryDTO response = new ResponseGalleryDTO(fileModel.getFileid(), uploadedUrl);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Error occurred: " + e.getMessage()));
        }
    }
}

