/*
 * Decompiled with CFR 0.152.
 */
package com.riot.Branding.service;

import com.riot.Branding.model.DesignationModel;
import com.riot.Branding.model.Role;
import com.riot.Branding.model.TicketModel;
import com.riot.Branding.model.TicketStatus;
import com.riot.Branding.model.User;
import com.riot.Branding.repository.CustomerRepository;
import com.riot.Branding.repository.DesignationRepository;
import com.riot.Branding.repository.TicketRepository;
import com.riot.Branding.repository.UserRepository;
import com.riot.Branding.response.UserResponse;
import com.riot.Branding.service.AuthenticationService;
import com.riot.Branding.service.UserServiceImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DashboardService {
    @Autowired
    private CustomerRepository customerRepository;
    @Autowired
    private TicketRepository ticketRepository;
    @Autowired
    private DesignationRepository designationRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private AuthenticationService authenticationService;
    @Autowired
    private UserServiceImpl userServiceImpl;

    public Long getTotalCustomers(String token) {
        return this.customerRepository.count();
    }

    public Long getPendingTickets(String token) {
        UserResponse user = this.authenticationService.getDetails(token);
        User userDetail = this.userServiceImpl.findUserById(user.getId());
        Role userRole = userDetail.getRole();
        if (userRole.equals((Object)Role.SUPERADMIN)) {
            return this.ticketRepository.countByStatus(TicketStatus.PENDING);
        }
        Long userBrandId = userDetail.getBrandid();
        return this.ticketRepository.countPendingTicketsByMktgBrandId(userBrandId, TicketStatus.PENDING);
    }

    public Long getTotalTickets(String token) {
        UserResponse user = this.authenticationService.getDetails(token);
        User userDetail = this.userServiceImpl.findUserById(user.getId());
        Role userRole = userDetail.getRole();
        if (userRole.equals((Object)Role.SUPERADMIN)) {
            return this.ticketRepository.count();
        }
        System.err.println("ENTER NOT ADMIN");
        Long userBrandId = userDetail.getBrandid();
        return this.ticketRepository.countTicketsByMktgBrandId(userBrandId);
    }

    public Map<String, Long> getUsersDesignation(String token) {
        HashMap<String, Long> designationCount = new HashMap<String, Long>();
        UserResponse user = this.authenticationService.getDetails(token);
        User userDetail = this.userServiceImpl.findUserById(user.getId());
        Role userRole = userDetail.getRole();
        List designations = this.designationRepository.findAll();
        for (DesignationModel designation : designations) {
            String des = designation.getDesignation();
            long count = this.userRepository.countByDesignationid(designation.getDesignationid());
            designationCount.put(des, count);
        }
        return designationCount;
    }

    public Map<TicketStatus, Long> getTotalTicketsByStatus(String token) {
        HashMap<TicketStatus, Long> ticketCountMap = new HashMap<TicketStatus, Long>();
        UserResponse user = this.authenticationService.getDetails(token);
        User userDetail = this.userServiceImpl.findUserById(user.getId());
        Role userRole = userDetail.getRole();
        if (userRole.equals((Object)Role.SUPERADMIN)) {
            for (TicketStatus status : TicketStatus.values()) {
                long count = this.ticketRepository.countByStatus(status);
                ticketCountMap.put(status, count);
            }
        } else {
            Long userBrandId = userDetail.getBrandid();
            for (TicketStatus status : TicketStatus.values()) {
                long count = this.ticketRepository.countPendingTicketsByMktgBrandId(userBrandId, status);
                ticketCountMap.put(status, count);
            }
        }
        return ticketCountMap;
    }

    public List<TicketModel> getLast10PendingTickets(String token) {
        UserResponse user = this.authenticationService.getDetails(token);
        User userDetail = this.userServiceImpl.findUserById(user.getId());
        Role userRole = userDetail.getRole();
        return this.ticketRepository.findTop10ByStatusOrderByCreatedAtDesc(TicketStatus.PENDING);
    }
}

