/*
 * Decompiled with CFR 0.152.
 */
package com.riot.Branding.service;

import com.riot.Branding.model.CustomerCategoryModel;
import com.riot.Branding.model.CustomerDesignationModel;
import com.riot.Branding.model.CustomerGroup;
import com.riot.Branding.model.CustomerMartialModel;
import com.riot.Branding.model.CustomerModel;
import com.riot.Branding.model.CustomerSubCategoryModel;
import com.riot.Branding.model.Role;
import com.riot.Branding.model.User;
import com.riot.Branding.repository.CustomerCategoryRepository;
import com.riot.Branding.repository.CustomerDesignationRepository;
import com.riot.Branding.repository.CustomerGroupRepository;
import com.riot.Branding.repository.CustomerMartialRepository;
import com.riot.Branding.repository.CustomerRepository;
import com.riot.Branding.repository.CustomerSubCategoryRepository;
import com.riot.Branding.repository.UserRepository;
import com.riot.Branding.request.CustomerDTO;
import com.riot.Branding.request.CustomerMartialDTO;
import com.riot.Branding.request.CustomerRequest;
import com.riot.Branding.response.UserResponse;
import com.riot.Branding.service.AuthenticationService;
import com.riot.Branding.service.CustomerService;
import com.riot.Branding.service.UserService;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class CustomerServiceImpl
implements CustomerService {
    @Autowired
    private CustomerRepository customerRepository;
    @Autowired
    private UserService userService;
    @Autowired
    private CustomerCategoryRepository categoryRepository;
    @Autowired
    private CustomerSubCategoryRepository customerSubCategoryRepository;
    @Autowired
    private CustomerDesignationRepository customerDesignationRepository;
    @Autowired
    private CustomerGroupRepository customerGroupRepository;
    @Autowired
    private CustomerMartialRepository customerMartialRepository;
    @Autowired
    private AuthenticationService authenticationService;
    @Autowired
    private UserRepository userRepository;
    private AtomicLong sequence = new AtomicLong(1L);

    public ResponseEntity<String> checkEmailExists(String email) {
        try {
            Optional userOptional = this.customerRepository.findByEmail(email);
            if (userOptional.isPresent()) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)"Email is already registered.");
            }
            return ResponseEntity.ok((Object)"Email is available for registration.");
        }
        catch (Exception e) {
            System.err.println("Error checking email existence: " + e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"An error occurred while checking the email.");
        }
    }

    public ResponseEntity<String> checkMobileExists(Long mobile) {
        try {
            Optional userByMobile = this.customerRepository.findByMobile(mobile);
            if (userByMobile.isPresent()) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)"Mobile number is already registered.");
            }
            return ResponseEntity.ok((Object)"Mobile number is available for registration.");
        }
        catch (Exception e) {
            System.err.println("Error checking mobile existence: " + e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"An error occurred while checking the mobile number.");
        }
    }

    public CustomerModel addCustomer(CustomerRequest request) {
        try {
            CustomerModel customer = this.mapToCustomerModel(request);
            CustomerModel savedCustomer = (CustomerModel)this.customerRepository.save((Object)customer);
            String customerCode = this.generateCustomerCode(savedCustomer);
            savedCustomer.setErpid(customerCode);
            CustomerModel updatedCustomer = (CustomerModel)this.customerRepository.save((Object)savedCustomer);
            if (request.getUserMartialModels() != null && !request.getUserMartialModels().isEmpty()) {
                for (CustomerMartialModel martialModel : request.getUserMartialModels()) {
                    martialModel.setCustomer(updatedCustomer);
                    this.customerMartialRepository.save((Object)martialModel);
                }
            }
            return updatedCustomer;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to add customer: " + e.getMessage());
        }
    }

    public ResponseEntity<String> checkEmailExistsmartial(String email) {
        try {
            Optional userOptional = this.customerMartialRepository.findByEmail(email);
            if (userOptional.isPresent()) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)"Email is already registered.");
            }
            return ResponseEntity.ok((Object)"Email is available for registration.");
        }
        catch (Exception e) {
            System.err.println("Error checking email existence: " + e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"An error occurred while checking the email.");
        }
    }

    public ResponseEntity<String> checkMobileExistsmartialDetails(Long mobile) {
        try {
            Optional userByMobile = this.customerMartialRepository.findByMobile(mobile);
            if (userByMobile.isPresent()) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)"Mobile number is already registered.");
            }
            return ResponseEntity.ok((Object)"Mobile number is available for registration.");
        }
        catch (Exception e) {
            System.err.println("Error checking mobile existence: " + e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"An error occurred while checking the mobile number.");
        }
    }

    public Optional<CustomerModel> getCustomerById(Long id) {
        try {
            return this.customerRepository.findById((Object)id);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retrieve customer: " + e.getMessage());
        }
    }

    public List<CustomerDTO> getAllCustomers(String token) {
        try {
            List customers;
            UserResponse response = this.authenticationService.getDetails(token);
            User userDetail = this.userService.findUserById(response.getId());
            if (response.getRole().equals((Object)Role.SUPERADMIN)) {
                customers = this.customerRepository.findAll();
            } else if (response.getRole().equals((Object)Role.USER)) {
                customers = this.customerRepository.findByMktgref(userDetail.getId());
            } else {
                List marketingUsers = this.userRepository.findByBrandid(userDetail.getBrandid());
                List marketingIds = marketingUsers.stream().map(User::getId).collect(Collectors.toList());
                customers = this.customerRepository.findByMktgrefIn(marketingIds);
            }
            return customers.stream().map(arg_0 -> this.convertToDTO(arg_0)).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retrieve customers: " + e.getMessage(), e);
        }
    }

    private CustomerDTO convertToDTO(CustomerModel customerModel) {
        CustomerDTO dto = new CustomerDTO();
        dto.setId(customerModel.getId());
        dto.setC_name(customerModel.getC_name());
        dto.setCategory(customerModel.getCategory());
        dto.setCategoryname(this.categoryname(customerModel.getCategory()));
        dto.setSubcategory(customerModel.getSubcategory());
        dto.setSubcategoryname(this.subcategoryname(customerModel.getSubcategory()));
        dto.setAddress(customerModel.getAddress());
        dto.setCity(customerModel.getCity());
        dto.setErpid(customerModel.getErpid());
        dto.setDistrict(customerModel.getDistrict());
        dto.setState(customerModel.getState());
        dto.setGst(customerModel.getGst());
        dto.setPincode(customerModel.getPincode());
        dto.setRegion(customerModel.getRegion());
        dto.setMobile(customerModel.getMobile());
        dto.setWhatsappno(customerModel.getWhatsappno());
        dto.setInstaid(customerModel.getInstaid());
        dto.setFbid(customerModel.getFbid());
        dto.setEmail(customerModel.getEmail());
        dto.setCusgrop(customerModel.getCusgrop());
        dto.setExistingid(customerModel.getExistingid());
        dto.setMktgrefname(this.mktgname(customerModel.getMktgref()));
        dto.setMktgref(customerModel.getMktgref());
        dto.setActivestatus(customerModel.getActivestatus());
        dto.setUserMartialModels(customerModel.getUserMartialModels().stream().map(arg_0 -> this.convertMartialModelToDTO(arg_0)).collect(Collectors.toList()));
        return dto;
    }

    private CustomerMartialDTO convertMartialModelToDTO(CustomerMartialModel martialModel) {
        CustomerMartialDTO martialDTO = new CustomerMartialDTO();
        martialDTO.setOwnername(martialModel.getOwnername());
        martialDTO.setMartialstatus(martialModel.getMartialstatus());
        martialDTO.setMarriagedate(martialModel.getMarriagedate());
        martialDTO.setDob(martialModel.getDob());
        martialDTO.setDesignation(martialModel.getDesignation());
        martialDTO.setDesignationname(this.designationname(martialModel.getDesignation()));
        martialDTO.setEmail(martialModel.getEmail());
        martialDTO.setWishes(martialModel.getWishes());
        martialDTO.setId(martialModel.getId());
        martialDTO.setMobile(martialModel.getMobile());
        martialDTO.setWhatsappno(martialModel.getWhatsappno());
        return martialDTO;
    }

    public CustomerModel updateCustomer(Long id, CustomerRequest request) {
        try {
            Optional existingCustomerOpt = this.customerRepository.findById((Object)id);
            if (existingCustomerOpt.isPresent()) {
                CustomerModel existingCustomer = (CustomerModel)existingCustomerOpt.get();
                CustomerModel updatedCustomer = this.mapToCustomerModel(request);
                updatedCustomer.setId(existingCustomer.getId());
                if (request.getUserMartialModels() != null && !request.getUserMartialModels().isEmpty()) {
                    this.updateMartialModels(updatedCustomer, request.getUserMartialModels());
                }
                return (CustomerModel)this.customerRepository.save((Object)updatedCustomer);
            }
            throw new RuntimeException("Customer with ID " + id + " not found");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to update customer: " + e.getMessage());
        }
    }

    public CustomerModel updateCustomerStatus(Long id, CustomerRequest request) {
        try {
            Optional existingCustomerOpt = this.customerRepository.findById((Object)id);
            if (existingCustomerOpt.isPresent()) {
                CustomerModel existingCustomer = (CustomerModel)existingCustomerOpt.get();
                existingCustomer.setActivestatus(request.getActivestatus());
                return (CustomerModel)this.customerRepository.save((Object)existingCustomer);
            }
            throw new RuntimeException("Customer with ID " + id + " not found");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to update customer: " + e.getMessage());
        }
    }

    private void updateMartialModels(CustomerModel customer, List<CustomerMartialModel> newMartialModels) {
        if (customer.getUserMartialModels() == null) {
            customer.setUserMartialModels(new ArrayList());
        }
        customer.getUserMartialModels().clear();
        for (CustomerMartialModel martialModel : newMartialModels) {
            martialModel.setCustomer(customer);
            customer.getUserMartialModels().add(martialModel);
        }
    }

    public void deleteCustomer(Long id) {
        try {
            this.customerRepository.deleteById((Object)id);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to delete customer: " + e.getMessage());
        }
    }

    private CustomerModel mapToCustomerModel(CustomerRequest request) {
        CustomerModel.CustomerModelBuilder builder = CustomerModel.builder().c_name(request.getC_name()).category(request.getCategory()).subcategory(request.getSubcategory()).address(request.getAddress()).city(request.getCity()).district(request.getDistrict()).state(request.getState()).gst(request.getGst()).pincode(request.getPincode()).mobile(request.getMobile()).whatsappno(request.getWhatsappno()).instaid(request.getInstaid()).fbid(request.getFbid()).email(request.getEmail()).cusgrop(request.getCusgrop()).existingid(request.getExistingid()).mktgref(request.getMktgref()).region(request.getRegion()).activestatus(request.getActivestatus());
        return builder.build();
    }

    public List<CustomerCategoryModel> addCategory(CustomerCategoryModel designationModel) {
        try {
            if (designationModel.getCategory() == null || designationModel.getCategory().trim().isEmpty()) {
                throw new IllegalArgumentException("Designation is mandatory.");
            }
            Optional existingDesignation = this.categoryRepository.findByCategory(designationModel.getCategory());
            if (!existingDesignation.isEmpty()) {
                throw new RuntimeException("Already category Registered ");
            }
            this.categoryRepository.save((Object)designationModel);
            return this.categoryRepository.findAll();
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Validation error: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to add designation.", e);
        }
    }

    public Optional<CustomerCategoryModel> getCustomerCategoryById(Long id) {
        try {
            return this.categoryRepository.findById((Object)id);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retrieve customer: " + e.getMessage());
        }
    }

    public List<CustomerCategoryModel> getAllCategory() {
        try {
            return this.categoryRepository.findAll();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retrieve all designations.", e);
        }
    }

    public List<CustomerSubCategoryModel> addSubCategory(CustomerSubCategoryModel designationModel) {
        try {
            if (designationModel.getSubcategory() == null || designationModel.getSubcategory().trim().isEmpty()) {
                throw new IllegalArgumentException("Designation is mandatory.");
            }
            Optional existingDesignation = this.customerSubCategoryRepository.findBySubcategory(designationModel.getSubcategory());
            if (existingDesignation.isEmpty()) {
                this.customerSubCategoryRepository.save((Object)designationModel);
            }
            return this.customerSubCategoryRepository.findAll();
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Validation error: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to add designation.", e);
        }
    }

    public Optional<CustomerSubCategoryModel> getCustomerSubCategoryById(Long id) {
        try {
            return this.customerSubCategoryRepository.findById((Object)id);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retrieve customer: " + e.getMessage());
        }
    }

    public List<CustomerSubCategoryModel> getAllSubCategory() {
        try {
            return this.customerSubCategoryRepository.findAll();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retrieve all designations.", e);
        }
    }

    public List<CustomerDTO> findByMktgRef(Long mktgRef) {
        try {
            List customers = this.customerRepository.findByMktgref(mktgRef);
            if (customers.isEmpty()) {
                throw new RuntimeException("No customers found with the provided marketing reference.");
            }
            return customers.stream().map(arg_0 -> this.convertToDTO(arg_0)).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new RuntimeException("Error while retrieving customers: " + e.getMessage());
        }
    }

    public List<CustomerDTO> findbyregion(String region) {
        try {
            List customers = this.customerRepository.findByRegion(region);
            if (customers.isEmpty()) {
                throw new RuntimeException("No customers found with the provided marketing reference.");
            }
            return customers.stream().map(arg_0 -> this.convertToDTO(arg_0)).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new RuntimeException("Error while retrieving customers: " + e.getMessage());
        }
    }

    public List<CustomerMartialModel> getBirthdayCustomers(LocalDate today) {
        List allCustomers = this.customerMartialRepository.findAll();
        System.out.println("123.");
        return allCustomers.stream().filter(customer -> customer.getDob() != null && customer.getDob().getDayOfMonth() == today.getDayOfMonth() && customer.getDob().getMonth() == today.getMonth()).collect(Collectors.toList());
    }

    public List<CustomerMartialModel> getAnniversaryCustomers(LocalDate today) {
        List allCustomers = this.customerMartialRepository.findAll();
        System.out.println("123.");
        return allCustomers.stream().filter(customer -> customer.getMarriagedate() != null && customer.getMarriagedate().getDayOfMonth() == today.getDayOfMonth() && customer.getMarriagedate().getMonth() == today.getMonth()).collect(Collectors.toList());
    }

    public List<CustomerMartialModel> getUpcomingBirthdays() {
        LocalDate today = LocalDate.now();
        LocalDate endDate = today.plusDays(30L);
        int currentYear = today.getYear();
        List allCustomers = this.customerMartialRepository.findAll();
        List<CustomerMartialModel> upcomingBirthdays = allCustomers.stream().filter(customer -> customer.getDob() != null).map(customer -> {
            LocalDate birthdayThisYear = customer.getDob().withYear(currentYear);
            return new AbstractMap.SimpleEntry<CustomerMartialModel, LocalDate>((CustomerMartialModel)customer, birthdayThisYear);
        }).filter(entry -> !((LocalDate)entry.getValue()).isBefore(today) && !((LocalDate)entry.getValue()).isAfter(endDate)).map(Map.Entry::getKey).distinct().collect(Collectors.toList());
        System.out.println("Found " + upcomingBirthdays.size() + " customers with upcoming birthdays.");
        return upcomingBirthdays;
    }

    public List<CustomerDesignationModel> addDesignation(CustomerDesignationModel designationModel) {
        try {
            if (designationModel.getDesignation() == null || designationModel.getDesignation().trim().isEmpty()) {
                throw new IllegalArgumentException("Designation is mandatory.");
            }
            Optional existingDesignation = this.customerDesignationRepository.findByDesignation(designationModel.getDesignation());
            if (existingDesignation.isEmpty()) {
                this.customerDesignationRepository.save((Object)designationModel);
            }
            return this.customerDesignationRepository.findAll();
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Validation error: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to add designation.", e);
        }
    }

    public Optional<CustomerDesignationModel> getCustomerDesignationById(Long id) {
        try {
            return this.customerDesignationRepository.findById((Object)id);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retrieve customer: " + e.getMessage());
        }
    }

    public List<CustomerDesignationModel> getAllDesignation() {
        try {
            return this.customerDesignationRepository.findAll();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retrieve all designations.", e);
        }
    }

    public List<CustomerGroup> addCustomerGroup(CustomerGroup designationModel) {
        try {
            if (designationModel.getGroupname() == null || designationModel.getGroupname().trim().isEmpty()) {
                throw new IllegalArgumentException("DesigCustomerGroupnation is mandatory.");
            }
            Optional existingDesignation = this.customerGroupRepository.findByGroupname(designationModel.getGroupname());
            if (existingDesignation.isEmpty()) {
                this.customerGroupRepository.save((Object)designationModel);
            }
            return this.customerGroupRepository.findAll();
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Validation error: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to add designation.", e);
        }
    }

    public List<CustomerGroup> getAllCusgroup() {
        try {
            return this.customerGroupRepository.findAll();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retrieve all designations.", e);
        }
    }

    public List<CustomerMartialModel> getBirthdaysForCurrentMonth() {
        try {
            return this.customerMartialRepository.findCustomersWithBirthdaysThisMonth();
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public List<CustomerMartialModel> getAnniversariesForCurrentMonth() {
        try {
            return this.customerMartialRepository.findCustomersWithAnniversariesThisMonth();
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public Long getTodayBirthdayCount() {
        try {
            return this.customerMartialRepository.countTodayBirthdays();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public Long getTodayAnniversaryCount() {
        try {
            return this.customerMartialRepository.countTodayAnniversaries();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public Map<String, List<CustomerMartialDTO>> getFilteredList(String type, String range) {
        LocalDate endDate;
        LocalDate startDate;
        LocalDate today = LocalDate.now();
        if ("next".equalsIgnoreCase(range)) {
            startDate = today;
            endDate = today.plusMonths(6L);
        } else if ("past".equalsIgnoreCase(range)) {
            startDate = today.minusMonths(6L);
            endDate = today;
        } else {
            YearMonth currentMonth = YearMonth.from(today);
            startDate = currentMonth.atDay(1);
            endDate = currentMonth.atEndOfMonth();
        }
        List birthdays = Collections.emptyList();
        List anniversaries = Collections.emptyList();
        switch (type.toLowerCase()) {
            case "birthday": {
                birthdays = this.customerMartialRepository.findBirthdaysInRange(startDate, endDate);
                break;
            }
            case "anniversary": {
                anniversaries = this.customerMartialRepository.findAnniversariesInRange(startDate, endDate);
                break;
            }
            default: {
                birthdays = this.customerMartialRepository.findBirthdaysInRange(startDate, endDate);
                anniversaries = this.customerMartialRepository.findAnniversariesInRange(startDate, endDate);
            }
        }
        List birthdayDTOs = birthdays.stream().map(arg_0 -> this.convertMartialModelToDTO(arg_0)).collect(Collectors.toList());
        List anniversaryDTOs = anniversaries.stream().map(arg_0 -> this.convertMartialModelToDTO(arg_0)).collect(Collectors.toList());
        return Map.of("birthdays", birthdayDTOs, "anniversaries", anniversaryDTOs);
    }

    private String generateCustomerCode(CustomerModel customer) {
        String name = customer.getC_name();
        String firstThreeLetters = name != null ? (name.length() >= 3 ? name.substring(0, 3).toUpperCase() : name.toUpperCase()) : "";
        Long customerId = customer.getId();
        return firstThreeLetters + String.format("%04d", customerId);
    }

    public String categoryname(String iD) {
        if (iD == null || iD.trim().isEmpty()) {
            return "N/A";
        }
        Long id = Long.parseLong(iD);
        Optional categoryModel = this.getCustomerCategoryById(id);
        return categoryModel.map(CustomerCategoryModel::getCategory).orElse("N/A");
    }

    public String subcategoryname(String iD) {
        if (iD == null || iD.trim().isEmpty()) {
            return "N/A";
        }
        Long id = Long.parseLong(iD);
        Optional subcategoryModel = this.getCustomerSubCategoryById(id);
        return subcategoryModel.map(CustomerSubCategoryModel::getSubcategory).orElse("N/A");
    }

    public String designationname(String iD) {
        if (iD == null || iD.trim().isEmpty()) {
            return "N/A";
        }
        Long id = Long.parseLong(iD);
        Optional designation = this.getCustomerDesignationById(id);
        return designation.map(CustomerDesignationModel::getDesignation).orElse("N/A");
    }

    public String mktgname(Long iD) {
        if (iD == null) {
            return "N/A";
        }
        Optional<User> mktgname = Optional.ofNullable(this.userService.findUserById(iD));
        return mktgname.map(User::getName).orElse("N/A");
    }
}

