/*
 * Decompiled with CFR 0.152.
 */
package com.riot.Branding.service;

import com.riot.Branding.dao.CompanyDAO;
import com.riot.Branding.model.CompanyModel;
import com.riot.Branding.request.CompanyRequest;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class CompanyService {
    @Autowired
    CompanyDAO companyDAO;

    public ResponseEntity<?> addCompany(CompanyRequest request) {
        try {
            CompanyModel companyModel = new CompanyModel();
            companyModel.setCompanycode(request.getCompanycode());
            companyModel.setCompanyname(request.getCompanyname());
            companyModel.setAddress(request.getAddress());
            companyModel.setArea(request.getArea());
            companyModel.setCity(request.getCity());
            companyModel.setState(request.getState());
            companyModel.setPincode(request.getPincode());
            companyModel.setTelephoneno(request.getTelephoneno());
            companyModel.setMobile(request.getMobile());
            companyModel.setEmail(request.getEmail());
            companyModel.setPanno(request.getPanno());
            companyModel.setGstno(request.getGstno());
            this.companyDAO.addcompany(companyModel);
            return ResponseEntity.ok((Object)companyModel);
        }
        catch (DataIntegrityViolationException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)("Company data violates constraints: " + e.getMessage()));
        }
        catch (IllegalArgumentException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)("Invalid input: " + e.getMessage()));
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred: " + e.getMessage()));
        }
    }

    public ResponseEntity<?> updateCompany(CompanyRequest request) {
        try {
            if (request.getCompanyid() != null) {
                Optional companyOptional = this.companyDAO.findCompanyById(request.getCompanyid());
                if (companyOptional.isPresent()) {
                    CompanyModel existingcompany = (CompanyModel)companyOptional.get();
                    existingcompany.setCompanycode(request.getCompanycode());
                    existingcompany.setCompanyname(request.getCompanyname());
                    existingcompany.setAddress(request.getAddress());
                    existingcompany.setArea(request.getArea());
                    existingcompany.setCity(request.getCity());
                    existingcompany.setState(request.getState());
                    existingcompany.setPincode(request.getPincode());
                    existingcompany.setTelephoneno(request.getTelephoneno());
                    existingcompany.setMobile(request.getMobile());
                    existingcompany.setEmail(request.getEmail());
                    existingcompany.setPanno(request.getPanno());
                    existingcompany.setGstno(request.getGstno());
                    this.companyDAO.updatecompany(existingcompany);
                    return ResponseEntity.ok((Object)existingcompany);
                }
                return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)("Company with ID " + request.getCompanyid() + " not found."));
            }
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"Company ID is required for update.");
        }
        catch (DataIntegrityViolationException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)("Company data violates constraints: " + e.getMessage()));
        }
        catch (IllegalArgumentException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)("Invalid input: " + e.getMessage()));
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred: " + e.getMessage()));
        }
    }

    public ResponseEntity<?> findCompanyById(Long id) {
        if (id != null) {
            Optional companyOpt = this.companyDAO.findCompanyById(id);
            if (companyOpt.isPresent()) {
                CompanyModel companyModel = (CompanyModel)companyOpt.get();
                return ResponseEntity.ok((Object)companyModel);
            }
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)("Company with ID " + id + " not found."));
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"Company ID is required.");
    }

    public List<CompanyModel> findAllCompany() {
        return this.companyDAO.findAllCompany();
    }

    public ResponseEntity<?> deleteCompanyById(Long id) {
        if (id != null) {
            Optional companyOpt = this.companyDAO.findCompanyById(id);
            if (companyOpt.isPresent()) {
                this.companyDAO.deletecompanyById(id);
                return ResponseEntity.ok((Object)("Company with ID " + id + " deleted successfully."));
            }
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)("Company with ID " + id + " not found."));
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"Company ID is required.");
    }
}

