/*
 * Decompiled with CFR 0.152.
 */
package com.riot.Branding.service;

import com.riot.Branding.dao.BrandDAO;
import com.riot.Branding.model.BrandModel;
import jakarta.validation.Valid;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class BrandService {
    @Autowired
    BrandDAO brandDAO;

    public BrandModel addBrand(@Valid BrandModel request) {
        try {
            BrandModel brandModel = new BrandModel();
            brandModel.setB_name(request.getB_name());
            brandModel.setImageURL(request.getImageURL());
            this.brandDAO.addbrand(brandModel);
            return brandModel;
        }
        catch (DataIntegrityViolationException e) {
            System.err.println("Brand data violates constraints: " + e.getMessage());
            throw new RuntimeException("Brand data violates constraints: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            System.err.println("Invalid input: " + e.getMessage());
            throw new RuntimeException("Invalid input: " + e.getMessage());
        }
        catch (Exception e) {
            System.err.println("An error occurred: " + e.getMessage());
            throw new RuntimeException("An error occurred: " + e.getMessage());
        }
    }

    public ResponseEntity<?> updateBrand(BrandModel request) {
        try {
            if (request.getId() == null) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"Brand ID is required for update.");
            }
            Optional brandOpt = this.brandDAO.findBrandById(request.getId());
            if (brandOpt.isPresent()) {
                BrandModel existingBrand = (BrandModel)brandOpt.get();
                existingBrand.setB_name(request.getB_name());
                existingBrand.setImageURL(request.getImageURL());
                this.brandDAO.updateBrand(existingBrand);
                return ResponseEntity.ok((Object)existingBrand);
            }
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)("Brand with ID " + request.getId() + " not found."));
        }
        catch (DataIntegrityViolationException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)("Brand data violates constraints: " + e.getMessage()));
        }
        catch (IllegalArgumentException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)("Invalid input: " + e.getMessage()));
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred: " + e.getMessage()));
        }
    }

    public ResponseEntity<?> findBrandById(Long id) {
        if (id != null) {
            Optional brandopt = this.brandDAO.findBrandById(id);
            if (brandopt.isPresent()) {
                BrandModel brandModel = (BrandModel)brandopt.get();
                return ResponseEntity.ok((Object)brandModel);
            }
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)("Brand with ID " + id + " not found."));
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"Brand ID is required.");
    }

    public List<BrandModel> findAllBrand() {
        return this.brandDAO.findAllBrand();
    }

    public ResponseEntity<?> deleteBrandById(Long id) {
        if (id != null) {
            Optional companyOpt = this.brandDAO.findBrandById(id);
            if (companyOpt.isPresent()) {
                this.brandDAO.deleteBrandById(id);
                return ResponseEntity.ok((Object)("Brand with ID " + id + " deleted successfully."));
            }
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)("Brand with ID " + id + " not found."));
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"Brand ID is required.");
    }
}

