/*
 * Decompiled with CFR 0.152.
 */
package com.riot.Branding.service;

import com.riot.Branding.model.CustomerMartialModel;
import com.riot.Branding.request.ResponseBannerDTO;
import com.riot.Branding.service.BirthdayWishesService;
import com.riot.Branding.service.CustomerService;
import com.riot.Branding.service.ImageService;
import com.riot.Branding.service.UserPhotoService;
import com.riot.Branding.utils.JavaSendapi;
import com.riot.Branding.utils.WhatsAppSender;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class BirthdayWishesService {
    private static final Logger logger = LoggerFactory.getLogger(BirthdayWishesService.class);
    @Autowired
    private UserPhotoService userPhotoService;
    @Autowired
    private CustomerService customerService;
    @Autowired
    private JavaSendapi emailSender;
    @Autowired
    private ImageService imageService;

    @Scheduled(cron="0 0 8 * * ?")
    public void sendScheduledBirthdayWishes() throws IOException {
        LocalDate today = LocalDate.now();
        try {
            List todayBirthdayCustomers = this.customerService.getBirthdayCustomers(today);
            logger.info("Found {} customers with birthdays today.", (Object)todayBirthdayCustomers.size());
            for (CustomerMartialModel customer : todayBirthdayCustomers) {
                try {
                    LocalDate customerBirthday = customer.getDob();
                    if (customerBirthday != null && customerBirthday.getMonthValue() == today.getMonthValue() && customerBirthday.getDayOfMonth() == today.getDayOfMonth()) {
                        DateTimeFormatter formatter;
                        LocalDate date;
                        String formattedDate;
                        String name = customer.getOwnername().toUpperCase();
                        byte[] imageBytes = this.imageService.createPersonalizedImage(name, formattedDate = (date = LocalDate.now()).format(formatter = DateTimeFormatter.ofPattern("dd-MMM-yyyy")).toUpperCase());
                        MultipartFile multipartFile = this.convertByteArrayToMultipart(imageBytes, "birthday_wish.jpg");
                        ResponseEntity responseEntity = this.userPhotoService.addProfile(multipartFile);
                        if (responseEntity.getStatusCode() == HttpStatus.OK && responseEntity.getBody() instanceof ResponseBannerDTO) {
                            ResponseBannerDTO response = (ResponseBannerDTO)responseEntity.getBody();
                            String imageUrl = response.getUploadedUrl();
                            if (!Boolean.TRUE.equals(customer.getWishes())) continue;
                            String emailBody = this.buildEmailBody(imageUrl);
                            String whatsappNumber = "91" + customer.getWhatsappno();
                            WhatsAppSender.sendImageMessage((String)whatsappNumber, (String)imageUrl);
                            this.emailSender.sendMailBody(customer.getEmail(), emailBody, "Happy Birthday " + name + " !");
                            logger.info("Birthday wish successfully sent to: {}", (Object)customer.getEmail());
                            continue;
                        }
                        logger.error("Failed to get image URL for customer {}: {}", (Object)customer.getEmail(), responseEntity.getBody());
                        continue;
                    }
                    logger.warn("Customer {} has no valid DOB or does not match today's date.", (Object)customer.getEmail());
                }
                catch (Exception e) {
                    logger.error("Unexpected error for customer {}: {}", (Object)customer.getEmail(), (Object)e.getMessage());
                }
            }
        }
        catch (Exception e) {
            logger.error("Failed to process birthday wishes: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    @Scheduled(cron="0 0 8 * * ?")
    public void sendScheduledAnniversaryWishes() throws IOException {
        LocalDate today = LocalDate.now();
        try {
            List todayAnniversaryCustomers = this.customerService.getAnniversaryCustomers(today);
            logger.info("Found {} customers with Anniversary today.", (Object)todayAnniversaryCustomers.size());
            for (CustomerMartialModel customer : todayAnniversaryCustomers) {
                try {
                    LocalDate customerAnniversary = customer.getMarriagedate();
                    if (customerAnniversary != null && customerAnniversary.getMonthValue() == today.getMonthValue() && customerAnniversary.getDayOfMonth() == today.getDayOfMonth()) {
                        DateTimeFormatter formatter;
                        LocalDate date;
                        String formattedDate;
                        String name = customer.getOwnername();
                        byte[] imageBytes = this.imageService.createPersonalizedImage(name, formattedDate = (date = LocalDate.now()).format(formatter = DateTimeFormatter.ofPattern("dd-MMM-yyyy")).toUpperCase());
                        MultipartFile multipartFile = this.convertByteArrayToMultipart(imageBytes, "Anniversary_wish.jpg");
                        ResponseEntity responseEntity = this.userPhotoService.addProfile(multipartFile);
                        if (responseEntity.getStatusCode() == HttpStatus.OK && responseEntity.getBody() instanceof ResponseBannerDTO) {
                            ResponseBannerDTO response = (ResponseBannerDTO)responseEntity.getBody();
                            String imageUrl = response.getUploadedUrl();
                            if (!Boolean.TRUE.equals(customer.getWishes())) continue;
                            String emailBody = this.buildEmailBody(imageUrl);
                            String whatsappNumber = "91" + customer.getWhatsappno();
                            WhatsAppSender.sendImageMessage((String)whatsappNumber, (String)imageUrl);
                            this.emailSender.sendMailBody(customer.getEmail(), emailBody, "Happy Anniversary " + customer.getOwnername() + "!");
                            logger.info("Anniversary wish successfully sent to: {}", (Object)customer.getEmail());
                            continue;
                        }
                        logger.error("Failed to get image URL for customer {}: {}", (Object)customer.getEmail(), responseEntity.getBody());
                        continue;
                    }
                    logger.warn("Customer {} has no valid Anniversary Date or does not match today's date.", (Object)customer.getEmail());
                }
                catch (Exception e) {
                    logger.error("Unexpected error for customer {}: {}", (Object)customer.getEmail(), (Object)e.getMessage());
                }
            }
        }
        catch (Exception e) {
            logger.error("Failed to process Anniversary wishes: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public MultipartFile convertByteArrayToMultipart(byte[] imageBytes, String fileName) {
        return new ByteArrayMultipartFile(this, imageBytes, fileName, "image/jpeg");
    }

    private String buildEmailBody(String imageUrl) {
        return "<html><body style='background-color:#f6f6f6; font-family:Arial, sans-serif; margin:0; padding:20px;'><div style='max-width:600px; margin:auto; background:white; padding:20px; border-radius:8px; box-shadow:0 0 10px rgba(0,0,0,0.1);'><h2 style='color:#333;'>Happy Celebration!</h2><p style='color:#555;'><b>We hope you enjoy this special day with our best wishes!<b></p><img src='" + imageUrl + "' alt='Celebration Image' style='width:100%; max-width:600px; border-radius:4px;'/><p style='color:#777;'>Best Regards,<br/>Your Team</p></div></body></html>";
    }
}

