/*
 * Decompiled with CFR 0.152.
 */
package com.riot.Branding.service;

import com.riot.Branding.model.CustomerMartialModel;
import com.riot.Branding.model.CustomerModel;
import com.riot.Branding.model.Role;
import com.riot.Branding.model.User;
import com.riot.Branding.model.Wishes;
import com.riot.Branding.repository.CustomerMartialRepository;
import com.riot.Branding.repository.CustomerRepository;
import com.riot.Branding.repository.UserRepository;
import com.riot.Branding.repository.WishesRepository;
import com.riot.Branding.service.UserService;
import com.riot.Branding.utils.JavaSendapi;
import com.riot.Branding.utils.WhatsAppSender;
import jakarta.mail.MessagingException;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class AutomaticSendService {
    private static final Logger logger = LoggerFactory.getLogger(AutomaticSendService.class);
    @Autowired
    private WishesRepository wishesRepository;
    @Autowired
    private CustomerMartialRepository customerMartialRepository;
    @Autowired
    private CustomerRepository customerRepository;
    @Autowired
    private UserService userService;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private JavaSendapi emailSender;

    public Wishes createWish(Wishes wishesModel) {
        return (Wishes)this.wishesRepository.save((Object)wishesModel);
    }

    public void sendPromotionalWishes() throws MessagingException {
        logger.info("Scheduled task 'sendPromotionalWishes' triggered at: {}", (Object)LocalDateTime.now());
        LocalDate today = LocalDate.now();
        LocalTime currentTime = LocalTime.now().truncatedTo(ChronoUnit.MINUTES);
        List wishes = this.wishesRepository.findBySended(false);
        logger.info("Number of wishes fetched: {}", (Object)wishes.size());
        for (Wishes wish : wishes) {
            boolean isSendTime;
            LocalDate sendDate = wish.getSetdate().minusDays(wish.getDaysbefore().intValue());
            logger.info("Wish '{}' - Set date: {}, Days before: {}, Calculated send date: {}", new Object[]{wish.getTitle(), wish.getSetdate(), wish.getDaysbefore(), sendDate});
            boolean isSendDate = today.equals(sendDate);
            boolean bl = isSendTime = currentTime.equals(wish.getSettime()) || currentTime.isAfter(wish.getSettime());
            if (isSendDate && isSendTime) {
                logger.info("It's time to send promotional wish '{}' at time: {}", (Object)wish.getTitle(), (Object)currentTime);
                for (Long gmid : wish.getGmid()) {
                    List rmUsers = this.userRepository.findByGuideidAndRoleAndStatus(gmid, Role.RM, true);
                    ArrayList marketingUsersFromRMs = new ArrayList();
                    for (User rmUser : rmUsers) {
                        List mktgUsers = this.userRepository.findByGuideidAndRoleAndStatus(rmUser.getId(), Role.USER, true);
                        marketingUsersFromRMs.addAll(mktgUsers);
                    }
                    List directMarketingUsers = this.userRepository.findByGuideidAndRoleAndStatus(gmid, Role.USER, true);
                    ArrayList allMarketingUsers = new ArrayList();
                    allMarketingUsers.addAll(marketingUsersFromRMs);
                    allMarketingUsers.addAll(directMarketingUsers);
                    ArrayList mktgCustomers = new ArrayList();
                    for (User mktgUser : allMarketingUsers) {
                        List customers = this.customerRepository.findByMktgrefAndActivestatus(mktgUser.getId(), true);
                        if (customers.isEmpty()) continue;
                        mktgCustomers.addAll(customers);
                    }
                    if (mktgCustomers.isEmpty()) {
                        throw new RuntimeException("No customers found for the Marketing users under GM ID: " + gmid);
                    }
                    logger.info("Found {} customers under GM ID: {}", (Object)mktgCustomers.size(), (Object)gmid);
                    logger.info("Number of customers fetched for sending promotional wishes: {}", (Object)mktgCustomers.size());
                    for (CustomerModel customer : mktgCustomers) {
                        List customerMartialList = customer.getUserMartialModels();
                        String emailBody = this.buildEmailBody(wish);
                        String imagebody = this.buildEmailBodyImage(wish);
                        if (wish.getPoster() != null && !wish.getPoster().isEmpty()) {
                            try {
                                int bytesRead;
                                String posterUrl = wish.getPoster();
                                URI uri = new URI(posterUrl);
                                URL fileUrl = uri.toURL();
                                String fileType = posterUrl.substring(posterUrl.lastIndexOf(".") + 1);
                                HttpClient client = HttpClient.newHttpClient();
                                HttpRequest request = HttpRequest.newBuilder(fileUrl.toURI()).build();
                                HttpResponse<InputStream> response = client.send(request, HttpResponse.BodyHandlers.ofInputStream());
                                InputStream inputStream = response.body();
                                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                                byte[] buffer = new byte[1024];
                                while ((bytesRead = inputStream.read(buffer)) != -1) {
                                    byteArrayOutputStream.write(buffer, 0, bytesRead);
                                }
                                byte[] fileData = byteArrayOutputStream.toByteArray();
                                String fileformat = AutomaticSendService.getFileTypeFromUrl((String)posterUrl);
                                if (fileformat.equals("Image")) {
                                    WhatsAppSender.sendImageMessageWithAttribute((String)("91" + customer.getWhatsappno().toString()), (String)wish.getPoster(), (String)customer.getC_name(), (String)wish.getDescription());
                                } else if (fileformat.equals("Video")) {
                                    WhatsAppSender.sendVideoMessageWithAttribute((String)("91" + customer.getWhatsappno().toString()), (String)wish.getPoster(), (String)customer.getC_name(), (String)wish.getDescription());
                                } else {
                                    WhatsAppSender.sendDocumentMessageWithAttribute((String)("91" + customer.getWhatsappno().toString()), (String)wish.getPoster(), (String)customer.getC_name(), (String)wish.getDescription());
                                }
                                logger.info("Promotional wish '{}' sent with attachment to: {}", (Object)wish.getTitle(), (Object)customer.getEmail());
                            }
                            catch (Exception e) {
                                logger.error("Failed to fetch or attach file for promotional wish '{}' to: {}", new Object[]{wish.getTitle(), customer.getEmail(), e});
                            }
                        } else {
                            logger.info("Promotional wish '{}' sent without attachment to: {}", (Object)wish.getTitle(), (Object)customer.getEmail());
                        }
                        if (customerMartialList != null && !customerMartialList.isEmpty()) {
                            for (CustomerMartialModel martialModel : customerMartialList) {
                                if (!martialModel.getWishes().booleanValue()) continue;
                                if (wish.getPoster() != null && !wish.getPoster().isEmpty()) {
                                    try {
                                        int bytesRead;
                                        String posterUrl = wish.getPoster();
                                        URI uri = new URI(posterUrl);
                                        URL fileUrl = uri.toURL();
                                        String fileType = posterUrl.substring(posterUrl.lastIndexOf(".") + 1);
                                        HttpClient client = HttpClient.newHttpClient();
                                        HttpRequest request = HttpRequest.newBuilder(fileUrl.toURI()).build();
                                        HttpResponse<InputStream> response = client.send(request, HttpResponse.BodyHandlers.ofInputStream());
                                        InputStream inputStream = response.body();
                                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                                        byte[] buffer = new byte[1024];
                                        while ((bytesRead = inputStream.read(buffer)) != -1) {
                                            byteArrayOutputStream.write(buffer, 0, bytesRead);
                                        }
                                        byte[] fileData = byteArrayOutputStream.toByteArray();
                                        String fileformat = AutomaticSendService.getFileTypeFromUrl((String)posterUrl);
                                        if (fileformat.equals("Image")) {
                                            WhatsAppSender.sendImageMessageWithAttribute((String)("91" + martialModel.getWhatsappno().toString()), (String)wish.getPoster(), (String)customer.getC_name(), (String)wish.getDescription());
                                        } else if (fileformat.equals("Video")) {
                                            WhatsAppSender.sendVideoMessageWithAttribute((String)("91" + martialModel.getWhatsappno().toString()), (String)wish.getPoster(), (String)martialModel.getOwnername(), (String)wish.getDescription());
                                        } else {
                                            WhatsAppSender.sendDocumentMessageWithAttribute((String)("91" + martialModel.getWhatsappno().toString()), (String)wish.getPoster(), (String)martialModel.getOwnername(), (String)wish.getDescription());
                                        }
                                        logger.info("Promotional wish '{}' sent with attachment to: {}", (Object)wish.getTitle(), (Object)martialModel.getEmail());
                                    }
                                    catch (Exception e) {
                                        logger.error("Failed to fetch or attach file for promotional wish '{}' to: {}", new Object[]{wish.getTitle(), martialModel.getEmail(), e});
                                    }
                                    continue;
                                }
                                this.emailSender.sendMailWithAttachment(martialModel.getEmail(), emailBody, wish.getTitle(), null, null);
                                logger.info("Promotional wish '{}' sent without attachment to: {}", (Object)wish.getTitle(), (Object)martialModel.getEmail());
                            }
                            continue;
                        }
                        logger.info("No valid CustomerMartialModel found for customer '{}'", (Object)customer.getEmail());
                    }
                    wish.setSended(Boolean.valueOf(true));
                    this.wishesRepository.save((Object)wish);
                    logger.info("Wish '{}' marked as sent.", (Object)wish.getTitle());
                }
                continue;
            }
            logger.info("Not time to send wish '{}' yet. Today: {}, Send date: {}, Current time: {}", new Object[]{wish.getTitle(), today, sendDate, currentTime});
        }
        logger.info("Completed processing all promotional wishes for today.");
    }

    public static String getFileTypeFromUrl(String fileUrl) {
        try {
            String lowerCaseUrl;
            URL url = new URL(fileUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("HEAD");
            connection.connect();
            String contentType = connection.getContentType();
            connection.disconnect();
            if (contentType != null) {
                if (contentType.startsWith("image/")) {
                    return "Image";
                }
                if (contentType.startsWith("video/")) {
                    return "Video";
                }
                if (contentType.equals("application/pdf")) {
                    return "PDF";
                }
                if (contentType.equals("application/vnd.ms-powerpoint") || contentType.equals("application/vnd.openxmlformats-officedocument.presentationml.presentation")) {
                    return "PowerPoint (PPT)";
                }
                if (contentType.equals("application/vnd.ms-excel") || contentType.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet")) {
                    return "Excel";
                }
                if (contentType.equals("application/msword") || contentType.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.document")) {
                    return "Word Document";
                }
                if (contentType.startsWith("application/")) {
                    return "File";
                }
            }
            if ((lowerCaseUrl = fileUrl.toLowerCase()).endsWith(".mp4")) {
                return "Video";
            }
            if (lowerCaseUrl.endsWith(".jpg") || lowerCaseUrl.endsWith(".jpeg") || lowerCaseUrl.endsWith(".png") || lowerCaseUrl.endsWith(".gif")) {
                return "Image";
            }
            if (lowerCaseUrl.endsWith(".pdf")) {
                return "PDF";
            }
            if (lowerCaseUrl.endsWith(".ppt") || lowerCaseUrl.endsWith(".pptx")) {
                return "PowerPoint (PPT)";
            }
            if (lowerCaseUrl.endsWith(".xls") || lowerCaseUrl.endsWith(".xlsx")) {
                return "Excel";
            }
            if (lowerCaseUrl.endsWith(".doc") || lowerCaseUrl.endsWith(".docx")) {
                return "Word Document";
            }
            return "Unknown";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Error";
        }
    }

    private String buildEmailBody(Wishes wish) {
        return "<div><b>" + wish.getTitle() + "</b></div><div>" + wish.getDescription() + "</div>";
    }

    private String buildEmailBodyImage(Wishes wish) {
        return "<html><body><h2>" + wish.getTitle() + "</h2><b><p>We hope you enjoy this special day with our best wishes!</p></b><img src='" + wish.getPoster() + "' alt='Sakthi Groups' style='width:100%; max-width:600px;'/></body></html>";
    }
}

