/*
 * Decompiled with CFR 0.152.
 */
package com.riot.Branding.service;

import com.riot.Branding.dao.UserDao;
import com.riot.Branding.model.Role;
import com.riot.Branding.model.User;
import com.riot.Branding.repository.UserRepository;
import com.riot.Branding.request.PasswordChangeRequest;
import com.riot.Branding.request.RegisterRequest;
import com.riot.Branding.response.AuthenticationResponse;
import com.riot.Branding.response.UserResponse;
import com.riot.Branding.security.JwtService;
import com.riot.Branding.service.AuthenticationService;
import java.util.Base64;
import java.util.Optional;
import lombok.Generated;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class AuthenticationServiceImpl
implements AuthenticationService {
    public final UserRepository userRepository;
    private final PasswordEncoder encoder;
    private final JwtService jwtService;
    private final AuthenticationManager authenticationManager;
    @Autowired
    UserDao userDao;

    public AuthenticationResponse register(RegisterRequest request) {
        User user = User.builder().name(request.getName()).email(request.getEmail()).password(this.encoder.encode((CharSequence)request.getPassword())).role(Role.ADMIN).status(Boolean.valueOf(true)).mobile(request.getMobile()).build();
        this.userRepository.save((Object)user);
        String jwtToken = this.jwtService.generateToken((UserDetails)user);
        return AuthenticationResponse.builder().token(jwtToken).build();
    }

    public AuthenticationResponse authenticate(RegisterRequest request) {
        User user;
        String identifier = request.getEmail();
        if (this.isEmail(identifier) || "admin".equalsIgnoreCase(identifier)) {
            user = (User)this.userRepository.findByEmail(identifier).orElseThrow(() -> new UsernameNotFoundException("User not found with email: " + identifier));
        } else {
            user = this.userRepository.findByUsercode(identifier).orElse(null);
            if (user == null) {
                throw new UsernameNotFoundException("User not found with empcode: " + identifier);
            }
            if (user.getEmail() == null || user.getEmail().isEmpty()) {
                throw new IllegalStateException("User found with empcode but no email available for authentication.");
            }
        }
        if (user.getStatus() == null || !user.getStatus().booleanValue()) {
            throw new IllegalStateException("User account is inactive.");
        }
        this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)user.getEmail(), (Object)request.getPassword()));
        String jwtToken = this.jwtService.generateToken((UserDetails)user);
        return AuthenticationResponse.builder().token(jwtToken).build();
    }

    private boolean isEmail(String identifier) {
        String emailRegex = "^[A-Za-z0-9+_.-]+@(.+)$";
        return identifier.matches(emailRegex);
    }

    public UserResponse getDetails(String aS) {
        String bearer = aS.substring(aS.indexOf(".") + 1);
        String bearer1 = (String)bearer.subSequence(0, bearer.indexOf("."));
        Base64.Decoder decoder = Base64.getUrlDecoder();
        String token = new String(decoder.decode(bearer1));
        JSONObject jsonObject = new JSONObject(token);
        String userName = jsonObject.getString("sub");
        Optional creator = this.userDao.findByEmail(userName);
        UserResponse res = new UserResponse();
        res.setEmail(((User)creator.get()).getEmail());
        res.setName(((User)creator.get()).getName());
        res.setId(((User)creator.get()).getId());
        res.setMobile(((User)creator.get()).getMobile());
        res.setRole(((User)creator.get()).getRole());
        return res;
    }

    public void pass() {
        System.out.println("password" + this.encoder.encode((CharSequence)"2020"));
    }

    public PasswordChangeRequest getPassDetails(String aS) {
        String bearer = aS.substring(aS.indexOf(".") + 1);
        String bearer1 = (String)bearer.subSequence(0, bearer.indexOf("."));
        Base64.Decoder decoder = Base64.getUrlDecoder();
        String token = new String(decoder.decode(bearer1));
        JSONObject jsonObject = new JSONObject(token);
        String userName = jsonObject.getString("sub");
        Optional creator = this.userDao.findByEmail(userName);
        if (creator.isPresent()) {
            PasswordChangeRequest res = new PasswordChangeRequest();
            User user = (User)creator.get();
            res.setOldpassword(user.getPassword());
            return res;
        }
        throw new RuntimeException("Error: User not found.");
    }

    @Generated
    public AuthenticationServiceImpl(UserRepository userRepository, PasswordEncoder encoder, JwtService jwtService, AuthenticationManager authenticationManager) {
        this.userRepository = userRepository;
        this.encoder = encoder;
        this.jwtService = jwtService;
        this.authenticationManager = authenticationManager;
    }
}

