/*
 * Decompiled with CFR 0.152.
 */
package com.riot.Branding.service;

import com.riot.Branding.dao.FileDAO;
import com.riot.Branding.model.FileModel;
import com.riot.Branding.model.TicketModel;
import com.riot.Branding.repository.TicketRepository;
import com.riot.Branding.service.FileService;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AddDeleteGalleryService {
    @Autowired
    private FileService fileService;
    @Autowired
    private FileDAO fileDAO;
    @Autowired
    private TicketRepository ticketRepository;

    public ResponseEntity<?> addImageToGallery(Long eventId, MultipartFile file) {
        try {
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("ddMMyyyyHHmmssSSS");
            LocalDateTime current = LocalDateTime.now();
            String extension = file.getContentType();
            if (extension == null) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"Invalid file type.");
            }
            String exe = extension.substring(extension.lastIndexOf("/") + 1);
            String fileName = dtf.format(current) + "." + exe;
            String remotePath = "/TomorrowLand/EventGallery/" + fileName;
            this.fileService.upload(remotePath, file);
            String uploadedUrl = "https://storage.megashop.my" + remotePath;
            TicketModel eventModel = (TicketModel)this.ticketRepository.findById((Object)eventId).orElseThrow(() -> new RuntimeException("Event not found"));
            FileModel fileModel = new FileModel();
            fileModel.setFilelink(uploadedUrl);
            fileModel.setTicketid(eventModel.getId().toString());
            this.fileDAO.save(fileModel);
            return ResponseEntity.ok((Object)"Image added to gallery successfully.");
        }
        catch (RuntimeException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)("Event not found: " + e.getMessage()));
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Error occurred: " + e.getMessage()));
        }
    }

    public ResponseEntity<?> deleteGalleryImage(Long fileId) {
        try {
            FileModel fileModel = (FileModel)this.fileDAO.findById(fileId).orElseThrow(() -> new RuntimeException("File not found"));
            String fileUrl = fileModel.getFilelink();
            String ftpPath = fileUrl.replace("https://storage.megashop.my", "");
            this.fileService.delete(ftpPath);
            this.fileDAO.deleteById(fileId);
            return ResponseEntity.ok((Object)"Image deleted from gallery successfully.");
        }
        catch (RuntimeException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)("File not found: " + e.getMessage()));
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Error occurred: " + e.getMessage()));
        }
    }
}

