/*
 * Decompiled with CFR 0.152.
 */
package com.riot.Branding.repository;

import com.riot.Branding.model.Role;
import com.riot.Branding.model.User;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface UserRepository
extends JpaRepository<User, Long> {
    public Optional<User> findByEmail(String var1);

    public Boolean existsByEmail(String var1);

    public Optional<User> findFirstByBrandidAndDesignationid(Long var1, Long var2);

    public List<User> findByBrandidAndDesignationid(Long var1, Long var2);

    public List<User> findByBrandid(Long var1);

    @Query(value="SELECT u FROM User u WHERE u.brandid = :brandId AND u.designationid = (SELECT d.designationid FROM DesignationModel d WHERE d.designation = :designationName)")
    public List<User> findByBrandAndDesignationName(@Param(value="brandId") Long var1, @Param(value="designationName") String var2);

    public Optional<User> findByMobile(Long var1);

    public long countByDesignationid(Long var1);

    public List<User> findByCity(String var1);

    public List<User> findByDesignationid(Long var1);

    @Query(value="SELECT u FROM User u WHERE (:city IS NULL OR u.city = :city) AND (:designationid IS NULL OR u.designationid = :designationid) AND (:brandid IS NULL OR u.brandid = :brandid) AND (:status IS NULL OR u.status = :status)")
    public List<User> findUsersByFilters(@Param(value="city") String var1, @Param(value="designationid") Long var2, @Param(value="brandid") Long var3, @Param(value="status") Boolean var4);

    public Optional<User> findByIdAndRole(Long var1, Role var2);

    public List<User> findByGuideid(Long var1);

    public List<User> findByBrandidAndRole(Long var1, Role var2);

    public Optional<User> findTopByOrderByUsercodeDesc();

    public Optional<User> findByUsercode(String var1);

    public Optional<User> findByEmailAndUsercode(String var1, String var2);

    public Optional<User> findByEmailAndPassword(String var1, String var2);

    public List<User> findByGuideidAndRole(Long var1, Role var2);

    public List<User> findByBrandidAndDesignationidAndStatus(Long var1, Long var2, boolean var3);

    public Optional<User> findFirstByBrandidAndDesignationidAndStatus(Long var1, Long var2, boolean var3);

    public List<User> findByGuideidAndRoleAndStatus(Long var1, Role var2, boolean var3);

    public List<User> findByDesignationidAndStatus(Long var1, boolean var2);

    public List<User> findByBrandidAndRoleAndStatus(Long var1, Role var2, boolean var3);

    @Query(value="SELECT DISTINCT u.region FROM User u WHERE u.region IS NOT NULL")
    public List<String> findAllDistinctRegions();

    public List<User> findByRegion(String var1);

    public Optional<User> findTopByUsercodeStartingWithOrderByUsercodeDesc(String var1);

    public Optional<User> findByMobileAndStatus(Long var1, boolean var2);
}

