/*
 * Decompiled with CFR 0.152.
 */
package com.riot.Branding.repository;

import com.riot.Branding.model.ApprovalStatus;
import com.riot.Branding.model.TicketModel;
import com.riot.Branding.model.TicketStatus;
import com.riot.Branding.model.TicketType;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface TicketRepository
extends JpaRepository<TicketModel, Long> {
    public List<TicketModel> findByApprovalStatus(ApprovalStatus var1);

    public List<TicketModel> findByStatus(TicketStatus var1);

    public Long countByStatus(TicketStatus var1);

    public List<TicketModel> findTop10ByStatusOrderByCreatedAtDesc(TicketStatus var1);

    public Optional<TicketModel> findTopByOrderByTicketcodeDesc();

    @Query(value="SELECT t FROM TicketModel t WHERE (:type IS NULL OR t.type = :type) AND (:status IS NULL OR t.status = :status) ")
    public List<TicketModel> findTicketsByFilters(@Param(value="type") TicketType var1, @Param(value="status") TicketStatus var2);

    public List<TicketModel> findByMktgid(Long var1);

    @Query(value="SELECT t FROM TicketModel t WHERE (:mktgid IS NULL OR t.mktgid = :mktgid) AND (:type IS NULL OR t.type = :type) AND (:status IS NULL OR t.status = :status) ")
    public List<TicketModel> findTicketsByMktgAndFilters(@Param(value="mktgid") Long var1, @Param(value="type") TicketType var2, @Param(value="status") TicketStatus var3);

    @Query(value="SELECT COUNT(t) FROM TicketModel t JOIN User u ON t.mktgid = u.id WHERE t.status = :status AND u.brandid = :brandId")
    public Long countPendingTicketsByMktgBrandId(@Param(value="brandId") Long var1, @Param(value="status") TicketStatus var2);

    @Query(value="SELECT COUNT(t) FROM TicketModel t JOIN User u ON t.mktgid = u.id WHERE  u.brandid = :brandId")
    public Long countTicketsByMktgBrandId(@Param(value="brandId") Long var1);

    public List<TicketModel> findByMktgidAndStatus(Long var1, TicketStatus var2);
}

