/*
 * Decompiled with CFR 0.152.
 */
package com.riot.Branding.repository;

import com.riot.Branding.model.StockUpdateModel;
import com.riot.Branding.model.TicketType;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface StockUpdateRepository
extends JpaRepository<StockUpdateModel, Long> {
    public Optional<List<StockUpdateModel>> findByStockid(Long var1);

    public List<StockUpdateModel> findByStocktype(TicketType var1);

    @Query(value="SELECT s FROM StockUpdateModel s WHERE (:stocktype IS NULL OR s.stocktype = :stocktype) AND (:categoryid IS NULL OR s.categoryid = :categoryid)")
    public List<StockUpdateModel> findStockssByFilters(@Param(value="stocktype") String var1, @Param(value="categoryid") Long var2);

    public List<StockUpdateModel> findByCategoryid(Long var1);

    public Optional<StockUpdateModel> findTopByCategoryidAndSidLessThanOrderBySidDesc(Long var1, Long var2);

    public List<StockUpdateModel> findByCustomerid(Long var1);

    public List<StockUpdateModel> findByMktgid(Long var1);

    public List<StockUpdateModel> findByCategoryidAndBrandid(Long var1, Long var2);

    @Query(value="SELECT s FROM StockUpdateModel s WHERE s.customerid = :customerid AND s.updatedQuantity LIKE '%-%'")
    public List<StockUpdateModel> findByCustomeridWithNegativeQuantity(@Param(value="customerid") Long var1);

    @Query(value="SELECT s FROM StockUpdateModel s WHERE s.customerid = :customerid AND s.updatedQuantity LIKE '%+%'")
    public List<StockUpdateModel> findByCustomeridWithPositiveQuantity(@Param(value="customerid") Long var1);
}

