/*
 * Decompiled with CFR 0.152.
 */
package com.riot.Branding.repository;

import com.riot.Branding.model.CustomerMartialModel;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface CustomerMartialRepository
extends JpaRepository<CustomerMartialModel, Long> {
    public List<CustomerMartialModel> findByDobBetween(LocalDate var1, LocalDate var2);

    public List<CustomerMartialModel> findByWishes(boolean var1);

    public Optional<CustomerMartialModel> findByMobile(Long var1);

    public Optional<CustomerMartialModel> findByEmail(String var1);

    @Query(value="SELECT c FROM CustomerMartialModel c WHERE MONTH(c.dob) = MONTH(CURRENT_DATE)")
    public List<CustomerMartialModel> findCustomersWithBirthdaysThisMonth();

    @Query(value="SELECT c FROM CustomerMartialModel c WHERE MONTH(c.marriagedate) = MONTH(CURRENT_DATE)")
    public List<CustomerMartialModel> findCustomersWithAnniversariesThisMonth();

    @Query(value="SELECT COUNT(c) FROM CustomerMartialModel c WHERE MONTH(c.dob) = MONTH(CURRENT_DATE) AND DAY(c.dob) = DAY(CURRENT_DATE)")
    public Long countTodayBirthdays();

    @Query(value="SELECT COUNT(c) FROM CustomerMartialModel c WHERE MONTH(c.marriagedate) = MONTH(CURRENT_DATE) AND DAY(c.marriagedate) = DAY(CURRENT_DATE)")
    public Long countTodayAnniversaries();

    @Query(value="SELECT c FROM CustomerMartialModel c WHERE FUNCTION('MONTH', c.dob) = :month")
    public List<CustomerMartialModel> findBirthdaysByMonth(@Param(value="month") int var1);

    @Query(value="SELECT c FROM CustomerMartialModel c WHERE FUNCTION('MONTH', c.marriagedate) = :month")
    public List<CustomerMartialModel> findAnniversariesByMonth(@Param(value="month") int var1);

    @Query(value="SELECT * FROM customer_details c WHERE (MONTH(c.dob) > MONTH(:startDate) OR (MONTH(c.dob) = MONTH(:startDate) AND DAY(c.dob) >= DAY(:startDate))) AND (MONTH(c.dob) < MONTH(:endDate) OR (MONTH(c.dob) = MONTH(:endDate) AND DAY(c.dob) <= DAY(:endDate)))", nativeQuery=true)
    public List<CustomerMartialModel> findBirthdaysInRange(@Param(value="startDate") LocalDate var1, @Param(value="endDate") LocalDate var2);

    @Query(value="SELECT * FROM customer_details c WHERE (MONTH(c.marriagedate) > MONTH(:startDate) OR (MONTH(c.marriagedate) = MONTH(:startDate) AND DAY(c.marriagedate) >= DAY(:startDate))) AND (MONTH(c.marriagedate) < MONTH(:endDate) OR (MONTH(c.marriagedate) = MONTH(:endDate) AND DAY(c.marriagedate) <= DAY(:endDate)))", nativeQuery=true)
    public List<CustomerMartialModel> findAnniversariesInRange(@Param(value="startDate") LocalDate var1, @Param(value="endDate") LocalDate var2);
}

