/*
 * Decompiled with CFR 0.152.
 */
package com.riot.Branding.controller;

import com.riot.Branding.model.Wishes;
import com.riot.Branding.request.WishesRequest;
import com.riot.Branding.service.AutomaticSendService;
import com.riot.Branding.service.BirthdayWishesService;
import com.riot.Branding.service.ImageService;
import com.riot.Branding.service.WishesService;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/wishes"})
public class WishesController {
    @Autowired
    private WishesService wishesService;
    @Autowired
    BirthdayWishesService birthdayWishesService;
    @Autowired
    ImageService imageService;
    @Autowired
    AutomaticSendService automaticSendService;

    @PutMapping(value={"/bday"})
    public void createWish() throws IOException, MessagingException {
        this.birthdayWishesService.sendScheduledAnniversaryWishes();
    }

    @PostMapping(value={"/auto"})
    public void sendPromotionalWishes() throws IOException, MessagingException {
        this.automaticSendService.sendPromotionalWishes();
    }

    @PostMapping(value={"/createwish"})
    public ResponseEntity<Wishes> createWish(@RequestBody WishesRequest wishesRequest) {
        Wishes createdWish = this.wishesService.createWish(wishesRequest);
        return new ResponseEntity((Object)createdWish, (HttpStatusCode)HttpStatus.CREATED);
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<Wishes>> getAllWishes(@RequestParam(value="w") String wishes) {
        List wishesList = this.wishesService.getAllWishes(wishes);
        return new ResponseEntity((Object)wishesList, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getbyid"})
    public ResponseEntity<Wishes> getWishById(@RequestParam Long id) {
        Wishes wish = this.wishesService.getWishById(id);
        return new ResponseEntity((Object)wish, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<Wishes> updateWish(@RequestBody WishesRequest wishesRequest) {
        Long id = wishesRequest.getId();
        Wishes updatedWish = this.wishesService.updateWish(id, wishesRequest);
        return new ResponseEntity((Object)updatedWish, (HttpStatusCode)HttpStatus.OK);
    }

    @DeleteMapping(value={"/"})
    public ResponseEntity<Void> deleteWish(@RequestParam Long id) {
        this.wishesService.deleteWish(id);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    @GetMapping(value={"/today-wishes"})
    public ResponseEntity<Map<String, Integer>> getTodaySentWishes() {
        HashMap<String, Integer> response = new HashMap<String, Integer>();
        try {
            int birthdayWishesCount = this.wishesService.getTodayBirthdayWishesCount();
            int anniversaryWishesCount = this.wishesService.getTodayAnniversaryWishesCount();
            response.put("birthdayWishesSent", birthdayWishesCount);
            response.put("anniversaryWishesSent", anniversaryWishesCount);
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Collections.singletonMap("Unable to fetch wishes data: " + e.getMessage(), null));
        }
    }
}

