/*
 * Decompiled with CFR 0.152.
 */
package com.riot.Branding.controller;

import com.riot.Branding.controller.VendorController;
import com.riot.Branding.model.VendorModel;
import com.riot.Branding.request.VendorRequest;
import com.riot.Branding.service.VendorServiceImpl;
import jakarta.validation.Valid;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/vendors"})
@Validated
public class VendorController {
    @Autowired
    private VendorServiceImpl vendorService;

    @PostMapping(value={"/add"})
    public ResponseEntity<?> addVendor(@RequestBody @Valid VendorRequest vendorRequest) {
        try {
            VendorModel vendor = this.vendorService.addVendor(vendorRequest);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)vendor);
        }
        catch (Exception e) {
            return this.buildErrorResponse("Failed to add vendor", e);
        }
    }

    @GetMapping(value={"/check-email"})
    public ResponseEntity<String> checkEmail(@RequestParam String email) {
        return this.vendorService.checkEmailExists(email);
    }

    @GetMapping(value={"/check-mobile"})
    public ResponseEntity<String> checkMobile(@RequestParam Long mobile) {
        return this.vendorService.checkMobileExists(mobile);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<?> updateVendor(@RequestBody VendorRequest vendorRequest) {
        try {
            System.err.println("enter 1234");
            Long id = vendorRequest.getId();
            VendorModel updatedVendor = this.vendorService.updateVendor(id, vendorRequest);
            return ResponseEntity.ok((Object)updatedVendor);
        }
        catch (Exception e) {
            return this.buildErrorResponse("Failed to update vendor", e);
        }
    }

    @DeleteMapping(value={"/delete"})
    public ResponseEntity<?> deleteVendor(@RequestParam(value="id") Long id) {
        try {
            this.vendorService.deleteVendor(id);
            return ResponseEntity.ok((Object)"Vendor deleted successfully");
        }
        catch (Exception e) {
            return this.buildErrorResponse("Failed to delete vendor", e);
        }
    }

    @GetMapping(value={"/find"})
    public ResponseEntity<?> getVendorById(@RequestParam(value="id") Long id) {
        try {
            VendorModel vendor = this.vendorService.getVendorById(id);
            return ResponseEntity.ok((Object)vendor);
        }
        catch (Exception e) {
            return this.buildErrorResponse("Vendor not found", e);
        }
    }

    @GetMapping(value={"/findall"})
    public ResponseEntity<?> getAllVendors() {
        try {
            List vendors = this.vendorService.getAllVendors();
            return ResponseEntity.ok((Object)vendors);
        }
        catch (Exception e) {
            return this.buildErrorResponse("Failed to retrieve vendors", e);
        }
    }

    @GetMapping(value={"/vendordealing"})
    public ResponseEntity<List<VendorModel>> vendordealing(@RequestParam String dealing) {
        try {
            List vendors = this.vendorService.findVendorsByProductDealing(dealing);
            return ResponseEntity.ok((Object)vendors);
        }
        catch (RuntimeException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body(null);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/vendorcategory"})
    public ResponseEntity<List<VendorModel>> vendorcategory(@RequestParam Long id) {
        try {
            List vendors = this.vendorService.findVendorsByCategory(id);
            return ResponseEntity.ok((Object)vendors);
        }
        catch (RuntimeException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body(null);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    private ResponseEntity<ErrorResponse> buildErrorResponse(String message, Exception e) {
        String details = e.getMessage() != null ? e.getMessage() : "An unexpected error occurred.";
        ErrorResponse errorResponse = new ErrorResponse(message, details);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)errorResponse);
    }
}

