/*
 * Decompiled with CFR 0.152.
 */
package com.riot.Branding.controller;

import com.riot.Branding.controller.UserController;
import com.riot.Branding.model.DesignationModel;
import com.riot.Branding.model.User;
import com.riot.Branding.model.UserRegionModel;
import com.riot.Branding.repository.DesignationRepository;
import com.riot.Branding.request.UserProfileRequest;
import com.riot.Branding.request.UserRequest;
import com.riot.Branding.response.AuthenticationResponse;
import com.riot.Branding.response.RMWithGM;
import com.riot.Branding.response.UserFieldResponse;
import com.riot.Branding.service.UserService;
import jakarta.validation.Valid;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/users"})
public class UserController {
    @Autowired
    private UserService userService;
    @Autowired
    DesignationRepository designationRepository;

    @GetMapping(value={"/check-email"})
    public ResponseEntity<String> checkEmail(@RequestParam String email) {
        return this.userService.checkEmailExists(email);
    }

    @GetMapping(value={"/check-mobile"})
    public ResponseEntity<String> checkMobile(@RequestParam Long mobile) {
        return this.userService.checkMobileExists(mobile);
    }

    @PostMapping(value={"/add"})
    public ResponseEntity<AuthenticationResponse> addUser(@RequestBody UserRequest userRequest) {
        return ResponseEntity.ok((Object)this.userService.addUser(userRequest));
    }

    @PostMapping(value={"/mailsend/{id}"})
    public ResponseEntity<String> mailSend(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.userService.mailsend(id));
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<User> updateUser(@RequestBody UserRequest userRequest) {
        Long id = userRequest.getId();
        return ResponseEntity.ok((Object)this.userService.updateUser(id, userRequest));
    }

    @PostMapping(value={"/updatestatus"})
    public ResponseEntity<User> updateUserStatus(@RequestBody UserRequest userRequest) {
        Long id = userRequest.getId();
        return ResponseEntity.ok((Object)this.userService.updateUserStatus(id, userRequest));
    }

    @GetMapping(value={"/getbyid/{id}"})
    public ResponseEntity<User> findUserById(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.userService.findUserById(id));
    }

    @GetMapping(value={"/admins"})
    public ResponseEntity<List<UserFieldResponse>> getAdmins(@RequestHeader(value="Authorization") String token) {
        try {
            List admins = this.userService.findAllAdmins(token);
            return ResponseEntity.ok((Object)admins);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Collections.emptyList());
        }
    }

    @PostMapping(value={"/adminupdate"})
    public ResponseEntity<?> updateAdminUser(@RequestBody UserRequest updateRequest) {
        try {
            User updatedUser = this.userService.updateUser(updateRequest);
            return ResponseEntity.ok((Object)updatedUser);
        }
        catch (IllegalArgumentException e) {
            return ResponseEntity.badRequest().body((Object)e.getMessage());
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to update user details: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/profile"})
    public ResponseEntity<UserProfileRequest> getUserProfile(@RequestHeader(value="Authorization") String token) {
        try {
            UserProfileRequest userProfile = this.userService.getProfileByuser(token);
            return ResponseEntity.ok((Object)userProfile);
        }
        catch (RuntimeException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body(null);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<UserFieldResponse>> findAllUsers(@RequestHeader(value="Authorization") String token) {
        return ResponseEntity.ok((Object)this.userService.findAllUsers(token));
    }

    @GetMapping(value={"/getalluser"})
    public ResponseEntity<List<User>> getAllUserswithoutvalue() {
        return ResponseEntity.ok((Object)this.userService.getAllUsers());
    }

    @GetMapping(value={"/getallmktg"})
    public ResponseEntity<List<User>> findAllUsersDesignation() {
        return ResponseEntity.ok((Object)this.userService.getAllByDesignation());
    }

    @DeleteMapping(value={"/deletebyid"})
    public ResponseEntity<Void> deleteUserById(@RequestParam(value="id") Long id) {
        this.userService.deleteUserById(id);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/getAllDesignation"})
    public ResponseEntity<?> getAllDesignation() {
        try {
            List designations = this.userService.getAllDesignation();
            return new ResponseEntity((Object)designations, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)new ErrorResponse("Failed to retrieve designations", e.getMessage()), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PostMapping(value={"/addDesignation"})
    public ResponseEntity<?> addDesignation(@RequestBody DesignationModel designationModel) {
        try {
            List designations = this.userService.addDesignation(designationModel);
            return new ResponseEntity((Object)designations, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)new ErrorResponse("Failed to add designation", e.getMessage()), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/available"})
    public ResponseEntity<List<RMWithGM>> getAvailableGuides(@RequestParam Long brandId, @RequestParam Long designationId) {
        try {
            List availableGuides = this.userService.getUsersByBrandAndDesignation(brandId, designationId);
            if (availableGuides.isEmpty()) {
                return ResponseEntity.noContent().build();
            }
            return ResponseEntity.ok((Object)availableGuides);
        }
        catch (RuntimeException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Collections.singletonList(new RMWithGM(null, null, null, null)));
        }
    }

    @GetMapping(value={"/gmuser"})
    public ResponseEntity<List<User>> findByBrandIdAndRole(@RequestParam Long bid) {
        try {
            List users = this.userService.findByBrandIdAndRole(bid);
            if (users.isEmpty()) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.NO_CONTENT).body(Collections.emptyList());
            }
            return ResponseEntity.ok((Object)users);
        }
        catch (Exception e) {
            System.err.println("An error occurred while fetching GM users: " + e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Collections.emptyList());
        }
    }

    @GetMapping(value={"/usercustomer"})
    public ResponseEntity<List<User>> getUsersByBrandId(@RequestParam(value="bid") Long brandId, @RequestParam(value="uid") Long id) {
        List users = this.userService.getUsersByBrandId(brandId, id);
        return ResponseEntity.ok((Object)users);
    }

    @PostMapping(value={"/profileupdate"})
    public ResponseEntity<User> updateUserProfile(@RequestBody UserProfileRequest userRequest, @RequestHeader(value="Authorization") String token) {
        try {
            Long id = userRequest.getId();
            User updatedUser = this.userService.updateByUserProfile(id, userRequest, token);
            return ResponseEntity.ok((Object)updatedUser);
        }
        catch (RuntimeException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body(null);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/getallregion"})
    public ResponseEntity<?> getAllRegionsModel() {
        try {
            List regionModel = this.userService.getAllRegion();
            return ResponseEntity.ok((Object)regionModel);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)"Retreive error");
        }
    }

    @PostMapping(value={"/addregion"})
    public ResponseEntity<?> addSubCategory(@RequestBody @Valid UserRegionModel regionModel) {
        try {
            List regionModels = this.userService.addRegions(regionModel);
            return ResponseEntity.ok((Object)regionModels);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)"ADD error");
        }
    }
}

