/*
 * Decompiled with CFR 0.152.
 */
package com.riot.Branding.controller;

import com.riot.Branding.controller.TicketController;
import com.riot.Branding.model.MktgIssuedProductModel;
import com.riot.Branding.model.TicketModel;
import com.riot.Branding.model.TicketStatus;
import com.riot.Branding.model.TicketType;
import com.riot.Branding.request.TicketRequest;
import com.riot.Branding.request.TicketStatusUpdateRequest;
import com.riot.Branding.response.TicketResponse;
import com.riot.Branding.service.AddDeleteGalleryService;
import com.riot.Branding.service.EventGalleryService;
import com.riot.Branding.service.NotificationService;
import com.riot.Branding.service.TicketService;
import com.riot.Branding.service.TicketUpdateStatus;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/tickets"})
public class TicketController {
    @Autowired
    private TicketService ticketService;
    @Autowired
    private EventGalleryService eventGalleryService;
    @Autowired
    private AddDeleteGalleryService addDeleteGalleryService;
    @Autowired
    private NotificationService notificationService;
    @Autowired
    TicketUpdateStatus status;

    @PutMapping(value={"/uploadgallery"})
    public ResponseEntity<?> uploadEventImage1(@RequestParam(value="file") MultipartFile file) {
        return this.eventGalleryService.add(file);
    }

    @PostMapping(value={"/addGalleryImage"})
    public ResponseEntity<?> addImageToGallery(@RequestParam(value="eventid") Long eventId, @RequestParam(value="file") MultipartFile file) {
        return this.addDeleteGalleryService.addImageToGallery(eventId, file);
    }

    @PostMapping(value={"/createticket"})
    public ResponseEntity<?> createTicket(@RequestBody TicketRequest ticketModel, @RequestHeader(value="Authorization") String authorization) {
        try {
            TicketModel createdTicket = this.ticketService.createTicket(ticketModel, authorization);
            return new ResponseEntity((Object)createdTicket, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (RuntimeException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Error creating ticket: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/getbyid"})
    public ResponseEntity<?> getTicketById(@RequestParam Long id, @RequestHeader(value="Authorization") String token) {
        try {
            TicketResponse ticket = this.ticketService.getTicketById(id, token);
            return ResponseEntity.ok((Object)ticket);
        }
        catch (TicketNotFoundException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)("Ticket not found with ID: " + id));
        }
        catch (RuntimeException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Error retrieving ticket: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/getbyuserid"})
    public ResponseEntity<?> getTicketsByIdWithoutvalue(@RequestParam Long id) {
        try {
            TicketModel ticket = this.ticketService.getTicketsByIdWithoutvalue(id);
            return ResponseEntity.ok((Object)ticket);
        }
        catch (TicketNotFoundException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)("Ticket not found with ID: " + id));
        }
        catch (RuntimeException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Error retrieving ticket: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/return"})
    public List<MktgIssuedProductModel> findTicketsByMktgAndStatus(@RequestParam(value="id") Long mktgId) {
        return this.ticketService.findTicketsByMktgAndStatus(mktgId);
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<TicketResponse>> getAllTickets(@RequestHeader(value="Authorization") String token) {
        try {
            List tickets = this.ticketService.getAllTicketsRoleBased(token);
            return ResponseEntity.ok((Object)tickets);
        }
        catch (RuntimeException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/getalltickets"})
    public ResponseEntity<List<TicketModel>> getAllwithoutvalueTickets() {
        try {
            List tickets = this.ticketService.findAllTickets();
            return ResponseEntity.ok((Object)tickets);
        }
        catch (RuntimeException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PostMapping(value={"/updateticket"})
    public ResponseEntity<?> updateTicket(@RequestBody TicketRequest ticketModel, @RequestHeader(value="Authorization") String authorization) {
        System.err.println("not enter");
        Long id = ticketModel.getId();
        try {
            System.err.println("ENTER");
            TicketModel updatedTicket = this.ticketService.updateTicket(id, ticketModel, authorization);
            return ResponseEntity.ok((Object)updatedTicket);
        }
        catch (TicketNotFoundException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)("Ticket not found with ID: " + id));
        }
        catch (RuntimeException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Error updating ticket: " + e.getMessage()));
        }
    }

    @DeleteMapping(value={"/delete"})
    public ResponseEntity<?> deleteTicket(@RequestParam(value="id") Long id) {
        try {
            this.ticketService.deleteTicket(id);
            return ResponseEntity.noContent().build();
        }
        catch (TicketNotFoundException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)("Ticket not found with ID: " + id));
        }
        catch (RuntimeException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Error deleting ticket: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/updateticketstatus"})
    public ResponseEntity<?> updateTicketStatus(@RequestBody TicketStatusUpdateRequest request, @RequestHeader(value="Authorization") String token) {
        try {
            System.err.println("enter1");
            Long ticketId = request.getTicketId();
            String responseMessage = this.status.updateTicketStatus(ticketId, request, token);
            return ResponseEntity.ok((Object)responseMessage);
        }
        catch (RuntimeException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)e.getMessage());
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An unexpected error occurred: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/showticket"})
    public ResponseEntity<?> getPendingTicketsForAdmin(@RequestHeader(value="Authorization") String authorization) {
        try {
            List pendingTickets = this.ticketService.getPendingTicketsForAdmin(authorization);
            return ResponseEntity.ok((Object)pendingTickets);
        }
        catch (RuntimeException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)e.getMessage());
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/statuses"})
    public ResponseEntity<List<TicketStatus>> getAllTicketStatuses(@RequestHeader(value="Authorization") String token) {
        try {
            List statuses = this.ticketService.getTicketStatusesByRole(token);
            return ResponseEntity.ok((Object)statuses);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Arrays.asList(TicketStatus.PENDING));
        }
    }

    @GetMapping(value={"/allstatus"})
    public ResponseEntity<List<TicketStatus>> getAllTicketStatus() {
        try {
            List<TicketStatus> types = Arrays.asList(TicketStatus.values());
            return ResponseEntity.ok(types);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Collections.singletonList((TicketStatus)TicketType.valueOf(null, null)));
        }
    }

    @GetMapping(value={"/tickettype"})
    public ResponseEntity<List<TicketType>> getAllTicketType() {
        try {
            List<TicketType> types = Arrays.asList(TicketType.values());
            return ResponseEntity.ok(types);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Collections.singletonList((TicketType)TicketType.valueOf(null, null)));
        }
    }

    @GetMapping(value={"/findbystatus"})
    public ResponseEntity<?> getTicketsByStatus(@RequestParam TicketStatus status) {
        try {
            List tickets = this.ticketService.findByStatus(status);
            return new ResponseEntity((Object)tickets, (HttpStatusCode)HttpStatus.OK);
        }
        catch (RuntimeException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Error retrieving tickets: " + e.getMessage()));
        }
    }

    @Generated
    public TicketController() {
    }
}

