/*
 * Decompiled with CFR 0.152.
 */
package com.riot.Branding.controller;

import com.riot.Branding.controller.StockController;
import com.riot.Branding.model.StockMainCategoryModel;
import com.riot.Branding.model.StockModel;
import com.riot.Branding.model.StockSubCategory;
import com.riot.Branding.model.StockUpdateModel;
import com.riot.Branding.model.TicketType;
import com.riot.Branding.request.StockUpdateRequest;
import com.riot.Branding.response.StockUpdateResponse;
import com.riot.Branding.service.StockService;
import jakarta.validation.Valid;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/stocks"})
public class StockController {
    @Autowired
    private StockService stockService;

    @PostMapping(value={"/create"})
    public ResponseEntity<StockUpdateModel> createStock(@RequestBody StockUpdateRequest stockRequest) {
        try {
            System.err.println("sddfdv");
            StockUpdateModel createdStock = this.stockService.createStock(stockRequest);
            return new ResponseEntity((Object)createdStock, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (RuntimeException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<StockUpdateResponse>> getAllStocks() {
        try {
            List stocks = this.stockService.getAllStocks();
            return ResponseEntity.ok((Object)stocks);
        }
        catch (RuntimeException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/getallupdatestock"})
    public ResponseEntity<List<StockUpdateResponse>> getAllupdatedStocks() {
        try {
            List stocks = this.stockService.getAllUpdatedStocks();
            return ResponseEntity.ok((Object)stocks);
        }
        catch (RuntimeException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/gettype"})
    public List<StockUpdateResponse> getStockByType(@RequestParam TicketType type) {
        try {
            return this.stockService.getStockByType(type);
        }
        catch (StockNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Stock not found with type: " + type, (Throwable)e);
        }
        catch (RuntimeException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Error retrieving stock: " + e.getMessage(), (Throwable)e);
        }
    }

    @GetMapping(value={"/get"})
    public ResponseEntity<?> getStockById(@RequestParam Long id) {
        try {
            StockModel stock = this.stockService.getStockById(id);
            return ResponseEntity.ok((Object)stock);
        }
        catch (StockNotFoundException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)("Stock not found with ID: " + id));
        }
        catch (RuntimeException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Error retrieving stock: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/getupdatedstock"})
    public ResponseEntity<?> getupdatedStockById(@RequestParam Long id) {
        try {
            return this.stockService.getUpdatedStockById(id);
        }
        catch (StockNotFoundException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)("Stock not found with ID: " + id));
        }
        catch (RuntimeException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Error retrieving stock: " + e.getMessage()));
        }
    }

    @DeleteMapping(value={"/delete"})
    public ResponseEntity<String> deleteStock(@RequestParam Long id) {
        try {
            this.stockService.deleteStock(id);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NO_CONTENT).body((Object)"Stock deleted successfully.");
        }
        catch (StockNotFoundException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)("Stock not found with ID: " + id));
        }
        catch (RuntimeException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Error deleting stock: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/getallcategory"})
    public ResponseEntity<?> getAllCategory() {
        try {
            List categories = this.stockService.getAllCategory();
            return ResponseEntity.ok((Object)categories);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)"Retreive error");
        }
    }

    @PostMapping(value={"/addcategory"})
    public ResponseEntity<?> addCategory(@RequestBody @Valid StockMainCategoryModel categoryModel) {
        try {
            List categories = this.stockService.addCategory(categoryModel);
            return ResponseEntity.ok((Object)categories);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)"ADD error");
        }
    }

    @GetMapping(value={"/getallsubcategory"})
    public ResponseEntity<?> getAllSubCategory() {
        try {
            List categories = this.stockService.getAllSubCategory();
            return ResponseEntity.ok((Object)categories);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)"Retreive error");
        }
    }

    @PostMapping(value={"/addsubcategory"})
    public ResponseEntity<?> addSubCategory(@RequestBody @Valid StockSubCategory categoryModel) {
        try {
            List categories = this.stockService.addSubCategory(categoryModel);
            return ResponseEntity.ok((Object)categories);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)"ADD error");
        }
    }

    @GetMapping(value={"/getbyCustomerid"})
    public ResponseEntity<?> getStocksBYId(@RequestParam Long id) {
        try {
            List stock = this.stockService.getStocksBYId(id);
            return ResponseEntity.ok((Object)stock);
        }
        catch (StockNotFoundException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)("Stock not found with ID: " + id));
        }
        catch (RuntimeException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Error retrieving stock: " + e.getMessage()));
        }
    }
}

