/*
 * Decompiled with CFR 0.152.
 */
package com.riot.Branding.controller;

import com.riot.Branding.model.District;
import com.riot.Branding.model.State;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class StateController {
    private List<State> states = new ArrayList();
    private Map<String, List<District>> districtMap = new HashMap();
    private long currentId = 1L;
    private long districtId = 1L;

    public StateController() {
        this.addState("Andhra Pradesh");
        this.addState("Arunachal Pradesh");
        this.addState("Assam");
        this.addState("Bihar");
        this.addState("Chhattisgarh");
        this.addState("Goa");
        this.addState("Gujarat");
        this.addState("Haryana");
        this.addState("Himachal Pradesh");
        this.addState("Jammu and Kashmir");
        this.addState("Jharkhand");
        this.addState("Karnataka");
        this.addState("Kerala");
        this.addState("Madhya Pradesh");
        this.addState("Maharashtra");
        this.addState("Manipur");
        this.addState("Meghalaya");
        this.addState("Mizoram");
        this.addState("Nagaland");
        this.addState("Odisha");
        this.addState("Punjab");
        this.addState("Rajasthan");
        this.addState("Tamil Nadu");
        this.addState("Telangana");
        this.addState("Tripura");
        this.addState("Uttar Pradesh");
        this.addState("Uttarakhand");
        this.addState("West Bengal");
        this.addState("Andaman and Nicobar Islands");
        this.addState("Chandigarh");
        this.addState("Dadra and Nagar Haveli and Daman and Diu");
        this.addState("Lakshadweep");
        this.addState("Delhi");
        this.addState("Puducherry");
        this.addDistrict("Tamil Nadu", "Ariyalur");
        this.addDistrict("Tamil Nadu", "Chengalpattu");
        this.addDistrict("Tamil Nadu", "Chennai");
        this.addDistrict("Tamil Nadu", "Coimbatore");
        this.addDistrict("Tamil Nadu", "Cuddalore");
        this.addDistrict("Tamil Nadu", "Dharmapuri");
        this.addDistrict("Tamil Nadu", "Dindigul");
        this.addDistrict("Tamil Nadu", "Erode");
        this.addDistrict("Tamil Nadu", "Kallakurichi");
        this.addDistrict("Tamil Nadu", "Kanchipuram");
        this.addDistrict("Tamil Nadu", "Karur");
        this.addDistrict("Tamil Nadu", "Krishnagiri");
        this.addDistrict("Tamil Nadu", "Madurai");
        this.addDistrict("Tamil Nadu", "Mayiladuthurai");
        this.addDistrict("Tamil Nadu", "Nagapattinam");
        this.addDistrict("Tamil Nadu", "Kanyakumari");
        this.addDistrict("Tamil Nadu", "Namakkal");
        this.addDistrict("Tamil Nadu", "Perambalur");
        this.addDistrict("Tamil Nadu", "Pudukottai");
        this.addDistrict("Tamil Nadu", "Ramanathapuram");
        this.addDistrict("Tamil Nadu", "Ranipet");
        this.addDistrict("Tamil Nadu", "Salem");
        this.addDistrict("Tamil Nadu", "Sivagangai");
        this.addDistrict("Tamil Nadu", "Tenkasi");
        this.addDistrict("Tamil Nadu", "Thanjavur");
        this.addDistrict("Tamil Nadu", "Theni");
        this.addDistrict("Tamil Nadu", "Thiruvallur");
        this.addDistrict("Tamil Nadu", "Thiruvarur");
        this.addDistrict("Tamil Nadu", "Tuticorin");
        this.addDistrict("Tamil Nadu", "Trichirappalli");
        this.addDistrict("Tamil Nadu", "Thirunelveli");
        this.addDistrict("Tamil Nadu", "Tirupattur");
        this.addDistrict("Tamil Nadu", "Tiruppur");
        this.addDistrict("Tamil Nadu", "Thiruvannamalai");
        this.addDistrict("Tamil Nadu", "The Nilgiris");
        this.addDistrict("Tamil Nadu", "Vellore");
        this.addDistrict("Tamil Nadu", "Viluppuram");
        this.addDistrict("Tamil Nadu", "Virudhunagar");
    }

    private void addState(String name) {
        this.states.add(new State(this.currentId++, name));
    }

    private void addDistrict(String stateName, String districtName) {
        this.districtMap.putIfAbsent(stateName, new ArrayList());
        ((List)this.districtMap.get(stateName)).add(new District(this.districtId++, districtName));
    }

    @PutMapping(value={"/api/states"})
    public List<State> getAllStates() {
        return this.states;
    }

    @PutMapping(value={"/api/districts"})
    public List<District> getDistrictsByState(@RequestParam(value="state") String stateName) {
        return this.districtMap.getOrDefault(stateName, new ArrayList());
    }
}

