/*
 * Decompiled with CFR 0.152.
 */
package com.riot.Branding.controller;

import com.riot.Branding.request.CustomerDTO;
import com.riot.Branding.request.FilterRequest;
import com.riot.Branding.request.VendorRequest;
import com.riot.Branding.response.StockUpdateResponse;
import com.riot.Branding.response.TicketResponse;
import com.riot.Branding.response.UserFieldResponse;
import com.riot.Branding.service.FilterService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/filter"})
public class FilterController {
    @Autowired
    private FilterService filterService;

    @PostMapping(value={"/customerfilter"})
    public ResponseEntity<List<CustomerDTO>> filterCustomers(@RequestBody FilterRequest filterRequest, @RequestHeader(value="Authorization") String token) {
        List filteredCustomers = this.filterService.filterCustomer(filterRequest, token);
        return ResponseEntity.ok((Object)filteredCustomers);
    }

    @PostMapping(value={"/userfilter"})
    public ResponseEntity<List<UserFieldResponse>> filterUsers(@RequestBody FilterRequest filterRequest, @RequestHeader(value="Authorization") String token) {
        List filteredUsers = this.filterService.filterUsers(filterRequest, token);
        return ResponseEntity.ok((Object)filteredUsers);
    }

    @PostMapping(value={"/vendorfilter"})
    public ResponseEntity<List<VendorRequest>> filterVendors(@RequestBody FilterRequest filterRequest, @RequestHeader(value="Authorization") String token) {
        List filteredUsers = this.filterService.filterVendors(filterRequest, token);
        return ResponseEntity.ok((Object)filteredUsers);
    }

    @PostMapping(value={"/ticketfilter"})
    public ResponseEntity<List<TicketResponse>> filterTickets(@RequestBody FilterRequest filterRequest, @RequestHeader(value="Authorization") String token) {
        List filteredUsers = this.filterService.filterTicket(filterRequest, token);
        return ResponseEntity.ok((Object)filteredUsers);
    }

    @PostMapping(value={"/stockfilter"})
    public ResponseEntity<List<StockUpdateResponse>> filterStock(@RequestBody FilterRequest filterRequest, @RequestHeader(value="Authorization") String token) {
        List filteredUsers = this.filterService.filterStock(filterRequest, token);
        return ResponseEntity.ok((Object)filteredUsers);
    }

    @PostMapping(value={"/updatestockfilter"})
    public ResponseEntity<List<StockUpdateResponse>> filterUpdatedStock(@RequestBody FilterRequest filterRequest, @RequestHeader(value="Authorization") String token) {
        List filteredUsers = this.filterService.filterUpdatedStock(filterRequest, token);
        return ResponseEntity.ok((Object)filteredUsers);
    }
}

