/*
 * Decompiled with CFR 0.152.
 */
package com.riot.Branding.controller;

import com.riot.Branding.model.TicketModel;
import com.riot.Branding.model.TicketStatus;
import com.riot.Branding.request.FilterRequest;
import com.riot.Branding.service.CustomerService;
import com.riot.Branding.service.DashboardService;
import com.riot.Branding.service.ExcelExportService;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dashboards"})
public class DashboardController {
    @Autowired
    private DashboardService dashboardService;
    @Autowired
    private ExcelExportService excelExportService;
    @Autowired
    private CustomerService customerService;

    @GetMapping(value={"/stats"})
    public ResponseEntity<Map<String, Long>> getMemberStats(@RequestHeader(value="Authorization") String token) {
        try {
            HashMap<String, Long> stats = new HashMap<String, Long>();
            stats.put("totalCustomers", this.dashboardService.getTotalCustomers(token));
            stats.put("totalPendingTickets", this.dashboardService.getPendingTickets(token));
            stats.put("totalTickets", this.dashboardService.getTotalTickets(token));
            return ResponseEntity.ok(stats);
        }
        catch (Exception e) {
            HashMap<String, Long> errorResponse = new HashMap<String, Long>();
            errorResponse.put("error", -1L);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(errorResponse);
        }
    }

    @GetMapping(value={"/statuscount"})
    public ResponseEntity<Map<TicketStatus, Long>> getTotalTicketsCountByStatus(@RequestHeader(value="Authorization") String token) {
        try {
            Map countByStatus = this.dashboardService.getTotalTicketsByStatus(token);
            return ResponseEntity.ok((Object)countByStatus);
        }
        catch (Exception e) {
            HashMap<TicketStatus, Long> errorResponse = new HashMap<TicketStatus, Long>();
            errorResponse.put(TicketStatus.UNKNOWN, -1L);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(errorResponse);
        }
    }

    @GetMapping(value={"/descount"})
    public ResponseEntity<Map<String, Long>> getTotalUsersDesignation(@RequestHeader(value="Authorization") String token) {
        try {
            Map countByDesignation = this.dashboardService.getUsersDesignation(token);
            return ResponseEntity.ok((Object)countByDesignation);
        }
        catch (Exception e) {
            HashMap<String, Long> errorResponse = new HashMap<String, Long>();
            errorResponse.put("error", -1L);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(errorResponse);
        }
    }

    @GetMapping(value={"/last10"})
    public ResponseEntity<List<TicketModel>> getLast10PendingTickets(@RequestHeader(value="Authorization") String token) {
        try {
            List tickets = this.dashboardService.getLast10PendingTickets(token);
            return ResponseEntity.ok((Object)tickets);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(List.of());
        }
    }

    @GetMapping(value={"/download-user-report"})
    public ResponseEntity<Resource> downloadUserReport(@ModelAttribute FilterRequest filterRequest, @RequestHeader(value="Authorization") String token) {
        String csvContent = this.excelExportService.generateUserCSV(filterRequest, token);
        ByteArrayInputStream csvStream = new ByteArrayInputStream(csvContent.getBytes(StandardCharsets.UTF_8));
        InputStreamResource resource = new InputStreamResource((InputStream)csvStream);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=User_Report.csv"})).contentType(MediaType.parseMediaType((String)"text/csv")).body((Object)resource);
    }

    @GetMapping(value={"/download-customer-report"})
    public ResponseEntity<Resource> downloadCustomerReport(@ModelAttribute FilterRequest filterRequest, @RequestHeader(value="Authorization") String token) {
        String csvContent = this.excelExportService.generateCustomerFilterCSV(filterRequest, token);
        ByteArrayInputStream csvStream = new ByteArrayInputStream(csvContent.getBytes(StandardCharsets.UTF_8));
        InputStreamResource resource = new InputStreamResource((InputStream)csvStream);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=Customer_Report.csv"})).contentType(MediaType.parseMediaType((String)"text/csv")).body((Object)resource);
    }

    @GetMapping(value={"/download-vendor-report"})
    public ResponseEntity<Resource> downloadVendorReport(@ModelAttribute FilterRequest filterRequest) {
        String csvContent = this.excelExportService.generateVendorFilterCSV(filterRequest);
        ByteArrayInputStream csvStream = new ByteArrayInputStream(csvContent.getBytes(StandardCharsets.UTF_8));
        InputStreamResource resource = new InputStreamResource((InputStream)csvStream);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=Vendor_Report.csv"})).contentType(MediaType.parseMediaType((String)"text/csv")).body((Object)resource);
    }

    @GetMapping(value={"/download-tickets-report"})
    public ResponseEntity<Resource> downloadTicketReport(@ModelAttribute FilterRequest filterRequest, @RequestHeader(value="Authorization") String token) throws IOException {
        System.out.println("enter1");
        InputStreamResource excelFile = this.excelExportService.generateTicketFilterCSV(filterRequest, token);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=Tickets_Report.xlsx"})).contentType(MediaType.parseMediaType((String)"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet")).body((Object)excelFile);
    }

    @GetMapping(value={"/download-stock-report"})
    public ResponseEntity<Resource> downloadStockReport(@ModelAttribute FilterRequest filterRequest) {
        System.out.println("enter1");
        String csvContent = this.excelExportService.generateStockFilterCSV(filterRequest);
        ByteArrayInputStream csvStream = new ByteArrayInputStream(csvContent.getBytes(StandardCharsets.UTF_8));
        InputStreamResource resource = new InputStreamResource((InputStream)csvStream);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=Stocks_Report.csv"})).contentType(MediaType.parseMediaType((String)"text/csv")).body((Object)resource);
    }

    @GetMapping(value={"/download-updatedstock-report"})
    public ResponseEntity<Resource> downloadUpdatedStockReport(@ModelAttribute FilterRequest filterRequest) {
        System.out.println("enter1");
        String csvContent = this.excelExportService.generateUpdatedStockFilterCSV(filterRequest);
        ByteArrayInputStream csvStream = new ByteArrayInputStream(csvContent.getBytes(StandardCharsets.UTF_8));
        InputStreamResource resource = new InputStreamResource((InputStream)csvStream);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=Stocks_Report.csv"})).contentType(MediaType.parseMediaType((String)"text/csv")).body((Object)resource);
    }

    @GetMapping(value={"/download-bdaycustomer-report"})
    public ResponseEntity<byte[]> getFilteredListAndDownload(@RequestParam String type, @RequestParam String range) throws IOException {
        Map filteredList = this.customerService.getFilteredList(type, range);
        ByteArrayInputStream inputStream = this.excelExportService.generateCSV(filteredList);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Disposition", "attachment; filename=filtered_data.csv");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)inputStream.readAllBytes());
    }

    @PostMapping(value={"/download-updatestockfilter"})
    public ResponseEntity<byte[]> downloadReport(@RequestBody FilterRequest filterRequest, @RequestHeader(value="Authorization") String token) throws IOException {
        return this.excelExportService.downloadReportforMktgandUser(filterRequest);
    }
}

