/*
 * Decompiled with CFR 0.152.
 */
package com.riot.Branding.controller;

import com.riot.Branding.model.CustomerCategoryModel;
import com.riot.Branding.model.CustomerDesignationModel;
import com.riot.Branding.model.CustomerGroup;
import com.riot.Branding.model.CustomerMartialModel;
import com.riot.Branding.model.CustomerModel;
import com.riot.Branding.model.CustomerSubCategoryModel;
import com.riot.Branding.request.CustomerMartialDTO;
import com.riot.Branding.request.CustomerRequest;
import com.riot.Branding.service.CustomerService;
import jakarta.validation.Valid;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/customers"})
public class CustomerController {
    @Autowired
    private CustomerService customerService;

    @GetMapping(value={"/check-email"})
    public ResponseEntity<?> checkEmail(@RequestParam String email) {
        try {
            return this.customerService.checkEmailExists(email);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)("Error checking email: " + e.getMessage()), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/check-mobile"})
    public ResponseEntity<?> checkMobile(@RequestParam Long mobile) {
        try {
            return this.customerService.checkMobileExists(mobile);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)("Error checking mobile number: " + e.getMessage()), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/check-email-customer"})
    public ResponseEntity<?> checkEmailMartial(@RequestParam String email) {
        try {
            return this.customerService.checkEmailExistsmartial(email);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)("Error checking email: " + e.getMessage()), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/check-mobile-customer"})
    public ResponseEntity<?> checkMobileMartial(@RequestParam Long mobile) {
        try {
            return this.customerService.checkMobileExistsmartialDetails(mobile);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)("Error checking mobile number: " + e.getMessage()), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PostMapping(value={"/add"})
    public ResponseEntity<?> addCustomer(@Valid @RequestBody CustomerRequest request) {
        try {
            CustomerModel newCustomer = this.customerService.addCustomer(request);
            return new ResponseEntity((Object)newCustomer, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)("Error creating customer: " + e.getMessage()), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/getbyid"})
    public ResponseEntity<Object> getCustomerById(@RequestParam(value="id") Long id) {
        try {
            Optional customer = this.customerService.getCustomerById(id);
            if (customer.isPresent()) {
                return ResponseEntity.ok(customer.get());
            }
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)"Customer not found");
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Error retrieving customer: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/all"})
    public ResponseEntity<?> getAllCustomers(@RequestHeader(value="Authorization") String token) {
        try {
            List customers = this.customerService.getAllCustomers(token);
            return new ResponseEntity((Object)customers, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)("Error retrieving customers: " + e.getMessage()), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<?> updateCustomer(@Valid @RequestBody CustomerRequest request) {
        try {
            Long id = request.getId();
            CustomerModel updatedCustomer = this.customerService.updateCustomer(id, request);
            return new ResponseEntity((Object)updatedCustomer, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)("Error updating customer: " + e.getMessage()), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PostMapping(value={"/updatestatus"})
    public ResponseEntity<?> updateCustomerStatus(@RequestBody CustomerRequest request) {
        try {
            Long id = request.getId();
            CustomerModel updatedCustomer = this.customerService.updateCustomerStatus(id, request);
            return new ResponseEntity((Object)updatedCustomer, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)("Error updating customer: " + e.getMessage()), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @DeleteMapping(value={"/delete"})
    public ResponseEntity<?> deleteCustomer(@RequestParam(value="id") Long id) {
        try {
            this.customerService.deleteCustomer(id);
            return new ResponseEntity((Object)"Customer deleted successfully", (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)("Error deleting customer: " + e.getMessage()), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/getallcategory"})
    public ResponseEntity<?> getAllCategory() {
        try {
            List categories = this.customerService.getAllCategory();
            return new ResponseEntity((Object)categories, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)("Error retrieving categories: " + e.getMessage()), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PostMapping(value={"/addcategory"})
    public ResponseEntity<?> addCategory(@RequestBody CustomerCategoryModel categoryModel) {
        try {
            List categories = this.customerService.addCategory(categoryModel);
            return new ResponseEntity((Object)categories, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)("Error adding category: " + e.getMessage()), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/getallsubcategory"})
    public ResponseEntity<?> getAllSubCategory() {
        try {
            List subcategories = this.customerService.getAllSubCategory();
            return new ResponseEntity((Object)subcategories, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)("Error retrieving subcategories: " + e.getMessage()), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PostMapping(value={"/addsubcategory"})
    public ResponseEntity<?> addSubCategory(@RequestBody CustomerSubCategoryModel subCategoryModel) {
        try {
            List subcategories = this.customerService.addSubCategory(subCategoryModel);
            return new ResponseEntity((Object)subcategories, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)("Error adding subcategory: " + e.getMessage()), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/findbyuser"})
    public ResponseEntity<?> findByMktgRef(@RequestParam(value="id") Long mktgRef) {
        try {
            List customers = this.customerService.findByMktgRef(mktgRef);
            return new ResponseEntity((Object)customers, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)("Error finding customers by marketing reference: " + e.getMessage()), (HttpStatusCode)HttpStatus.NO_CONTENT);
        }
    }

    @GetMapping(value={"/findbyregion"})
    public ResponseEntity<?> findbyregion(@RequestParam(value="region") String region) {
        try {
            List customers = this.customerService.findbyregion(region);
            return new ResponseEntity((Object)customers, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)("Error finding customers by marketing reference: " + e.getMessage()), (HttpStatusCode)HttpStatus.NO_CONTENT);
        }
    }

    @GetMapping(value={"/birthdays"})
    public ResponseEntity<?> getBirthdaysToday() {
        try {
            List birthdays = this.customerService.getBirthdayCustomers(LocalDate.now());
            return new ResponseEntity((Object)birthdays, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)("Error retrieving birthday customers: " + e.getMessage()), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/upcoming-birthdays"})
    public ResponseEntity<List<CustomerMartialModel>> getUpcomingBirthdays() {
        List upcomingBirthdays = this.customerService.getUpcomingBirthdays();
        return ResponseEntity.ok((Object)upcomingBirthdays);
    }

    @GetMapping(value={"/getAllDesignation"})
    public ResponseEntity<?> getAllDesignations() {
        try {
            List designations = this.customerService.getAllDesignation();
            return new ResponseEntity((Object)designations, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)("Error retrieving designations: " + e.getMessage()), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PostMapping(value={"/addDesignation"})
    public ResponseEntity<?> addDesignation(@RequestBody CustomerDesignationModel designationModel) {
        try {
            List designations = this.customerService.addDesignation(designationModel);
            return new ResponseEntity((Object)designations, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)("Error adding designation: " + e.getMessage()), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/getallcusgroup"})
    public ResponseEntity<?> getAllCustomerGroups() {
        try {
            List customerGroups = this.customerService.getAllCusgroup();
            return new ResponseEntity((Object)customerGroups, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)("Error retrieving customer groups: " + e.getMessage()), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PostMapping(value={"/addcusgroup"})
    public ResponseEntity<?> addCustomerGroup(@RequestBody CustomerGroup customerGroup) {
        try {
            List updatedGroups = this.customerService.addCustomerGroup(customerGroup);
            return new ResponseEntity((Object)updatedGroups, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)("Error adding customer group: " + e.getMessage()), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/m-bday"})
    public List<CustomerMartialModel> getMonthlyBirthdays() {
        return this.customerService.getBirthdaysForCurrentMonth();
    }

    @GetMapping(value={"/m-anni"})
    public List<CustomerMartialModel> getMonthlyAnniversaries() {
        return this.customerService.getAnniversariesForCurrentMonth();
    }

    @GetMapping(value={"/c-bday"})
    public Long getTodayBirthdayCount() {
        return this.customerService.getTodayBirthdayCount();
    }

    @GetMapping(value={"/c-anni"})
    public Long getTodayAnniversaryCount() {
        return this.customerService.getTodayAnniversaryCount();
    }

    @GetMapping(value={"/filtered-list"})
    public ResponseEntity<Map<String, List<CustomerMartialDTO>>> getFilteredBirthdaysAndAnniversaries(@RequestParam(required=false, defaultValue="both") String type, @RequestParam(required=false, defaultValue="current") String range) {
        Map response = this.customerService.getFilteredList(type, range);
        return ResponseEntity.ok((Object)response);
    }
}

