/*
 * Decompiled with CFR 0.152.
 */
package com.riot.Branding.controller;

import com.riot.Branding.request.CompanyRequest;
import com.riot.Branding.service.CompanyService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/company"})
public class CompanyController {
    @Autowired
    private CompanyService companyService;

    @PostMapping(value={"/add"})
    public ResponseEntity<?> addCompany(@RequestBody CompanyRequest request) {
        try {
            ResponseEntity response = this.companyService.addCompany(request);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body(response.getBody());
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred while adding the company: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<?> updateCompany(@RequestBody CompanyRequest request) {
        try {
            ResponseEntity response = this.companyService.updateCompany(request);
            return ResponseEntity.ok((Object)response.getBody());
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred while updating the company: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/find"})
    public ResponseEntity<?> findCompanyById(@RequestParam(value="id") Long id) {
        try {
            ResponseEntity response = this.companyService.findCompanyById(id);
            if (response.getStatusCode() == HttpStatus.NOT_FOUND) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)("Company with ID " + id + " not found."));
            }
            return ResponseEntity.ok((Object)response.getBody());
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred while finding the company: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/findall"})
    public ResponseEntity<?> findAllCompany() {
        try {
            List companies = this.companyService.findAllCompany();
            if (companies.isEmpty()) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.NO_CONTENT).body((Object)"No companies found.");
            }
            return ResponseEntity.ok((Object)companies);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred while retrieving all companies: " + e.getMessage()));
        }
    }

    @DeleteMapping(value={"/delete"})
    public ResponseEntity<?> deleteCompanyById(@RequestParam(value="id") Long id) {
        try {
            ResponseEntity response = this.companyService.deleteCompanyById(id);
            if (response.getStatusCode() == HttpStatus.NOT_FOUND) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)("Company with ID " + id + " not found."));
            }
            return ResponseEntity.ok((Object)response.getBody());
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred while deleting the company: " + e.getMessage()));
        }
    }
}

