/*
 * Decompiled with CFR 0.152.
 */
package com.riot.Branding.controller;

import com.riot.Branding.model.BrandModel;
import com.riot.Branding.service.BrandService;
import com.riot.Branding.service.UserPhotoService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/brands"})
public class BrandController {
    @Autowired
    private BrandService brandService;
    @Autowired
    UserPhotoService photoService;

    @PostMapping(value={"/uploadphoto"})
    public ResponseEntity<?> addProfile(@RequestParam(value="file") MultipartFile file) {
        try {
            return this.photoService.addProfile(file);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred while adding the brand image: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/add"})
    public ResponseEntity<?> addCompany(@RequestBody BrandModel request) {
        try {
            BrandModel newBrand = this.brandService.addBrand(request);
            return new ResponseEntity((Object)newBrand, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred while adding the brand: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<?> updateBrand(@RequestBody BrandModel request) {
        try {
            ResponseEntity updateResponse = this.brandService.updateBrand(request);
            return new ResponseEntity(updateResponse.getBody(), updateResponse.getStatusCode());
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred while updating the brand: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/find"})
    public ResponseEntity<?> findBrandById(@RequestParam(value="id") Long id) {
        try {
            ResponseEntity brandModel = this.brandService.findBrandById(id);
            return new ResponseEntity(brandModel.getBody(), brandModel.getStatusCode());
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred while finding the brand: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/findall"})
    public ResponseEntity<?> findAllBrand() {
        try {
            List brandModels = this.brandService.findAllBrand();
            if (brandModels.isEmpty()) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.NO_CONTENT).body((Object)"No brands found.");
            }
            return ResponseEntity.ok((Object)brandModels);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred while retrieving all brands: " + e.getMessage()));
        }
    }

    @DeleteMapping(value={"/delete"})
    public ResponseEntity<?> deleteBrandById(@RequestParam(value="id") Long id) {
        try {
            return this.brandService.deleteBrandById(id);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred while deleting the brand: " + e.getMessage()));
        }
    }
}

